/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: GetEntities.java 659 2012-09-14 10:18:34Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-1.2/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/dbeditor/GetEntities.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.dbeditor;

import fr.ifremer.echobase.entities.EchoBaseEntityEnum;
import fr.ifremer.echobase.entities.ImportLog;
import fr.ifremer.echobase.entities.ImportType;
import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.services.DbEditorService;
import fr.ifremer.echobase.services.DecoratorService;
import fr.ifremer.echobase.services.EchoBaseServiceSupport;
import fr.ifremer.echobase.ui.actions.AbstractJSONPaginedAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.decorator.Decorator;

import java.util.Map;

/**
 * To obtain the data for the given request.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class GetEntities extends AbstractJSONPaginedAction {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log = LogFactory.getLog(GetEntities.class);

    /** Type of entity to load. */
    protected EchoBaseEntityEnum entityType;

    /** Datas of the given table. */
    protected Map<?, ?>[] datas;

    public void setEntityType(EchoBaseEntityEnum entityType) {
        this.entityType = entityType;
    }

    public Map<?, ?>[] getDatas() {
        return datas;
    }

    @Override
    public String execute() throws Exception {

        Boolean ascendantOrder = isSortAscendant();
        String sortColumn = getSortColumn();

        initFilter();

        if (log.isDebugEnabled()) {
            log.debug("filters      = " + getFilters());
            log.debug("sidx         = " + sortColumn);
            log.debug("sord         = " + ascendantOrder);
        }

        datas = getService(DbEditorService.class).getData(entityType, pager);

        if (log.isDebugEnabled()) {
            log.debug("Total page = " + getTotal());
        }

        return SUCCESS;
    }


    public String entityModificationLogs() throws Exception {
        entityType = EchoBaseEntityEnum.EntityModificationLog;
        execute();
        return SUCCESS;
    }

    public String entityImportLogs() throws Exception {
        entityType = EchoBaseEntityEnum.ImportLog;
        execute();
        Map<String, String> importTypes = decorateEnums(ImportType.values());

        Decorator<Voyage> voyageDecorator =
                getService(DecoratorService.class).getDecorator(
                        getLocale(), Voyage.class, null);

        EchoBaseServiceSupport service =
                getService(EchoBaseServiceSupport.class);

        for (Map row : datas) {

            String importType = (String) row.get(ImportLog.PROPERTY_IMPORT_TYPE);
            String importTypeToString = importTypes.get(importType);
            row.put(ImportLog.PROPERTY_IMPORT_TYPE, importTypeToString);
            String voyageId = (String) row.get(ImportLog.PROPERTY_VOYAGE_ID);
            Voyage voyage = service.getEntityById(Voyage.class, voyageId);
            String voyageToString = voyageDecorator.toString(voyage);
            row.put("voyage", voyageToString);

        }
        return SUCCESS;
    }
}
