/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.importData;

import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.entities.references.AreaOfOperation;
import fr.ifremer.echobase.entities.references.Mission;
import fr.ifremer.echobase.services.importdata.CommonImportConfiguration;
import fr.ifremer.echobase.services.importdata.CommonImportMode;
import fr.ifremer.echobase.ui.actions.importData.AbstractConfigureImport;
import java.io.File;
import java.util.Map;

public class ConfigureCommonImport
extends AbstractConfigureImport<CommonImportConfiguration> {
    private static final long serialVersionUID = 1L;
    protected Map<String, String> missions;
    protected Map<String, String> voyages;
    protected Map<String, String> areaOfOperations;
    protected Map<String, String> importModes;

    public ConfigureCommonImport() {
        super(CommonImportConfiguration.class);
    }

    protected CommonImportConfiguration createModel() {
        return new CommonImportConfiguration(this.getLocale());
    }

    protected void prepareInputAction(CommonImportConfiguration model) {
        this.missions = this.loadSortAndDecorate(Mission.class);
        this.voyages = this.loadSortAndDecorate(Voyage.class);
        this.areaOfOperations = this.loadSortAndDecorate(AreaOfOperation.class);
        this.importModes = this.decorateEnums((Enum[])CommonImportMode.values());
        if (model.getImportMode() == null) {
            model.setImportMode(CommonImportMode.ALL);
        }
    }

    @InputConfig(methodName="input")
    public String modeAll() throws Exception {
        return this.execute();
    }

    @InputConfig(methodName="input")
    public String modeTransect() throws Exception {
        return this.execute();
    }

    public Map<String, String> getMissions() {
        return this.missions;
    }

    public Map<String, String> getVoyages() {
        return this.voyages;
    }

    public Map<String, String> getAreaOfOperations() {
        return this.areaOfOperations;
    }

    public Map<String, String> getImportModes() {
        return this.importModes;
    }

    public void setVoyageFile(File file) {
        ((CommonImportConfiguration)this.getModel()).getVoyageFile().setFile(file);
    }

    public void setVoyageFileContentType(String contentType) {
        ((CommonImportConfiguration)this.getModel()).getVoyageFile().setContentType(contentType);
    }

    public void setVoyageFileFileName(String fileName) {
        ((CommonImportConfiguration)this.getModel()).getVoyageFile().setFileName(fileName);
    }

    public void setTransitFile(File file) {
        ((CommonImportConfiguration)this.getModel()).getTransitFile().setFile(file);
    }

    public void setTransitFileContentType(String contentType) {
        ((CommonImportConfiguration)this.getModel()).getTransitFile().setContentType(contentType);
    }

    public void setTransitFileFileName(String fileName) {
        ((CommonImportConfiguration)this.getModel()).getTransitFile().setFileName(fileName);
    }

    public void setTransectFile(File file) {
        ((CommonImportConfiguration)this.getModel()).getTransectFile().setFile(file);
    }

    public void setTransectFileContentType(String contentType) {
        ((CommonImportConfiguration)this.getModel()).getTransectFile().setContentType(contentType);
    }

    public void setTransectFileFileName(String fileName) {
        ((CommonImportConfiguration)this.getModel()).getTransectFile().setFileName(fileName);
    }
}

