/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.opensymphony.xwork2.ActionContext;
import fr.ifremer.echobase.EchoBaseConfiguration;
import fr.ifremer.echobase.I18nAble;
import fr.ifremer.echobase.persistence.EchoBaseDbMeta;
import fr.ifremer.echobase.services.DecoratorService;
import fr.ifremer.echobase.services.DefaultEchoBaseServiceContext;
import fr.ifremer.echobase.services.EchoBaseService;
import fr.ifremer.echobase.services.EchoBaseServiceContext;
import fr.ifremer.echobase.services.EchoBaseServiceSupport;
import fr.ifremer.echobase.services.ServiceFactoryAware;
import fr.ifremer.echobase.ui.EchoBaseApplicationContext;
import fr.ifremer.echobase.ui.EchoBaseInternalDbTransactionFilter;
import fr.ifremer.echobase.ui.EchoBaseSession;
import fr.ifremer.echobase.ui.EchoBaseWorkingDbTransactionFilter;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.web.struts2.BaseAction;

/*
 * Exception performing whole class analysis ignored.
 */
public class EchoBaseActionSupport
extends BaseAction
implements ServiceFactoryAware {
    private static final long serialVersionUID = 1L;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
    private static final SimpleDateFormat monthFormat = new SimpleDateFormat("mm-yyyy");
    private static EchoBaseApplicationContext applicationContext;
    private transient EchoBaseSession echoBaseSession;
    private transient EchoBaseServiceContext serviceContext;
    private transient Map<String, String[]> parameters;
    private transient Map<String, Object> session;

    public static EchoBaseApplicationContext getEchoBaseApplicationContext() {
        if (applicationContext == null) {
            applicationContext = EchoBaseApplicationContext.getApplicationContext((ActionContext)EchoBaseActionSupport.getActionContext());
        }
        return applicationContext;
    }

    public static String getApplicationVersion() {
        return EchoBaseActionSupport.getEchoBaseApplicationContext().getConfiguration().getApplicationVersion().toString();
    }

    protected EchoBaseConfiguration getConfiguration() {
        return EchoBaseActionSupport.getEchoBaseApplicationContext().getConfiguration();
    }

    public EchoBaseSession getEchoBaseSession() {
        if (this.echoBaseSession == null) {
            this.echoBaseSession = EchoBaseSession.getEchoBaseSession((ActionContext)EchoBaseActionSupport.getActionContext());
        }
        return this.echoBaseSession;
    }

    public EchoBaseServiceContext getServiceContext() {
        if (this.serviceContext == null) {
            this.serviceContext = DefaultEchoBaseServiceContext.newContext((Locale)this.getLocale(), (TopiaContext)EchoBaseInternalDbTransactionFilter.getTransaction((ActionContext)EchoBaseActionSupport.getActionContext()), (TopiaContext)EchoBaseWorkingDbTransactionFilter.getTransaction((ActionContext)EchoBaseActionSupport.getActionContext()), (EchoBaseConfiguration)this.getConfiguration(), (EchoBaseDbMeta)EchoBaseActionSupport.getEchoBaseApplicationContext().getDbMeta());
        }
        return this.serviceContext;
    }

    public <E extends EchoBaseService> E getService(Class<E> serviceClass) {
        EchoBaseService service = this.getServiceContext().getService(serviceClass);
        return (E)service;
    }

    public boolean isAdmin() {
        boolean result = this.getEchoBaseSession().isAdmin();
        return result;
    }

    public boolean isWorkingDbSelected() {
        boolean result = this.getEchoBaseSession().isWorkingDbSelected();
        return result;
    }

    public String formatDate(Date date) {
        String result = dateFormat.format(date);
        return result;
    }

    public String formatMonth(Date date) {
        String result = monthFormat.format(date);
        return result;
    }

    public void setParameters(Map<String, String[]> parameters) {
        this.parameters = parameters;
    }

    public void setSession(Map<String, Object> session) {
        this.session = session;
    }

    public void addFlashMessage(String message) {
        this.getEchoBaseSession().addMessage("messages", message);
    }

    public void addFlashError(String message) {
        this.getEchoBaseSession().addMessage("errors", message);
    }

    public void addFlashWarning(String message) {
        this.getEchoBaseSession().addMessage("warnings", message);
    }

    public Collection<String> getFlashMessages() {
        Set result = this.getEchoBaseSession().consumeDynamicSetData("messages");
        return result;
    }

    public Collection<String> getFlashErrors() {
        Set result = this.getEchoBaseSession().consumeDynamicSetData("errors");
        return result;
    }

    public Collection<String> getFlashWarnings() {
        Set result = this.getEchoBaseSession().consumeDynamicSetData("warnings");
        return result;
    }

    public boolean hasFlashMessages() {
        Set result = this.getEchoBaseSession().getDynamicSetData("messages");
        return CollectionUtils.isNotEmpty((Collection)result);
    }

    public boolean hasFlashErrors() {
        Set result = this.getEchoBaseSession().getDynamicSetData("errors");
        return CollectionUtils.isNotEmpty((Collection)result);
    }

    public boolean hasFlashWarnings() {
        Set result = this.getEchoBaseSession().getDynamicSetData("warnings");
        return CollectionUtils.isNotEmpty((Collection)result);
    }

    public void clearFlashMessages() {
        Set result = this.getEchoBaseSession().getDynamicSetData("messages");
        if (result != null) {
            result.clear();
        }
    }

    public void clearFlashErrors() {
        Set result = this.getEchoBaseSession().getDynamicSetData("errors");
        if (result != null) {
            result.clear();
        }
    }

    public String getDocumentation(String page) {
        return this.getDocumentation(page, null);
    }

    public String getDocumentation(String page, String anchor) {
        Locale locale = this.getLocale();
        String result = this.getConfiguration().getDocumentationUrl().toString();
        if (!result.endsWith("/")) {
            result = result + "/";
        }
        if (Locale.ENGLISH.getLanguage().equals(locale.getLanguage())) {
            result = result + "en/";
        }
        result = result + page;
        if (StringUtils.isNotBlank((CharSequence)anchor)) {
            result = result + "#" + anchor;
        }
        return result;
    }

    public boolean hasAnyErrors() {
        boolean result = super.hasErrors();
        return result || this.hasFlashErrors();
    }

    protected static ActionContext getActionContext() {
        return ActionContext.getContext();
    }

    protected final <E extends Enum<E>> Map<String, String> decorateEnums(E ... enumValues) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (E enumValue : enumValues) {
            result.put(((Enum)enumValue).name(), this._(((I18nAble)enumValue).getI18nKey(), new Object[0]));
        }
        return result;
    }

    protected final <E extends TopiaEntity> Map<String, String> loadSortAndDecorate(Class<E> beanType) {
        EchoBaseServiceSupport service = (EchoBaseServiceSupport)this.getService(EchoBaseServiceSupport.class);
        List beans = service.getEntities(beanType);
        DecoratorService decoratorService = (DecoratorService)this.getService(DecoratorService.class);
        return decoratorService.sortAndDecorate(this.getLocale(), (Collection)beans, null);
    }

    protected Map<String, String[]> getParameters() {
        Preconditions.checkNotNull((Object)this.parameters, (Object)("You must put ParameterAware contract on your action " + this.getClass().getName()));
        return this.parameters;
    }

    protected Map<String, Object> getSession() {
        Preconditions.checkNotNull((Object)this.session, (Object)("You must put SessionAware contract on your action " + this.getClass().getName()));
        return this.session;
    }
}

