/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.interceptors;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.util.TextParseUtil;
import fr.ifremer.echobase.ui.EchoBaseSession;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CleanEchoBaseSessionInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(CleanEchoBaseSessionInterceptor.class);
    private Set<String> parameters = Collections.emptySet();

    public void setParameters(String parameters) {
        this.parameters = TextParseUtil.commaDelimitedStringToSet((String)parameters);
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        EchoBaseActionSupport action = (EchoBaseActionSupport)invocation.getAction();
        EchoBaseSession echoBaseSession = action.getEchoBaseSession();
        for (String paramName : this.parameters) {
            Object value = echoBaseSession.remove(paramName);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Removed [" + paramName + "]  : " + value));
        }
        return invocation.invoke();
    }
}

