/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.user;

import fr.ifremer.echobase.EchoBaseConfiguration;
import fr.ifremer.echobase.services.EmbeddedApplicationService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import java.io.File;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConnectToDbInformations
extends EchoBaseActionSupport {
    private static final long serialVersionUID = 1L;
    protected String jdbcUrl;
    protected String jdbcLogin;
    protected String jdbcPassword;
    protected String jdbcDriver;
    protected File jdbcPilot;
    protected boolean askPassword;

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getJdbcLogin() {
        return this.jdbcLogin;
    }

    public String getJdbcPassword() {
        return this.jdbcPassword;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public File getJdbcPilot() {
        return this.jdbcPilot;
    }

    public boolean isAskPassword() {
        return this.askPassword;
    }

    public String execute() throws Exception {
        EchoBaseConfiguration configuration = ConnectToDbInformations.getEchoBaseApplicationContext().getConfiguration();
        Properties properties = configuration.getProperties();
        if (configuration.isEmbedded()) {
            this.jdbcPassword = properties.getProperty("hibernate.connection.password");
        } else {
            this.askPassword = true;
            this.jdbcPassword = "***";
        }
        this.jdbcUrl = properties.getProperty("hibernate.connection.url");
        this.jdbcLogin = properties.getProperty("hibernate.connection.username");
        this.jdbcDriver = properties.getProperty("hibernate.connection.driver_class");
        EmbeddedApplicationService service = (EmbeddedApplicationService)this.newService(EmbeddedApplicationService.class);
        String pilotName = "org.h2.Driver".equals(this.jdbcDriver) ? service.getH2PilotFilename(properties) : service.getPostgresqlPilotFilename(properties);
        if (StringUtils.isNotEmpty((CharSequence)pilotName)) {
            File driverDirectory = service.getPilotsDirectory(configuration.getDataDirectory());
            this.jdbcPilot = new File(driverDirectory, pilotName);
        }
        return "success";
    }
}

