/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: Configure.java 420 2012-03-27 23:02:51Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-0.6/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/embeddedApplication/Configure.java $
 * %%
 * Copyright (C) 2011 - 2012 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.embeddedApplication;

import fr.ifremer.echobase.EchoBaseConfiguration;
import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.services.EchoBaseServiceSupport;
import fr.ifremer.echobase.services.EmbeddedApplicationConfiguration;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUtil;
import org.nuiton.util.Version;

import java.io.File;
import java.util.List;
import java.util.Map;

/**
 * Configure the embedded application creation.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.2
 */
public class Configure extends EchoBaseActionSupport {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log = LogFactory.getLog(Configure.class);

    /** action model. */
    protected EmbeddedApplicationConfiguration model;

    /** Universe of voyages to export in db. */
    protected Map<String, String> voyages;

    public EmbeddedApplicationConfiguration getModel() {
        if (model == null) {
            model = new EmbeddedApplicationConfiguration();
        }
        return model;
    }

    public Map<String, String> getVoyages() {
        return voyages;
    }

    @Override
    public String input() throws Exception {

        // always remove configuration from session anytime coming here
        getEchoBaseSession().setExportDbConfiguration(null);

        // creates the action model
        EmbeddedApplicationConfiguration actionModel = getModel();

        // give default embedded application archive file name
        EchoBaseConfiguration configuration = getConfiguration();
        Version version = configuration.getApplicationVersion();
        String fileName = "echobase-embedded-" + version.toString();
        actionModel.setFileName(fileName);

        // gets war location
        File warLocation = configuration.getWarLocation();
        if (!warLocation.exists()) {
            addActionError(_("echobase.error.warlocation.notFound",
                             warLocation));
        }
        actionModel.setWarLocation(warLocation);

        EchoBaseServiceSupport service =
                newService(EchoBaseServiceSupport.class);
        List<Voyage> allVoyages = service.getEntities(Voyage.class);

        if (CollectionUtils.isEmpty(allVoyages)) {
            addActionMessage(_("echobase.info.no.voyagee.found"));
        }
        voyages = sortAndDecorate(allVoyages, null);

        return INPUT;
    }

    @Override
    public String execute() throws Exception {

        EmbeddedApplicationConfiguration configuration = getModel();

        // creates a new temporary working directory
        File tempDirectory = FileUtils.getTempDirectory();
        File dataDirectory = new File(
                tempDirectory,
                "echobase-embeddedApplication-" + System.currentTimeMillis());
        FileUtil.createDirectoryIfNecessary(dataDirectory);
        configuration.setWorkingDirectory(dataDirectory);
        if (log.isInfoEnabled()) {
            log.info("Temporary directory to use : " + dataDirectory);
        }

        File warLocation = getConfiguration().getWarLocation();
        configuration.setWarLocation(warLocation);

        // store configuration in session
        getEchoBaseSession().setEmbeddedApplicationConfiguration(configuration);
        return SUCCESS;
    }
}