/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: ConfigureResults.java 370 2012-03-19 07:18:36Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-0.3/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/importData/ConfigureResults.java $
 * %%
 * Copyright (C) 2011 - 2012 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.importData;

import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.entities.references.Vessel;
import fr.ifremer.echobase.services.EchoBaseServiceSupport;
import fr.ifremer.echobase.services.configurations.ResultsImportConfiguration;
import fr.ifremer.echobase.services.configurations.ResultsImportMode;

import java.io.File;
import java.util.Map;

/**
 * Configure a "accoustic region data" import.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.3
 */
public class ConfigureResults extends AbstractConfigureImport<ResultsImportConfiguration> {

    private static final long serialVersionUID = 1L;

    /** Universe of existing voyages. */
    protected Map<String, String> voyages;

    /** Universe of existing vessels. */
    protected Map<String, String> vessels;

    /** Universe of possible import modes. */
    protected Map<String, String> importModes;

    protected String resultLabel;

    public ConfigureResults() {
        super(ResultsImportConfiguration.class);
    }

    @Override
    protected ResultsImportConfiguration createModel() {
        return new ResultsImportConfiguration(getLocale());
    }

    @Override
    public String input() throws Exception {

        super.input();

        EchoBaseServiceSupport service =
                newService(EchoBaseServiceSupport.class);

        voyages = loadSortAndDecorate(service, Voyage.class);
        vessels = loadSortAndDecorate(service, Vessel.class);
        importModes = decorateEnums(ResultsImportMode.values());

        if (getModel().getImportMode() == null) {

            getModel().setImportMode(ResultsImportMode.VOYAGE);
        }
        return INPUT;
    }

    @InputConfig(methodName = "input")
    public String modeVoyage() throws Exception {

        return execute();
    }

    @InputConfig(methodName = "input")
    public String modeAcousticByEchotype() throws Exception {

        return execute();
    }

    @InputConfig(methodName = "input")
    public String modeAcousticByEchotypeAndSpeciesCategory() throws Exception {

        return execute();
    }

    @InputConfig(methodName = "input")
    public String modeRegion() throws Exception {

        return execute();
    }

    @InputConfig(methodName = "input")
    public String modeMap() throws Exception {

        return execute();
    }

    public Map<String, String> getVoyages() {
        return voyages;
    }

    public Map<String, String> getVessels() {
        return vessels;
    }

    public Map<String, String> getImportModes() {
        return importModes;
    }


    public String getResultLabel() {
        return resultLabel;
    }

    public void setResultLabel(String resultLabel) {
        this.resultLabel = resultLabel;
    }

    public void setRegionsFile(File file) {
        getModel().getRegionsFile().setFile(file);
    }

    public void setRegionsFileContentType(String contentType) {
        getModel().getRegionsFile().setContentType(contentType);
    }

    public void setRegionsFileFileName(String fileName) {
        getModel().getRegionsFile().setFileName(fileName);
    }

    public void setRegionAssociationFile(File file) {
        getModel().getRegionAssociationFile().setFile(file);
    }

    public void setRegionAssociationFileContentType(String contentType) {
        getModel().getRegionAssociationFile().setContentType(contentType);
    }

    public void setRegionAssociationFileFileName(String fileName) {
        getModel().getRegionAssociationFile().setFileName(fileName);
    }

    public void setRegionResultFile(File file) {
        getModel().getRegionResultFile().setFile(file);
    }

    public void setRegionResultFileContentType(String contentType) {
        getModel().getRegionResultFile().setContentType(contentType);
    }

    public void setRegionResultFileFileName(String fileName) {
        getModel().getRegionResultFile().setFileName(fileName);
    }

    public void setMapsFile(File file) {
        getModel().getMapsFile().setFile(file);
    }

    public void setMapsFileContentType(String contentType) {
        getModel().getMapsFile().setContentType(contentType);
    }

    public void setMapsFileFileName(String fileName) {
        getModel().getMapsFile().setFileName(fileName);
    }

    public void setMapResultFile(File file) {
        getModel().getMapResultFile().setFile(file);
    }

    public void setMapResultFileContentType(String contentType) {
        getModel().getMapResultFile().setContentType(contentType);
    }

    public void setMapResultFileFileName(String fileName) {
        getModel().getMapResultFile().setFileName(fileName);
    }

    public void setLengthAgeKeyFile(File file) {
        getModel().getLengthAgeKeyFile().setFile(file);
    }

    public void setLengthAgeKeyFileContentType(String contentType) {
        getModel().getLengthAgeKeyFile().setContentType(contentType);
    }

    public void setLengthAgeKeyFileFileName(String fileName) {
        getModel().getLengthAgeKeyFile().setFileName(fileName);
    }

    public void setLengthWeightKeyFile(File file) {
        getModel().getLengthWeightKeyFile().setFile(file);
    }

    public void setLengthWeightKeyFileContentType(String contentType) {
        getModel().getLengthWeightKeyFile().setContentType(contentType);
    }

    public void setLengthWeightKeyFileFileName(String fileName) {
        getModel().getLengthWeightKeyFile().setFileName(fileName);
    }

    public void setEchotypeFile(File file) {
        getModel().getEchotypeFile().setFile(file);
    }

    public void setEchotypeFileContentType(String contentType) {
        getModel().getEchotypeFile().setContentType(contentType);
    }

    public void setEchotypeFileFileName(String fileName) {
        getModel().getEchotypeFile().setFileName(fileName);
    }

    public void setAcousticByEchotypeFile(File file) {
        getModel().getAcousticByEchotypeFile().setFile(file);
    }

    public void setAcousticByEchotypeFileContentType(String contentType) {
        getModel().getAcousticByEchotypeFile().setContentType(contentType);
    }

    public void setAcousticByEchotypeFileName(String fileName) {
        getModel().getAcousticByEchotypeFile().setFileName(fileName);
    }

    public void setAcousticByEchotypeAndSpeciesCategoryFileFile(File file) {
        getModel().getAcousticByEchotypeAndSpeciesCategoryFile().setFile(file);
    }

    public void setAcousticByEchotypeAndSpeciesCategoryFileContentType(String contentType) {
        getModel().getAcousticByEchotypeAndSpeciesCategoryFile().setContentType(contentType);
    }

    public void setAcousticByEchotypeAndSpeciesCategoryFileName(String fileName) {
        getModel().getAcousticByEchotypeAndSpeciesCategoryFile().setFileName(fileName);
    }

}
