/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.exportQuery;

import com.opensymphony.xwork2.Preparable;
import fr.ifremer.echobase.entities.ExportQuery;
import fr.ifremer.echobase.entities.ExportQueryImpl;
import fr.ifremer.echobase.services.ExportQueryService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ManageExportQuery
extends EchoBaseActionSupport
implements Preparable {
    private static final long serialVersionUID = 1L;
    protected Map<String, String> queries;
    protected ExportQuery query;

    public ExportQuery getQuery() {
        if (this.query == null) {
            this.query = new ExportQueryImpl();
        }
        return this.query;
    }

    public Map<String, String> getQueries() {
        return this.queries;
    }

    public Map<String, String> getTableNames() {
        return this.queries;
    }

    public String saveQuery() throws Exception {
        ExportQueryService service = (ExportQueryService)this.newService(ExportQueryService.class);
        this.query = service.createOrUpdate(this.getQuery(), this.getEchoBaseSession().getEchoBaseUser());
        return "success";
    }

    public String cloneQuery() throws Exception {
        ExportQueryService service = (ExportQueryService)this.newService(ExportQueryService.class);
        this.getQuery().setTopiaId(null);
        this.query = service.createOrUpdate(this.getQuery(), this.getEchoBaseSession().getEchoBaseUser());
        return "success";
    }

    public String deleteQuery() throws Exception {
        ExportQueryService service = (ExportQueryService)this.newService(ExportQueryService.class);
        service.delete(this.getQuery().getTopiaId());
        this.query = null;
        return "success";
    }

    public void prepare() throws Exception {
        ExportQueryService service = (ExportQueryService)this.newService(ExportQueryService.class);
        List sqlQueries = service.getEntities(ExportQuery.class);
        this.queries = this.sortAndDecorate((Collection)sqlQueries, null);
        if (sqlQueries.isEmpty()) {
            this.addActionMessage(this._("echobase.info.no.sqlQuery.saved", new Object[0]));
        } else {
            String selectedQueryId = this.getQuery().getTopiaId();
            if (StringUtils.isEmpty((CharSequence)selectedQueryId)) {
                this.addActionMessage(this._("echobase.info.no.sqlQuery.selected", new Object[0]));
            } else {
                this.query = service.getExportQuery(selectedQueryId);
            }
        }
    }
}

