/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.user;

import com.opensymphony.xwork2.ActionContext;
import fr.ifremer.echobase.entities.EchoBaseUser;
import fr.ifremer.echobase.services.UserService;
import fr.ifremer.echobase.ui.EchoBaseSession;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.interceptor.SessionAware;

public class LoginAction
extends EchoBaseActionSupport
implements SessionAware {
    protected static final Log log = LogFactory.getLog(LoginAction.class);
    private static final long serialVersionUID = 1L;
    protected String email;
    protected String password;
    protected String redirectAction;
    private transient Map<String, Object> session;
    protected transient UserService userService;

    public UserService getUserService() {
        if (this.userService == null) {
            this.userService = (UserService)this.newService(UserService.class);
        }
        return this.userService;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getRedirectAction() {
        return this.redirectAction;
    }

    public void setRedirectAction(String redirectAction) {
        this.redirectAction = redirectAction;
    }

    public String doLogin() throws Exception {
        EchoBaseUser user = this.getUserService().getUserByEmail(this.email);
        EchoBaseSession userSession = this.getEchoBaseSession();
        userSession.setEchoBaseUser(user);
        Object o = this.session.get("WW_TRANS_I18N_LOCALE");
        if (o == null) {
            Locale locale = ActionContext.getContext().getLocale();
            this.session.put("WW_TRANS_I18N_LOCALE", locale);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("success login for user " + this.email + ", will redirect to " + this.redirectAction));
        }
        return "redirect";
    }

    public String doLogout() {
        EchoBaseSession userSession = this.getEchoBaseSession();
        userSession.setEchoBaseUser(null);
        ActionContext.getContext().getSession().remove("echoBaseSession");
        return "success";
    }

    public void setSession(Map<String, Object> session) {
        this.session = session;
    }
}

