/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: ImportTable.java 111 2011-11-23 18:01:02Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/trunk/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/dbeditor/ImportTable.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.dbeditor;

import com.google.common.base.Throwables;
import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import fr.ifremer.echobase.services.CsvImportResult;
import fr.ifremer.echobase.services.DbEditorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.File;

/**
 * To import datas from import file.
 * <p/>
 * FIXME 20111117 sletellier : extends {@link LoadEntities} find a better way to redirect to dbeditor page on validation error
 * UPDATE 20111118 sletellier : with {@link @InputConfig} probleme is solve ? dbeditor root page is prepared only on validation error...
 *
 * @author sletellier <letellier@codelutin.com>
 * @since 0.1
 */
public class ImportTable extends AbstractLoadPage {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log = LogFactory.getLog(ImportTable.class);

    /** WTF ? */
    protected File importFile;

    /** Flag to authorize to create an entity if not found in db. */
    protected boolean createIfNotFound = true;

    /** WTF ? */
    protected String importFileContentType;

    /** WTF ? */
    protected String importFileFileName;

    /** CSV import result */
    private CsvImportResult result;

    public CsvImportResult getResult() {
        return result;
    }

    public File getImportFile() {
        return importFile;
    }

    public void setImportFile(File importFile) {
        this.importFile = importFile;
    }

    public String getImportFileContentType() {
        return importFileContentType;
    }

    public void setImportFileContentType(String importFileContentType) {
        this.importFileContentType = importFileContentType;
    }

    public String getImportFileFileName() {
        return importFileFileName;
    }

    public void setImportFileFileName(String importFileFileName) {
        this.importFileFileName = importFileFileName;
    }


    public boolean isCreateIfNotFound() {
        return createIfNotFound;
    }

    public void setCreateIfNotFound(boolean createIfNotFound) {
        this.createIfNotFound = createIfNotFound;
    }

    @Override
    public String input() throws Exception {
        load();
        return INPUT;
    }

    @Override
    @InputConfig(methodName = "input")
    // to call input method on validation error to initialize dbeditor page
    public String execute() throws Exception {

        DbEditorService dbEditorService = newService(DbEditorService.class);

        try {
            result = dbEditorService.importDatas(getEntityType(),
                                                 importFileFileName,
                                                 importFile,
                                                 createIfNotFound,
                                                 getEchoBaseSession().getEchoBaseUser());

        } catch (Exception eee) {
            String message = "Failed to import datas : ";
            log.error(message, eee);
            addActionError(message + Throwables.getRootCause(eee).getMessage());

            return ERROR;
        }

        return SUCCESS;
    }
}
