/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import fr.ifremer.echobase.EchoBaseConfiguration;
import fr.ifremer.echobase.EchoBaseTechnicalException;
import fr.ifremer.echobase.EchoBaseTopiaRootContextSupplierFactory;
import fr.ifremer.echobase.entities.EchoBaseEntityEnum;
import fr.ifremer.echobase.entities.EchoBaseUserImpl;
import fr.ifremer.echobase.entities.meta.DbMeta;
import fr.ifremer.echobase.services.EchoBaseServiceContext;
import fr.ifremer.echobase.services.EchoBaseServiceContextImpl;
import fr.ifremer.echobase.services.EchoBaseServiceFactory;
import fr.ifremer.echobase.services.UserService;
import fr.ifremer.echobase.ui.EchoBaseApplicationContext;
import fr.ird.converter.FloatConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.i18n.init.DefaultI18nInitializer;
import org.nuiton.i18n.init.I18nInitializer;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.framework.TopiaUtil;
import org.nuiton.util.converter.ConverterUtil;

public class EchoBaseApplicationListener
implements ServletContextListener {
    protected static final Log log = LogFactory.getLog(EchoBaseApplicationListener.class);
    private Supplier<TopiaContext> rootContextSupplier;

    @Override
    public void contextInitialized(ServletContextEvent sce) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Application starting at " + new Date() + "..."));
        }
        DefaultI18nInitializer i18nInitializer = new DefaultI18nInitializer("echobase-i18n");
        i18nInitializer.setMissingKeyReturnNull(true);
        I18n.init((I18nInitializer)i18nInitializer, (Locale)Locale.getDefault());
        EchoBaseApplicationContext applicationContext = new EchoBaseApplicationContext();
        sce.getServletContext().setAttribute("echoBaseApplicationContext", applicationContext);
        EchoBaseConfiguration configuration = new EchoBaseConfiguration();
        applicationContext.setConfiguration(configuration);
        if (log.isInfoEnabled()) {
            log.info((Object)"Initializing RootContextSupplier...");
        }
        EchoBaseTopiaRootContextSupplierFactory factory = new EchoBaseTopiaRootContextSupplierFactory();
        this.rootContextSupplier = factory.newDatabaseFromConfig(configuration);
        applicationContext.setRootContextSupplier(this.rootContextSupplier);
        ArrayList entityEnums = Lists.newArrayList((Object[])EchoBaseEntityEnum.values());
        DbMeta dbMeta = new DbMeta(entityEnums.toArray(new EchoBaseEntityEnum[entityEnums.size()]));
        applicationContext.setDbMeta(dbMeta);
        Converter converter = ConverterUtil.getConverter(Float.class);
        if (converter != null) {
            ConvertUtils.deregister(Float.class);
        }
        ConvertUtils.register((Converter)new FloatConverter(), Float.class);
        try {
            boolean schemaExist = this.isSchemaCreated();
            if (!schemaExist || configuration.getOptionAsBoolean("updateSchema")) {
                this.updateSchema(configuration);
            }
            this.createAdminUser(applicationContext);
        }
        catch (TopiaException e) {
            throw new EchoBaseTechnicalException("Could not init db", (Throwable)e);
        }
    }

    @Override
    public void contextDestroyed(ServletContextEvent sce) {
        block6: {
            if (log.isInfoEnabled()) {
                log.info((Object)("Application is ending at " + new Date() + "..."));
            }
            if (this.rootContextSupplier != null) {
                TopiaContext rootContext;
                if (log.isInfoEnabled()) {
                    log.info((Object)"Shuting down RootContextSupplier...");
                }
                if (!(rootContext = (TopiaContext)this.rootContextSupplier.get()).isClosed()) {
                    try {
                        rootContext.closeContext();
                    }
                    catch (TopiaException te) {
                        if (!log.isErrorEnabled()) break block6;
                        log.error((Object)"Could not close rootContext", (Throwable)te);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSchema(EchoBaseConfiguration configuration) throws TopiaException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Will create or update schema for db.");
        }
        Properties dbConf = configuration.getProperties();
        dbConf.put("hibernate.hbm2ddl.auto", "update");
        EchoBaseTopiaRootContextSupplierFactory factory = new EchoBaseTopiaRootContextSupplierFactory();
        Supplier topiaContextSupplier = factory.newDatabaseFromProperties(dbConf);
        TopiaContext tx = null;
        try {
            tx = ((TopiaContext)topiaContextSupplier.get()).beginTransaction();
        }
        finally {
            dbConf.put("hibernate.hbm2ddl.auto", "none");
            this.closeTransaction(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createAdminUser(EchoBaseApplicationContext applicationContext) throws TopiaException {
        EchoBaseConfiguration configuration = applicationContext.getConfiguration();
        EchoBaseServiceFactory serviceFactory = new EchoBaseServiceFactory();
        TopiaContext transaction = ((TopiaContext)this.rootContextSupplier.get()).beginTransaction();
        try {
            EchoBaseServiceContextImpl serviceContext = EchoBaseServiceContextImpl.newContext((Locale)Locale.getDefault(), (TopiaContext)transaction, (EchoBaseConfiguration)configuration, (DbMeta)applicationContext.getDbMeta(), (EchoBaseServiceFactory)serviceFactory);
            UserService service = (UserService)serviceFactory.newService(UserService.class, (EchoBaseServiceContext)serviceContext);
            List users = service.getUsers();
            if (CollectionUtils.isEmpty((Collection)users)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"No user in database, will create default admin user (password admin).");
                }
                service.createDefaultAdminUser();
            }
        }
        finally {
            transaction.closeContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isSchemaCreated() throws TopiaException {
        TopiaContextImplementor tx = (TopiaContextImplementor)this.rootContextSupplier.get();
        try {
            boolean schemaFound;
            boolean bl = schemaFound = TopiaUtil.isSchemaExist((TopiaContext)tx, (String)EchoBaseUserImpl.class.getName());
            return bl;
        }
        finally {
            this.closeTransaction((TopiaContext)tx);
        }
    }

    protected void closeTransaction(TopiaContext tx) throws TopiaException {
        if (tx != null && !tx.isClosed()) {
            tx.closeContext();
        }
    }
}

