/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: AbstractJSONPaginedAction.java 55 2011-11-13 22:22:54Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-0.1/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/AbstractJSONPaginedAction.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions;

import fr.ifremer.echobase.services.Pager;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.json.JSONException;
import org.apache.struts2.json.JSONUtil;

/**
 * Abstract JSON action with pagination support.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public abstract class AbstractJSONPaginedAction extends EchoBaseActionSupport {

    private static final long serialVersionUID = 1L;

    public abstract Integer getRows();

    public abstract Integer getPage();

    public abstract Integer getTotal();

    public abstract Integer getRecords();

    protected Pager pager = new Pager();

    // sorting order - asc or desc
    protected String sord;

    // get index row - i.e. user click to sort.
    protected String sidx;

    protected String filters;

    /** Prefix added to the sidx when used. */
    protected final String sidx_prefix;

    protected AbstractJSONPaginedAction(String sidx_prefix) {
        this.sidx_prefix = sidx_prefix;
    }

    public void setRows(Integer rows) {
        pager.setPageSize(rows);
    }

    public void setPage(Integer page) {
        pager.setPageNumber(page);
    }

    public String getSord() {
        return sord;
    }

    public void setSord(String sord) {
        this.sord = sord;
    }

    public String getSidx() {
        return sidx;
    }

    public void setSidx(String sidx) {
        this.sidx = sidx;
    }

    public String getFilters() {
        return filters;
    }

    public void setFilters(String filters) {
        this.filters = filters;
    }

    protected String getSortColumn() {
        String result = null;
        if (useSort()) {
            result = sidx.substring(sidx_prefix.length());
        }
        return result;
    }

    protected Boolean isSortAscendant() {
        Boolean result = null;
        if (useSort()) {
            result = "asc".equals(sord);
        }
        return result;
    }

    protected boolean useSort() {
        return StringUtils.isNotEmpty(sidx);
    }

    protected Object getFilterObject() throws JSONException {
        Object filterObject = null;
        if (StringUtils.isNotEmpty(filters)) {
            filterObject = JSONUtil.deserialize(filters);
        }
        return filterObject;
    }
}
