/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.web.actions.search;

import com.google.common.collect.Lists;
import fr.ifremer.coser.result.CoserRequest;
import fr.ifremer.coser.result.request.ExtractRawDataAndResultsRequest;
import fr.ifremer.coser.result.request.GetIndicatorsForExtractRawDataAndResultsRequest;
import fr.ifremer.coser.result.request.GetSpeciesForExtractRawDataAndResultsRequest;
import fr.ifremer.coser.result.request.GetZonesForExtractRawDataAndResultsRequest;
import fr.ifremer.coser.result.result.FileResult;
import fr.ifremer.coser.util.DataType;
import fr.ifremer.coser.web.actions.common.AbstractCoserJspAction;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.InterceptorRefs;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.interceptor.ServletRequestAware;

@InterceptorRefs(value={@InterceptorRef(value="defaultStack"), @InterceptorRef(value="execAndWait", params={"excludeMethods", "execute,quality"})})
public class ExtractAction
extends AbstractCoserJspAction
implements ServletRequestAware {
    private static final long serialVersionUID = 8497086194191374797L;
    public static final String DOWNLOAD = "download";
    public static final String LOCALE_ATTRIBUTE = "locale";
    protected Map<String, String> zones;
    protected Map<String, String> types;
    protected List<String> selectZones;
    protected List<DataType> selectTypes;
    protected Map<String, String> species;
    protected List<String> selectSpecies;
    protected Map<String, String> comIndicators;
    protected List<String> selectComIndicators;
    protected Map<String, String> popIndicators;
    protected List<String> selectPopIndicators;
    protected String submitAction;
    protected boolean accepted;
    protected transient HttpServletRequest servletRequest;
    protected FileResult resultFile;

    public Map<String, String> getZones() {
        return this.zones;
    }

    public List<String> getSelectZones() {
        return this.selectZones;
    }

    public void setSelectZones(List<String> selectZones) {
        this.selectZones = selectZones;
    }

    public Map<String, String> getTypes() {
        return this.types;
    }

    public List<DataType> getSelectTypes() {
        return this.selectTypes;
    }

    public void setSelectTypes(List<DataType> selectTypes) {
        this.selectTypes = selectTypes;
    }

    public List<String> getSelectSpecies() {
        return this.selectSpecies;
    }

    public void setSelectSpecies(List<String> selectSpecies) {
        this.selectSpecies = selectSpecies;
    }

    public List<String> getSelectComIndicators() {
        return this.selectComIndicators;
    }

    public void setSelectComIndicators(List<String> selectComIndicators) {
        this.selectComIndicators = selectComIndicators;
    }

    public List<String> getSelectPopIndicators() {
        return this.selectPopIndicators;
    }

    public void setSelectPopIndicators(List<String> selectPopIndicators) {
        this.selectPopIndicators = selectPopIndicators;
    }

    public Map<String, String> getSpecies() {
        return this.species;
    }

    public Map<String, String> getComIndicators() {
        return this.comIndicators;
    }

    public Map<String, String> getPopIndicators() {
        return this.popIndicators;
    }

    public void setSubmitAction(String submitAction) {
        this.submitAction = submitAction;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public void setAccepted(boolean accepted) {
        this.accepted = accepted;
    }

    public void setServletRequest(HttpServletRequest servletrequest) {
        this.servletRequest = servletrequest;
    }

    public String execute() {
        String result;
        if (StringUtils.isNotBlank((CharSequence)this.submitAction)) {
            result = "success";
        } else {
            result = "input";
            this.types = DataType.getExtractTypes((Locale)this.getLocale());
            GetZonesForExtractRawDataAndResultsRequest zonesRequest = (GetZonesForExtractRawDataAndResultsRequest)this.requestBuilder(GetZonesForExtractRawDataAndResultsRequest.class).toRequest();
            this.zones = this.getService().toMap((CoserRequest)zonesRequest);
            if (CollectionUtils.isNotEmpty((Collection)this.selectZones)) {
                GetSpeciesForExtractRawDataAndResultsRequest speciesRequest = (GetSpeciesForExtractRawDataAndResultsRequest)this.requestBuilder(GetSpeciesForExtractRawDataAndResultsRequest.class).addZoneList(this.selectZones).addExtractTypeList(this.selectTypes).toRequest();
                this.species = this.getService().toMap((CoserRequest)speciesRequest);
                if (this.selectTypes != null) {
                    GetIndicatorsForExtractRawDataAndResultsRequest indicatorsRequest = (GetIndicatorsForExtractRawDataAndResultsRequest)this.requestBuilder(GetIndicatorsForExtractRawDataAndResultsRequest.class).addZoneList(this.selectZones).toRequest();
                    if (this.selectTypes.contains(DataType.COMMUNITY)) {
                        indicatorsRequest.setExtractTypeList((List)Lists.newArrayList((Object[])new DataType[]{DataType.COMMUNITY}));
                        this.comIndicators = this.getService().toMap((CoserRequest)indicatorsRequest);
                    }
                    if (this.selectTypes.contains(DataType.POPULATION)) {
                        indicatorsRequest.setExtractTypeList((List)Lists.newArrayList((Object[])new DataType[]{DataType.POPULATION}));
                        this.popIndicators = this.getService().toMap((CoserRequest)indicatorsRequest);
                    }
                }
            }
        }
        return result;
    }

    @Action(value="extract-quality", results={@Result(name="input", location="/WEB-INF/content/search/extract-success.jsp"), @Result(name="download", type="redirect", params={"location", "${location}"})})
    public String quality() {
        this.servletRequest.getSession().setAttribute(LOCALE_ATTRIBUTE, (Object)this.getLocale());
        return DOWNLOAD;
    }

    public String getLocation() {
        String url = "extract-download?accepted=true";
        if (this.selectZones != null) {
            for (String zone : this.selectZones) {
                url = url + "&selectZones=" + zone;
            }
        }
        if (this.selectTypes != null) {
            for (DataType type : this.selectTypes) {
                url = url + "&selectTypes=" + type;
            }
        }
        if (this.selectSpecies != null) {
            for (String species : this.selectSpecies) {
                url = url + "&selectSpecies=" + species;
            }
        }
        if (this.selectComIndicators != null) {
            for (String selectComIndicator : this.selectComIndicators) {
                url = url + "&selectComIndicators=" + selectComIndicator;
            }
        }
        if (this.selectPopIndicators != null) {
            for (String selectPopIndicator : this.selectPopIndicators) {
                url = url + "&selectPopIndicators=" + selectPopIndicator;
            }
        }
        return url;
    }

    @Action(value="extract-download", results={@Result(name="wait", location="/WEB-INF/content/search/extract-wait.jsp"), @Result(type="stream", params={"contentType", "application/zip", "contentDisposition", "attachment; filename=\"${filename}\""})})
    public String download() {
        Locale locale = (Locale)this.servletRequest.getSession().getAttribute(LOCALE_ATTRIBUTE);
        ExtractRawDataAndResultsRequest request = (ExtractRawDataAndResultsRequest)this.requestBuilder(locale, ExtractRawDataAndResultsRequest.class).addZoneList(this.selectZones).addExtractTypeList(this.selectTypes).addSpeciesList(this.selectSpecies).addCommunityIndicatorList(this.selectComIndicators).addPopulationIndicatorList(this.selectPopIndicators).toRequest();
        this.resultFile = this.getService().extractRawDataAndResults(locale, request);
        return "success";
    }

    public InputStream getInputStream() {
        InputStream is = this.resultFile.getInputStream();
        return is;
    }

    public String getFilename() {
        return "Indicateurs_Ifremer.zip";
    }
}

