/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.web.actions.source;

import fr.ifremer.coser.services.WebService;
import fr.ifremer.coser.web.CoserWebException;
import fr.ifremer.coser.web.ServiceFactory;
import fr.ifremer.coser.web.actions.source.SourceAction;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

public class SourceDataAction
extends SourceAction {
    private static final long serialVersionUID = 3385467755357775199L;
    private static final Log log = LogFactory.getLog(SourceDataAction.class);
    protected boolean accepted;

    public void setAccepted(boolean accepted) {
        this.accepted = accepted;
    }

    public void validate() {
        if (!this.accepted) {
            this.addFieldError("accepted", this.getText("message.quality.notaccepted"));
        }
    }

    @Action(results={@Result(type="stream", params={"contentType", "application/zip", "inputName", "inputStream", "contentDisposition", "attachment; filename=\"${filename}\""})})
    public String execute() {
        return "success";
    }

    public String getFilename() {
        return "source.zip";
    }

    public InputStream getInputStream() {
        WebService webService = ServiceFactory.getWebService();
        Locale locale = this.getLocale();
        FileInputStream input = null;
        try {
            File sourceZip = webService.getSourceZip(this.zone, locale);
            input = new FileInputStream(sourceZip);
        }
        catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't get file data", (Throwable)ex);
            }
            throw new CoserWebException("Can't get source zip file", (Throwable)ex);
        }
        return input;
    }
}

