/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.web.actions.com;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.services.WebService;
import fr.ifremer.coser.web.CoserWebException;
import fr.ifremer.coser.web.ServiceFactory;
import fr.ifremer.coser.web.actions.common.CoserAction;
import java.util.Locale;
import java.util.Map;

public class GraphAction
extends CoserAction {
    private static final long serialVersionUID = 3385467755357775199L;
    protected String facade;
    protected String zone;
    protected String indicator;
    protected Map<String, String> lists;
    protected String list;

    public String getFacade() {
        return this.facade;
    }

    public void setFacade(String facade) {
        this.facade = facade;
    }

    public String getZone() {
        return this.zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public String getIndicator() {
        return this.indicator;
    }

    public void setIndicator(String indicator) {
        this.indicator = indicator;
    }

    public Map<String, String> getLists() {
        return this.lists;
    }

    public String getList() {
        return this.list;
    }

    public void setList(String list) {
        this.list = list;
    }

    public String getFacadeDisplayName() {
        WebService webService = ServiceFactory.getWebService();
        String displayName = null;
        try {
            displayName = (String)webService.getFacades().get(this.facade);
        }
        catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get facade display name", (Throwable)ex);
        }
        return displayName;
    }

    public String getZoneDisplayName() {
        WebService webService = ServiceFactory.getWebService();
        String displayName = null;
        try {
            displayName = (String)webService.getZoneForFacade(this.facade, false, false).get(this.zone);
        }
        catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get zone display name", (Throwable)ex);
        }
        return displayName;
    }

    public String getIndicatorDisplayName() {
        Locale locale = this.getLocale();
        WebService webService = ServiceFactory.getWebService();
        String displayName = null;
        try {
            displayName = (String)webService.getIndicators(this.zone, null, locale).get(this.indicator);
        }
        catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get species display name", (Throwable)ex);
        }
        return displayName;
    }

    public String execute() {
        Locale locale = this.getLocale();
        WebService webService = ServiceFactory.getWebService();
        try {
            this.lists = webService.getIndicatorLists(this.zone, this.indicator, locale);
        }
        catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get indicator's list names", (Throwable)ex);
        }
        return "success";
    }
}

