/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.web.actions.map;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.services.WebService;
import fr.ifremer.coser.web.CoserWebException;
import fr.ifremer.coser.web.ServiceFactory;
import fr.ifremer.coser.web.actions.common.CoserAction;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SpeciesAction
extends CoserAction {
    private static final long serialVersionUID = 1663244944108703571L;
    private static final Log log = LogFactory.getLog(SpeciesAction.class);
    protected String facade;
    protected String survey;
    protected Map<String, String> species;

    public void setFacade(String facade) {
        this.facade = facade;
    }

    public String getFacade() {
        return this.facade;
    }

    public String getSurvey() {
        return this.survey;
    }

    public void setSurvey(String survey) {
        this.survey = survey;
    }

    public Map<String, String> getSpecies() {
        return this.species;
    }

    public String getFacadeDisplayName() {
        WebService webService = ServiceFactory.getWebService();
        String displayName = null;
        try {
            displayName = (String)webService.getFacades().get(this.facade);
        }
        catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get species display name", (Throwable)ex);
        }
        return displayName;
    }

    public String execute() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Looking for species for survey " + this.survey));
        }
        WebService webService = ServiceFactory.getWebService();
        try {
            this.species = webService.getSpeciesForSurvey(this.survey);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Species are : " + this.species));
            }
        }
        catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get zone species", (Throwable)ex);
        }
        return "success";
    }
}

