/*
 * #%L
 * Coselmar :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Ifremer, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

coselmarServices.factory('questionsService', ['$resource', 'coselmar-config', function($resource, coselmarConfig){
	return new Question($resource, coselmarConfig);
}]);

function Question(resource, config){


	this.resource = resource;
	var baseURL = config.BASE_URL + "/questions";
	var usersURL = config.BASE_URL + "/users";

	this.saveQuestion = function(question, successFunction, failFunction){

		var formData = new FormData();
		formData.append("question", JSON.stringify(question));
		var questionParam = $.param({'question' : JSON.stringify(question)});

		// Save the Question
		var serviceURl = baseURL;
		if (question.id) {
			serviceURl = baseURL + "/" + question.id
		}
		var questionResource = resource(serviceURl, null, {
			'save': {
			  method:'POST',
			}
		});
		questionResource.save(null, questionParam, successFunction, failFunction);
	};

	this.findUsers = function(example, successFunction) {
		var userResource = resource(usersURL, {'search': example});
		userResource.query(successFunction);

	};

	this.getQuestions = function(searchOptions, successFunction, failFunction) {

		if (searchOptions.privacy != "private" && searchOptions.privacy != "public" ) {
			searchOptions.privacy = undefined;
		}

		if (searchOptions.status != "open" && searchOptions.status != "close"
		 && searchOptions.status != "in_progress" && searchOptions.status != "adjourned") {
			searchOptions.status = undefined;
		}

		var questionResource = resource(baseURL, {'searchOption' : searchOptions});
		questionResource.query().$promise.then(successFunction, failFunction);
	};

	this.deleteQuestion = function(questionId, successFunction, failFunction) {
		var questionResource = resource(baseURL + "/" + questionId);
		questionResource.delete().$promise.then(successFunction, failFunction);
	};

	this.getQuestion = function(questionId, successFunction, failFunction) {
		var questionResource = resource(baseURL + "/" + questionId);
		questionResource.get().$promise.then(successFunction, failFunction);
	};

	this.addNewDocuments = function(questionId, documents, successFunction, failFunction) {

		var formData = new FormData();
		formData.append("documents", JSON.stringify(documents));
		var documentsParam = $.param({'documents': JSON.stringify(documents)})

		var serviceURl = baseURL + "/" + questionId + "/documents";
		var questionResource = resource(serviceURl, null, {
			'save': {
			  method:'POST',
			  isArray: true,
			}
		});
		questionResource.save(null, documentsParam, successFunction, failFunction);
	};

	this.findAllTypes = function(successFunction){
		var questionResource = resource(baseURL + '/types');
		questionResource.query(successFunction);
	};

	this.findAllThemes = function(successFunction){
		var questionResource = resource(baseURL + '/themes');
		questionResource.query(successFunction);
	};

};