/*
 * #%L
 * Coselmar :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Ifremer, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
var coselmarControllers = angular.module('coselmarControllers', ['ui.bootstrap', 'ui.select', 'ui.bootstrap.tooltip']);

// Controller when the main page/view loads
coselmarControllers.controller("HomeCtrl", ['$scope', '$http', '$location', '$routeParams', '$locale', '$translate', 'userService', 'jwtHelper', 'coselmar-config',
 								function ($scope, $http, $location, $routeParams, $locale, $translate, userService, jwtHelper, coselmarConfig) {

	var jwtToken = localStorage.getItem('coselmar-jwt');
	if (jwtToken && !jwtHelper.isTokenExpired(jwtToken)) {
		$scope.currentUser = jwtHelper.decodeToken(jwtToken);
	}

	//Just get the version from a file
	$http.get('version.txt', {'transformResponse':angular.identity}).success(function (data) {
    	$scope.version = data;
  	});

	$scope.login = function(mail, password) {
		userService.login(mail, password, function(successResult) {
			// Store JsonWebToken to keep authentication
			localStorage.setItem('coselmar-jwt', successResult.jwt);
			$scope.currentUser = jwtHelper.decodeToken(successResult.jwt);

			// Redirect on initial request page
			if ($location.search()["returnTo"]) {
				$location.path($location.search()["returnTo"]);
				delete returnTo;
			} else {
				// Redirect on '/'
				$location.path('/');
			}
		})
	}

	$scope.logout = function() {
		delete $scope.currentUser;
		localStorage.removeItem('coselmar-jwt');
		$location.path('/');
	}

    // i18n Management
    $scope.locale = localStorage.getItem('coselmar-locale');

    if (!$scope.locale) {
        // set locale with browser preference
        $scope.locale = navigator.language || navigator.userLanguage;
        $scope.locale = $scope.locale.substring(0,2);

        // get locale supported
        if (coselmarConfig.SUPPORTED_LOCALE.indexOf($scope.locale) == -1) {
          $scope.locale = coselmarConfig.SUPPORTED_LOCALE[0];
        }

    }
    $translate.use($scope.locale);


    $scope.switchLocale = function (locale) {
        // switch locale
        if (locale != $scope.locale) {
            // Store locale in localStorage
			localStorage.setItem('coselmar-locale', locale);
            $scope.locale = locale;
            $translate.use(locale);
        }
    }

}]);

// Controller when got 401
coselmarControllers.controller("unauthorizedCtrl", ['$scope', function ($scope) {

	// Just remove the current stored user
	delete $scope.currentUser;
	localStorage.removeItem('coselmar-jwt');

}]);

// Controller for All Documents View
coselmarControllers.controller("DocumentsCtrl", ['$scope', '$route', '$routeParams', '$location', 'documentService', function($scope, $route, $routeParams, $location, documentService){

	//manage keywords if given
	$scope.searchKeywords = [];
	var keywords = $routeParams.keywords;
	if (Array.isArray(keywords)) {
		$scope.searchKeywords = keywords;
	} else if (keywords) {
		$scope.searchKeywords.push(keywords);
	}

	documentService.getDocuments($scope.searchKeywords, function(documents) {
		$scope.documents = documents;
	});

	$scope.deleteDocument = function(documentId){

		// Call service to create a new document
		documentService.deleteDocument(documentId, $scope, function() {
			// Go back to documents list
			$route.reload();
		});
	};

	$scope.searchDocuments = function(){
//		$route.current.params.keywords = $scope.searchKeywords;
//		$route.reload();
		$location.search('keywords', $scope.searchKeywords);
	}
}]);


// Controller for new document View
coselmarControllers.controller("NewDocumentCtrl", ['$scope', '$location', 'documentService', function($scope, $location, documentService){

	$scope.document = {'privacy': 'PUBLIC', 'keywords': []};
	$scope.upload = {};
	$scope.existing = {'types' : [], 'keywords' : []};

	documentService.findAllTypes(function(results) {
		$scope.existing.types = results;
	});

	documentService.findAllKeywords(function(results) {
		$scope.existing.keywords = results;
	});

	$scope.createNewDocument = function(isValidForm){

        if (angular.isDate($scope.document.publicationDate)) {
            $scope.document.publicationDate = $scope.document.publicationDate.getTime();
        }

		// Call service to create a new document
		if (isValidForm) {
            documentService.saveDocument($scope.document, function(document) {
                    if ($scope.upload.file) {
                        var documentId = document.id;
                        documentService.saveDocumentFile(documentId, $scope.upload.file, function() {
                            $location.path("/documents");
                        });
                    } else {
                        $location.path("/documents");
                    }
                }, function(error) {
                    console.log("error occurs");
                }
            );

		}

	};

	$scope.addKeyword = function(keyword) {
		if (keyword && $scope.document.keywords.indexOf(keyword) == -1) {
			$scope.document.keywords.push(keyword);
		}
	};

	$scope.removeKeyword = function(keyword) {
		var position = $scope.document.keywords.indexOf(keyword);
		if (keyword && position != -1) {
			$scope.document.keywords.splice(position, 1);
		}
	};

}]);

// Controller for single document View
coselmarControllers.controller("DocumentViewCtrl",
 	['$scope', '$route', '$location', 'documentService', '$routeParams', 'coselmar-config',
 	 function($scope, $route, $location, documentService, $routeParams, coselmarConfig) {

	$scope.container = {baseUrl : coselmarConfig.BASE_URL};

	$scope.editSession = $routeParams.edit ? $routeParams.edit : false;

	documentService.getDocument($routeParams.documentId, function(document) {
	    $scope.document = document;
        $scope.canEdit = !(document.relatedQuestions && document.relatedQuestions.length > 0);
        $scope.canEdit = $scope.canEdit && ($scope.currentUser.role == 'ADMIN' || $scope.currentUser.role == 'SUPERVISOR' || $scope.currentUser.userId == document.ownerId);
	});

	$scope.deleteDocument = function(documentId){

		// Call service to create a new document
		documentService.deleteDocument(documentId, $scope, function() {
				// Go back to documents list
				$location.path("/documents");
			});

	};

    // edit part

	//to enter in edit mode from view
	$scope.edit = function() {
		$location.search("edit");
	}

	$scope.existing = {'types' : [], 'keywords' : []};

    if ($scope.editSession == true) {
        documentService.findAllTypes(function(results) {
            $scope.existing.types = results;
        });

        documentService.findAllKeywords(function(results) {
            $scope.existing.keywords = results;
        });
    }

    $scope.isFormValid = function() {
        var isValid = $scope.document.name && $scope.document.name.length > 0;
        console.log(isValid);
        isValid = isValid && $scope.document.type && $scope.document.type.length > 0;
        isValid = isValid && $scope.document.keywords && $scope.document.keywords.length > 0;
        isValid = isValid && $scope.document.authors && $scope.document.authors.length > 0;
        isValid = isValid && $scope.document.copyright && $scope.document.copyright.length > 0;
        isValid = isValid && $scope.document.summary && $scope.document.summary.length > 0;
        if (!$scope.document.fileName) {
            isValid = isValid && $scope.document.externalUrl && $scope.document.externalUrl.length > 0;
        }
        return isValid;
    };

	$scope.saveDocument = function(){

        if (angular.isDate($scope.document.publicationDate)) {
            $scope.document.publicationDate = $scope.document.publicationDate.getTime();
        }

		// Call service to create a new document
		if ($scope.isFormValid()) {
		    $scope.hasErrors = false;

            documentService.saveDocument($scope.document, function() {
                    $location.search("");
                }, function(error) {
                    console.log("error occurs");
                }
            );

		} else {
		    $scope.hasErrors = true;
		}

	};

	$scope.addKeyword = function(keyword) {
		if (keyword && $scope.document.keywords.indexOf(keyword) == -1) {
			$scope.document.keywords.push(keyword);
		}
	};

	$scope.removeKeyword = function(keyword) {
		var position = $scope.document.keywords.indexOf(keyword);
		if (keyword && position != -1) {
			$scope.document.keywords.splice(position, 1);
		}
	};


} ]);

// Controller for document file download
coselmarControllers.controller("DocumentFileDlCtrl", [ '$scope','documentService', '$routeParams', function($scope, documentService, $routeParams) {
	documentService.getDocumentFile($routeParams.documentId, $scope);
} ]);

coselmarControllers.directive('ngFileModel', ['$parse', function ($parse) {
    return {
        restrict: 'A',
        link: function(scope, element, attrs) {
            var model = $parse(attrs.ngFileModel);
            var modelSetter = model.assign;

            element.bind('change', function(){
                scope.$apply(function(){
                    modelSetter(scope, element[0].files[0]);
                });
            });
        }
    };
}]);


/////////////////////////////////////////////////
//////////////  Users Part  /////////////////////
/////////////////////////////////////////////////

// Controller for All User View
coselmarControllers.controller("UsersCtrl", ['$scope', '$route', '$routeParams', '$location', 'userService', function($scope, $route, $routeParams, $location, userService){

	//manage keywords if given
	$scope.search = { searchKeywords : []};
	$scope.example = {};

	var keywords = $routeParams.keywords;
	if (Array.isArray(keywords)) {
		$scope.search.searchKeywords = keywords;
	} else if (keywords) {
		$scope.search.searchKeywords.push(keywords);
	}
	var showDisable = $routeParams.showDisable;
	if (showDisable) {
		$scope.search.showDisable = showDisable;
	} else {
		$scope.search.showDisable = false;
	}
	console.log($scope.search.showDisable);

	userService.getUsers($scope.search.searchKeywords, $scope.search.showDisable, function(users) {
		$scope.users = users;
	});

	$scope.deleteUser = function(userId){

		userService.deleteUser(userId, $scope, function() {
			// Go back to documents list
			$route.reload();
		});
	};

	$scope.disableUser = function(user){

		user.active = false;
		userService.saveUser(user, function() {
			// Go back to users list
			$location.path("/users");
		});

	};

	$scope.enableUser = function(user){

		user.active = true;
		userService.saveUser(user, function() {
			// Go back to users list
			$location.path("/users");
		});

	};

	$scope.searchUsers = function(){
		$location.search('keywords', $scope.search.searchKeyword);
		$location.search('showDisable', $scope.search.showDisable);
	};

	$scope.advancedSearchUsers = function() {
		if ($scope.example.role && $scope.example.role == "ALL") {
			delete $scope.example.role;
		};
		if ($scope.example.active) {
		  	if($scope.example.active == "true") {
				$scope.example.active = true;
			} else {
				$scope.example.active = false;
			};
		};
		console.log($scope.example);
		userService.getAdvancedUsers($scope.example, function(users){
			$scope.users = users;
		});
	};
}]);


// Controller for new user View
coselmarControllers.controller("NewUserCtrl", ['$scope', '$route', '$location', 'userService', function($scope, $route, $location, userService){

	if ($scope.currentUser.role == 'ADMIN') {
	    $scope.user = {'role' : 'EXPERT'};
	} else if ($scope.currentUser.role == 'SUPERVISOR') {
	    $scope.user = {'role' : 'CLIENT'};
	} else {
	    $location.path("403");
	}

	$scope.saveUser = function(isValidForm){

		// Call service to create a new user
		if(isValidForm) {
			userService.saveUser($scope.user, function() {
				$location.path("/users");
			},function(error) {
				//TODO ymartel 20141118 : deal with error.status or statusText
				console.log("error occurs");
				console.log(error.s);
			});
		}

	};
}]);

// Controller for single User View & Edit
coselmarControllers.controller("UserViewCtrl",
 	['$scope', '$route', '$location', 'userService', '$routeParams', function($scope, $route, $location, userService, $routeParams) {

	$scope.editMode = $routeParams.edit;
	if ($scope.editMode) {
		$scope.editPassword = true;
	    $scope.messages = [];
	}

	userService.getUser($routeParams.userId, $scope);

	$scope.deleteUser = function(userId){

		userService.deleteUser(userId, $scope, function() {
			// Go back to users list
			$location.path("/users");
		});

	};

	$scope.disableUser = function(){

		var user = $scope.user;
		user.active = false;
		userService.saveUser(user, function() {
			// Go back to users list
			$route.reload();
		});

	};

	$scope.enableUser = function(){

		var user = $scope.user;
		user.active = true;
		userService.saveUser(user, function() {
			// Go back to users list
			$route.reload();
		});

	};

	$scope.modifyUser = function(){
		$location.search("edit");
	};

	$scope.saveUser = function(isValidForm){

		// Call service to create a new user
		if(isValidForm) {
			userService.saveUser($scope.user,
				function() {
					// On success, back on users list for admin or supervisor
					if ($scope.currentUser.role == 'ADMIN' || $scope.currentUser.role == 'SUPERVISOR') {
					    $location.path("/users");
					} else {
					    $location.search("");
					}

				},function(error) {
					//TODO ymartel 20141118 : deal with error.status or statusText
					console.log("error occurs");
					console.log(error.s);
			});
		}
	};

} ]);

// This directive checks two inputs have identical values.
// This is used for new password check
coselmarControllers.directive('identicalCheck', [function () {
	return {
		require: 'ngModel',
		link: function (scope, elem, attrs, ctrl) {
			var firstWord = '#' + attrs.identicalCheck;
			elem.add(firstWord).on('keyup', function () {
				scope.$apply(function () {
					var areMatching = elem.val()===$(firstWord).val();
					ctrl.$setValidity('identicalmatch', areMatching);
				});
			});
		}
	}
}]);

/////////////////////////////////////////////////
////////////  Questions Part  ///////////////////
/////////////////////////////////////////////////

// Controller for All Question View
coselmarControllers.controller("QuestionsCtrl", ['$scope', '$route', '$routeParams', '$location', 'questionsService',
 					function($scope, $route, $routeParams, $location, questionsService){

	$scope.searchOptions = { 'privacy' : '', 'status' : '', 'keywords' : []};

	questionsService.getQuestions($scope.searchOptions, function(questions) {
		// success : just get the questions
		$scope.questions = questions;

	}, function(error) {
		// Fail function : TODO
		console.log(error);
	});

	$scope.searchQuestions = function() {
		questionsService.getQuestions($scope.searchOptions, function(questions) {
			$scope.questions = questions;
		});

	};


	$scope.deleteQuestion = function(questionId) {

		questionsService.deleteQuestion(questionId, function(questions) {
			// success : just get the questions
			$route.reload();

		}, function(error) {
			// Fail function : TODO
			console.log(error);
		});
	};

	$scope.getUserNames = function(users) {

		var names = "";
		for(var i=0; i < users.length; i++) {
			names += users[i].firstName + " " + users[i].name + "<br />";
		}

		return names;
	};

	$scope.getDocumentTitles = function(documents) {

		var titles = "";
		for(var i=0; i < documents.length; i++) {
			titles += documents[i].name;
			titles += "<br />";
		}

		return titles;
	};

}]);

// Controller for All User View
coselmarControllers.controller("QuestionCtrl", ['$scope', '$route', '$routeParams', '$location', '$modal', 'questionsService',
 					function($scope, $route, $routeParams, $location, $modal, questionsService){

	$scope.editSession = $routeParams.edit ? $routeParams.edit : false;
	$scope.isCurrentParticipant = false;

	$scope.question = {'privacy' : 'PUBLIC',
						'themes' : [], 'participants' : [], 'externalExperts' : [],
						'clients' : [], 'relatedDocuments': [], 'newRelatedDocuments' : [] };
	$scope.existing = {'types' : [], 'themes' : []};

	// Preload exiting types and themes
	questionsService.findAllTypes(function(results) {
		$scope.existing.types = results;
	});

	questionsService.findAllThemes(function(results) {
		$scope.existing.themes = results;
	});

	//to enter in edit mode from view
	$scope.edit = function() {
		$location.search("edit");
	}

	// Participants, clients and supervisors management for ui-select
	$scope.participantsIndex = {};
	$scope.clientsIndex = {};
	$scope.supervisorsIndex = {};

	$scope.users = { 'participants' : [], 'clients': [], 'supervisors' : []};

	$scope.refreshExperts = function(searchKeyword) {
		var searchKeywords = [];
		if (searchKeyword && searchKeyword.length > 0) {
			searchKeywords.push(searchKeyword);
		}

		questionsService.findUsers({'role': 'EXPERT', 'active': true, 'fullTextSearch' : searchKeywords}, function(users) {
			$scope.users.participants = users;
			$scope.participantsIndex = {};
			angular.forEach($scope.users.participants, function(participant) {
				$scope.participantsIndex[participant.id] = participant;
			});
			bindUsers($scope.question.participants, $scope.participantsIndex);
		});
	}

	$scope.refreshClients = function(searchKeyword) {
		var searchKeywords = [];
		if (searchKeyword && searchKeyword.length > 0) {
			searchKeywords.push(searchKeyword);
		}

		questionsService.findUsers({'active': 'true', 'fullTextSearch' : searchKeywords}, function(users) {
			$scope.users.clients = users;
			$scope.clientsIndex = {};
			angular.forEach($scope.users.clients, function(client) {
				$scope.clientsIndex[client.id] = client;
			});
			bindUsers($scope.question.clients, $scope.clientsIndex);
		});
	}

	$scope.refreshSupervisors = function(searchKeyword) {
		var searchKeywords = [];
		if (searchKeyword && searchKeyword.length > 0) {
			searchKeywords.push(searchKeyword);
		}

		questionsService.findUsers({'role': 'SUPERVISOR', 'active': 'true', 'fullTextSearch' : searchKeywords}, function(users) {
			$scope.users.supervisors = users;
			$scope.supervisorsIndex = {};
			angular.forEach($scope.users.supervisors, function(supervisor) {
				$scope.supervisorsIndex[supervisor.id] = supervisor;
			});
			bindUsers($scope.question.supervisors, $scope.supervisorsIndex);
		});
	}

	// call refresh for init
	if ($scope.editSession) {
		$scope.refreshExperts("");
		$scope.refreshClients("");
		$scope.refreshSupervisors("");
	}

	// function to be sure to have same user objects in list
	var bindUsers = function(toDeal, index) {
		if (toDeal) {
			for(var i = 0; i < toDeal.length; i++) {
				var user = toDeal[i];
				if (index[user.id]) {
					toDeal[i] = index[user.id];
				}
			}
		}

	};

	if ($routeParams.questionId) {
		questionsService.getQuestion($routeParams.questionId,
			function(question) {
			// success : just get the questions
			$scope.question = question;

			// update scope about current user : if he is participant, more option enable in ui
			if ($scope.question.participants) {
				for (var i = 0; i < $scope.question.participants.length; i++) {
					if ($scope.question.participants[i].id == $scope.currentUser.userId) {
						$scope.isCurrentParticipant = true;
						// Should be able to put new documents in question
						$scope.question.newRelatedDocuments = [];
						break;
					}
				}
			}

			if(!question.relatedDocuments) {
				$scope.question.relatedDocuments = [];
			}

			if (question.participants) {
				$scope.users.participants = question.participants;
				bindUsers($scope.question.participants, $scope.participantsIndex);
			}
			if (question.clients) {
				$scope.users.clients = question.clients;
				bindUsers($scope.question.clients, $scope.clientsIndex);
			}
			if (question.supervisors) {
				$scope.users.supervisors = question.supervisors;
				bindUsers($scope.question.supervisors, $scope.supervisorsIndex);
			}

		}, function(error) {
			// Fail function : TODO
			console.log("error during request");
			console.log(error);
		});
	};

	//Deletion
	$scope.deleteQuestion = function(){
		questionsService.deleteQuestion($routeParams.questionId, function() {
			// success : goto questions list
			$location('#/questions');

		}, function(error) {
			// Fail function : TODO
			console.log(error);
		});
	};

	$scope.saveQuestion = function(){
        if (angular.isDate($scope.question.deadline)) {
            $scope.question.deadline = $scope.question.deadline.getTime();
        }

		// Call service to create a new user
		questionsService.saveQuestion($scope.question, function() {
			$location.search("");
		},function(error) {
			//TODO ymartel 20141118 : deal with error.status or statusText
			console.log("error occurs");
			console.log(error.s);
		});
	};

	$scope.saveQuestion = function(isValidForm){

        if (angular.isDate($scope.question.deadline)) {
            $scope.question.deadline = $scope.question.deadline.getTime();
        }

		// Call service to create a new user
		if(isValidForm) {
			questionsService.saveQuestion($scope.question, function() {
				if ($routeParams.questionId) {
					$location.search("");
				} else {
					$location.path("/questions");
				}
			},function(error) {
				//TODO ymartel 20141118 : deal with error.status or statusText
				console.log("error occurs");
				console.log(error.s);
			});
		}
	}

	$scope.closeQuestion = function(){
		$scope.question.status = "CLOSED";
		questionsService.saveQuestion($scope.question, function() {
			$route.reload();
		},function(error) {
			//TODO ymartel 20141118 : deal with error.status or statusText
			console.log("error occurs");
			console.log(error.s);
		});
	};

	$scope.openCloseQuestionSession = function(){
		if (!$scope.question.closingDocuments) {
			$scope.question.closingDocuments = [];
		}

		$scope.closeSession = true;
	};

	$scope.reopenQuestion = function(){
		$scope.question.status = "IN_PROGRESS";
		questionsService.saveQuestion($scope.question, function() {
			$route.reload();
		},function(error) {
			//TODO ymartel 20141118 : deal with error.status or statusText
			console.log("error occurs");
			console.log(error.s);
		});
	};

	$scope.adjournQuestion = function(){
		$scope.question.status = "ADJOURNED";
		questionsService.saveQuestion($scope.question, function() {
			$route.reload();
		},function(error) {
			//TODO ymartel 20141118 : deal with error.status or statusText
			console.log("error occurs");
			console.log(error.s);
		});
	};

	// New documents added
	$scope.validateNewDocuments = function(){

		if ($scope.question.newRelatedDocuments
		 	&& $scope.question.newRelatedDocuments.length > 0) {

			questionsService.addNewDocuments($routeParams.questionId, $scope.question.newRelatedDocuments, function() {
				$route.reload();

			}, function(error) {
				// Fail function : TODO
				console.log(error);
			});
		}
	};

	$scope.addTheme = function(theme) {
		if (theme && $scope.question.themes.indexOf(theme) == -1) {
			$scope.question.themes.push(theme);
		}
	}

	$scope.removeTheme = function(theme) {
		var position = $scope.question.themes.indexOf(theme);
		if (theme && position != -1) {
			$scope.question.themes.splice(position, 1);
		}
	}

	// Modals part for documents
	$scope.modalSearchDocuments = function (documentList) {

		var modalInstance = $modal.open({
			templateUrl: 'views/documents/modalDocumentSearch.html',
			controller: 'ModalSearchDocumentsCtrl',
			size: 'lg'
		});

		modalInstance.result.then(function (selectedDocument) {
			var already = false;
			for (var i = 0; i < documentList.length; i++) {
				if (documentList[i].id == selectedDocument.id) {
					already = true;
				}
			}
			if (!already) {
				documentList.push(selectedDocument);
			}
		});
	};

	$scope.modalCreateDocument = function (documentList) {

		var modalInstance = $modal.open({
			templateUrl: 'views/documents/modalDocumentEdit.html',
			controller: 'ModalCreateDocumentsCtrl',
			size: 'lg'
		});

		modalInstance.result.then(function (selectedDocument) {
			var already = false;
			for (var i = 0; i < documentList.length; i++) {
				if (documentList[i].id == selectedDocument.id) {
					already = true
				}
			}
			if (!already) {
				documentList.push(selectedDocument);
			}
		});
	};

	$scope.removeDocument = function(document, documentList) {
		var position = documentList.indexOf(document);
		if (document && position != -1) {
			documentList.splice(position, 1);
		}
	};

	// Modals part for parent questions
	$scope.modalSearchParents = function () {

		var modalInstance = $modal.open({
			templateUrl: 'views/questions/modalQuestionSearch.html',
			controller: 'ModalSearchQuestionsCtrl',
			size: 'lg',
			resolve : {
				currentQuestionId : function() {
					return $scope.question.id;
				}
			}
		});

		modalInstance.result.then(function (selectedQuestion) {
			var already = false;
			if ($scope.question.id && $scope.question.id == selectedQuestion.id) {
				already = true;
			}
			if (! $scope.question.parents) {
				$scope.question.parents = [];
			} else {
				for (var i = 0; i < $scope.question.parents.length; i++) {
					if ($scope.question.parents[i].id == selectedQuestion.id) {
						already = true;
					}
				}
			}
			if (!already) {
				$scope.question.parents.push(selectedQuestion);
			}
		});
	};

	$scope.removeParent = function(parent) {
		var position = $scope.question.parents.indexOf(parent);
		if (parent && position != -1) {
			$scope.question.parents.splice(position, 1);
		}
	};

	$scope.isClient = function() {
		var isClient = false;
		angular.forEach($scope.question.clients, function(client) {
			if (client.id == $scope.currentUser.id) {
				isClient = true;
			}
		});
		return isClient;
	};

}]);

coselmarControllers.controller('ModalSearchDocumentsCtrl', function ($scope, $modalInstance, documentService) {

	$scope.searchKeywords = [];

	documentService.getDocuments($scope.searchKeywords, function(documents) {
		$scope.documents = documents;
	});

	$scope.searchDocuments = function(searchKeywords) {
		documentService.getDocuments(searchKeywords, function(documents) {
			$scope.documents = documents;
		});
	};

	$scope.select = function (document) {
		$modalInstance.close(document);
	};

	$scope.cancel = function () {
		$modalInstance.dismiss('cancel');
	};

});

coselmarControllers.controller('ModalSearchQuestionsCtrl', function ($scope, $modalInstance, currentQuestionId, questionsService) {

	$scope.searchKeywords = [];
	$scope.searchOptions = { 'privacy' : '', 'status' : '', 'keywords' : []};
	$scope.currentQuestionId = currentQuestionId;

	questionsService.getQuestions($scope.searchOptions, function(questions) {
		$scope.questions = questions;
	});

	$scope.searchQuestions = function(searchKeywords) {
		$scope.searchOptions = { 'privacy' : '', 'status' : '', 'keywords' : searchKeywords};
		questionsService.getQuestions($scope.searchOptions, function(questions) {
			$scope.questions = questions;
		});

	};

	$scope.select = function (question) {
		$modalInstance.close(question);
	};

	$scope.cancel = function () {
		$modalInstance.dismiss('cancel');
	};

});

coselmarControllers.controller('ModalCreateDocumentsCtrl', function ($scope, $modalInstance, documentService) {

	$scope.document = {'privacy': 'PUBLIC', 'keywords' : []};
	$scope.upload = {};
	$scope.modalExisting = {'keywords' : [], 'types' : []};

	documentService.findAllKeywords(function(result) {
		$scope.modalExisting.keywords = result;
	});

	documentService.findAllTypes(function(result) {
		$scope.modalExisting.types = result;
	});

	$scope.addKeyword = function(keyword) {
		if (keyword && $scope.document.keywords.indexOf(keyword) == -1) {
			$scope.document.keywords.push(keyword);
		}
	}

	$scope.removeKeyword = function(keyword) {
		var position = $scope.document.keywords.indexOf(keyword);
		if (keyword && position != -1) {
			$scope.document.keywords.splice(position, 1);
		}
	}

	$scope.create = function (isValidForm) {

        if (angular.isDate($scope.document.publicationDate)) {
            $scope.document.publicationDate = $scope.document.publicationDate.getTime();
        }

		if (isValidForm) {
          documentService.saveDocument($scope.document, function(document) {
              if ($scope.upload.file) {
                var documentId = document.id;
                documentService.saveDocumentFile(documentId, $scope.upload.file, function() {
			      $modalInstance.close(document);
                });
              } else {
                $modalInstance.close(document);
              }
            }, function(error) {
              console.log("error occurs");
            }
          );
		}
	};

	$scope.cancel = function () {
		$modalInstance.dismiss('cancel');
	};

});


/////////////////////////////////////////////////
///////////  Referential Part  //////////////////
/////////////////////////////////////////////////

// Controller for Referential Page
coselmarControllers.controller("ReferentialCtrl", ['$scope', '$routeParams', '$location', 'questionsService', 'documentService',
 					function($scope, $routeParams, $location, questionsService, documentService){

	$scope.result = { questions : [], documents : []};

	var remoteSearchInReferential = function() {
		if ($scope.search.onQuestions && $scope.search.keywords.length > 0) {
			var questionSearchOptions = { 'privacy' : '', 'status' : '', 'keywords' : $scope.search.keywords};
			questionsService.getQuestions(questionSearchOptions, function(questions) {
				$scope.result.questions = questions;
			});
		};

		if ($scope.search.onDocuments && $scope.search.keywords.length > 0) {
			documentService.getDocuments($scope.search.keywords, function(documents) {
				$scope.result.documents = documents;
			});
		};

	};

	//init scope : if routeParams, use values
    if ($routeParams &&
     ($routeParams.keywords
        || $routeParams.onDocuments
        || $routeParams.onQuestions)) {

	    $scope.search = { keywords : [], onDocuments: false, onQuestions: false };

        var keywords = $routeParams.keywords;
        if (Array.isArray(keywords)) {
            $scope.search.keywords = keywords;
        } else if (keywords) {
            $scope.search.keywords.push(keywords);
        }

        var onQuestions = $routeParams.onQuestions;
        if (onQuestions) {
            $scope.search.onQuestions = onQuestions;
        }

        var onDocuments = $routeParams.onDocuments;
        if (onDocuments) {
            $scope.search.onDocuments = onDocuments;
        }

        // Launch search
	    remoteSearchInReferential();

    } else {
        // else, default values for screen init, no search is done
	    $scope.search = { keywords : [], onDocuments: true, onQuestions: true };
    }

	$scope.searchInReferential = function(){

		if ($scope.search.keywords) {
			$location.search('keywords', $scope.search.keywords);
		} else {
			$location.search('keywords', null);
		}

		if ($scope.search.onDocuments) {
			$location.search('onDocuments', $scope.search.onDocuments);
		} else {
			$location.search('onDocuments', null);
		}

		if ($scope.search.onQuestions) {
			$location.search('onQuestions', $scope.search.onQuestions);
		} else {
			$location.search('onQuestions', null);
		}
	};

}]);


/////////////////////////////////////////////////
//////////////  Admin Part  /////////////////////
/////////////////////////////////////////////////

// Controller for Admin Page
coselmarControllers.controller("AdminCtrl", ['$scope', '$routeParams', '$location', 'adminService',
 					function($scope, $routeParams, $location, adminService){

	$scope.status = { 'indexRefresh' : 'none'};

	$scope.refreshIndex = function() {
		$scope.status.indexRefresh = "inprogress";

		adminService.refreshIndex(function() {
					$scope.status.indexRefresh = "finish";

				},function(error) {
					$scope.status.indexRefresh = "error";
			});

	};

}]);

/**
 * AngularJS default filter with the following expression:
 * "person in people | filter: {name: $select.search, age: $select.search}"
 * performs a AND between 'name: $select.search' and 'age: $select.search'.
 * We want to perform a OR.
 *
 * Extract from angular-ui-select demo :
 * https://github.com/angular-ui/ui-select/blob/master/examples/demo.js
 */
coselmarControllers.filter('propsFilter', function() {
  return function(items, props) {
    var out = [];

    if (angular.isArray(items)) {
      items.forEach(function(item) {
        var itemMatches = false;

        var keys = Object.keys(props);
        for (var i = 0; i < keys.length; i++) {
          var prop = keys[i];
          var text = props[prop].toLowerCase();
          if (item[prop] && item[prop].toString().toLowerCase().indexOf(text) !== -1) {
            itemMatches = true;
            break;
          }
        }

        if (itemMatches) {
          out.push(item);
        }
      });
    } else {
      // Let the output be the input untouched
      out = items;
    }

    return out;
  };
});


/**
 * A generic confirmation modal for risky actions such delete.
 *
 * Usage: Add attributes: ng-confirm-message="Are you sure"? ng-confirm-click="riskyAction()"
 */
coselmarControllers.directive('ngConfirmClick', ['$modal', function($modal) {

	var ModalInstanceCtrl = function($scope, $modalInstance) {
		$scope.ok = function() {
			$modalInstance.close();
		};

		$scope.cancel = function() {
			$modalInstance.dismiss('cancel');
		};
	};

    return {
        restrict: 'A',
        scope:{
          onConfirm : "&ngConfirmClick",
        },

        link: function(scope, element, attrs) {
          	element.bind('click', function() {
				var message = attrs.ngConfirmMessage || "Are you sure ?";

				var modalHtml = '<div class="modal-title"><h2>Confirm Action</h2></div>';
				modalHtml += '<div class="modal-body"> {{\'' + message + '\' | translate}}</div>';
				modalHtml += '<div class="modal-footer"><button class="btn btn-primary" ng-click="ok()">OK</button><button class="btn btn-warning" ng-click="cancel()">{{ \'common.button.cancel\' | translate }}</button></div>';

				var modalInstance = $modal.open({
				  	template: modalHtml,
				  	controller: ModalInstanceCtrl
				});

				modalInstance.result.then(function() {
				  	scope.onConfirm();
				}, function() {
				  	//Modal dismissed
				});

          	});

        }
    }
}]);