package fr.ifremer.coselmar.persistence.entity;

/*
 * #%L
 * Coselmar :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Ifremer, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Tue Mar 03 15:18:20 UTC 2015")
public abstract class QuestionAbstract extends AbstractTopiaEntity implements Question {

    /**
     * Nom de l'attribut en BD : title
     */
    protected String title;

    /**
     * Nom de l'attribut en BD : type
     */
    protected String type;

    /**
     * Nom de l'attribut en BD : summary
     */
    protected String summary;

    /**
     * Nom de l'attribut en BD : submissionDate
     */
    protected Date submissionDate;

    /**
     * Nom de l'attribut en BD : deadline
     */
    protected Date deadline;

    /**
     * Nom de l'attribut en BD : theme
     */
    protected Collection<String> theme;

    /**
     * Nom de l'attribut en BD : closingDate
     */
    protected Date closingDate;

    /**
     * Nom de l'attribut en BD : externalExperts
     */
    protected Collection<String> externalExperts;

    /**
     * Nom de l'attribut en BD : unavailable
     */
    protected boolean unavailable;

    /**
     * Nom de l'attribut en BD : conclusion
     */
    protected String conclusion;

    /**
     * Nom de l'attribut en BD : participants
     */
    protected CoselmarUserGroup participants;

    /**
     * Nom de l'attribut en BD : closingDocuments
     */
    protected Set<Document> closingDocuments;

    /**
     * Nom de l'attribut en BD : supervisors
     */
    protected Set<CoselmarUser> supervisors;

    /**
     * Nom de l'attribut en BD : contributors
     */
    protected Set<CoselmarUser> contributors;

    /**
     * Nom de l'attribut en BD : parents
     */
    protected Set<Question> parents;

    /**
     * Nom de l'attribut en BD : clients
     */
    protected Set<CoselmarUser> clients;

    /**
     * Nom de l'attribut en BD : privacy
     */
    protected Privacy privacy;

    /**
     * Nom de l'attribut en BD : relatedDocuments
     */
    protected Set<Document> relatedDocuments;

    /**
     * Nom de l'attribut en BD : status
     */
    protected Status status;

    private static final long serialVersionUID = 4049127716117635640L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_TITLE, String.class, title);
        visitor.visit(this, PROPERTY_TYPE, String.class, type);
        visitor.visit(this, PROPERTY_SUMMARY, String.class, summary);
        visitor.visit(this, PROPERTY_SUBMISSION_DATE, Date.class, submissionDate);
        visitor.visit(this, PROPERTY_DEADLINE, Date.class, deadline);
        visitor.visit(this, PROPERTY_THEME, Collection.class, String.class, theme);
        visitor.visit(this, PROPERTY_CLOSING_DATE, Date.class, closingDate);
        visitor.visit(this, PROPERTY_EXTERNAL_EXPERTS, Collection.class, String.class, externalExperts);
        visitor.visit(this, PROPERTY_UNAVAILABLE, boolean.class, unavailable);
        visitor.visit(this, PROPERTY_CONCLUSION, String.class, conclusion);
        visitor.visit(this, PROPERTY_PARTICIPANTS, CoselmarUserGroup.class, participants);
        visitor.visit(this, PROPERTY_CLOSING_DOCUMENTS, Set.class, Document.class, closingDocuments);
        visitor.visit(this, PROPERTY_SUPERVISORS, Set.class, CoselmarUser.class, supervisors);
        visitor.visit(this, PROPERTY_CONTRIBUTORS, Set.class, CoselmarUser.class, contributors);
        visitor.visit(this, PROPERTY_PARENTS, Set.class, Question.class, parents);
        visitor.visit(this, PROPERTY_CLIENTS, Set.class, CoselmarUser.class, clients);
        visitor.visit(this, PROPERTY_PRIVACY, Privacy.class, privacy);
        visitor.visit(this, PROPERTY_RELATED_DOCUMENTS, Set.class, Document.class, relatedDocuments);
        visitor.visit(this, PROPERTY_STATUS, Status.class, status);
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        String result = this.title;
        return result;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getType() {
        String result = this.type;
        return result;
    }

    @Override
    public void setSummary(String summary) {
        this.summary = summary;
    }

    @Override
    public String getSummary() {
        String result = this.summary;
        return result;
    }

    @Override
    public void setSubmissionDate(Date submissionDate) {
        this.submissionDate = submissionDate;
    }

    @Override
    public Date getSubmissionDate() {
        Date result = this.submissionDate;
        return result;
    }

    @Override
    public void setDeadline(Date deadline) {
        this.deadline = deadline;
    }

    @Override
    public Date getDeadline() {
        Date result = this.deadline;
        return result;
    }

    @Override
    public void addTheme(String theme) {
        if (this.theme == null) {
            this.theme = new LinkedList<String>();
        }
        this.theme.add(theme);
    }

    @Override
    public void addAllTheme(Iterable<String> theme) {
        if (theme == null) {
            return;
        }
        for (String item : theme) {
            addTheme(item);
        }
    }

    @Override
    public void setTheme(Collection<String> theme) {
        this.theme = theme;
    }

    @Override
    public void removeTheme(String theme) {
        if (this.theme == null || !this.theme.remove(theme)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearTheme() {
        if (this.theme == null) {
            return;
        }
        this.theme.clear();
    }

    @Override
    public Collection<String> getTheme() {
        return theme;
    }

    @Override
    public int sizeTheme() {
        if (theme == null) {
            return 0;
        }
        return theme.size();
    }

    @Override
    public boolean isThemeEmpty() {
        int size = sizeTheme();
        return size == 0;
    }

    @Override
    public boolean isThemeNotEmpty() {
        boolean empty = isThemeEmpty();
        return ! empty;
    }

    @Override
    public boolean containsTheme(String theme) {
        boolean contains = this.theme !=null && this.theme.contains(theme);
        return contains;
    }

    @Override
    public void setClosingDate(Date closingDate) {
        this.closingDate = closingDate;
    }

    @Override
    public Date getClosingDate() {
        Date result = this.closingDate;
        return result;
    }

    @Override
    public void addExternalExperts(String externalExperts) {
        if (this.externalExperts == null) {
            this.externalExperts = new LinkedList<String>();
        }
        this.externalExperts.add(externalExperts);
    }

    @Override
    public void addAllExternalExperts(Iterable<String> externalExperts) {
        if (externalExperts == null) {
            return;
        }
        for (String item : externalExperts) {
            addExternalExperts(item);
        }
    }

    @Override
    public void setExternalExperts(Collection<String> externalExperts) {
        this.externalExperts = externalExperts;
    }

    @Override
    public void removeExternalExperts(String externalExperts) {
        if (this.externalExperts == null || !this.externalExperts.remove(externalExperts)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearExternalExperts() {
        if (this.externalExperts == null) {
            return;
        }
        this.externalExperts.clear();
    }

    @Override
    public Collection<String> getExternalExperts() {
        return externalExperts;
    }

    @Override
    public int sizeExternalExperts() {
        if (externalExperts == null) {
            return 0;
        }
        return externalExperts.size();
    }

    @Override
    public boolean isExternalExpertsEmpty() {
        int size = sizeExternalExperts();
        return size == 0;
    }

    @Override
    public boolean isExternalExpertsNotEmpty() {
        boolean empty = isExternalExpertsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsExternalExperts(String externalExperts) {
        boolean contains = this.externalExperts !=null && this.externalExperts.contains(externalExperts);
        return contains;
    }

    @Override
    public void setUnavailable(boolean unavailable) {
        this.unavailable = unavailable;
    }

    @Override
    public boolean isUnavailable() {
        boolean result = this.unavailable;
        return result;
    }

    @Override
    public void setConclusion(String conclusion) {
        this.conclusion = conclusion;
    }

    @Override
    public String getConclusion() {
        String result = this.conclusion;
        return result;
    }

    @Override
    public void setParticipants(CoselmarUserGroup participants) {
        this.participants = participants;
    }

    @Override
    public CoselmarUserGroup getParticipants() {
        CoselmarUserGroup result = this.participants;
        return result;
    }

    @Override
    public void addClosingDocuments(Document closingDocuments) {
        if (this.closingDocuments == null) {
            this.closingDocuments = new HashSet<Document>();
        }
        this.closingDocuments.add(closingDocuments);
    }

    @Override
    public void addAllClosingDocuments(Iterable<Document> closingDocuments) {
        if (closingDocuments == null) {
            return;
        }
        for (Document item : closingDocuments) {
            addClosingDocuments(item);
        }
    }

    @Override
    public void setClosingDocuments(Set<Document> closingDocuments) {
        this.closingDocuments = closingDocuments;
    }

    @Override
    public void removeClosingDocuments(Document closingDocuments) {
        if (this.closingDocuments == null || !this.closingDocuments.remove(closingDocuments)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearClosingDocuments() {
        if (this.closingDocuments == null) {
            return;
        }
        this.closingDocuments.clear();
    }

    @Override
    public Set<Document> getClosingDocuments() {
        return closingDocuments;
    }

    @Override
    public Document getClosingDocumentsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(closingDocuments, topiaId);
    }

    @Override
    public Set<String> getClosingDocumentsTopiaIds() {
        Set<String> topiaIds = new HashSet<String>();
        Set<fr.ifremer.coselmar.persistence.entity.Document> tmp = getClosingDocuments();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeClosingDocuments() {
        if (closingDocuments == null) {
            return 0;
        }
        return closingDocuments.size();
    }

    @Override
    public boolean isClosingDocumentsEmpty() {
        int size = sizeClosingDocuments();
        return size == 0;
    }

    @Override
    public boolean isClosingDocumentsNotEmpty() {
        boolean empty = isClosingDocumentsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsClosingDocuments(Document closingDocuments) {
        boolean contains = this.closingDocuments !=null && this.closingDocuments.contains(closingDocuments);
        return contains;
    }

    @Override
    public void addSupervisors(CoselmarUser supervisors) {
        if (this.supervisors == null) {
            this.supervisors = new HashSet<CoselmarUser>();
        }
        this.supervisors.add(supervisors);
    }

    @Override
    public void addAllSupervisors(Iterable<CoselmarUser> supervisors) {
        if (supervisors == null) {
            return;
        }
        for (CoselmarUser item : supervisors) {
            addSupervisors(item);
        }
    }

    @Override
    public void setSupervisors(Set<CoselmarUser> supervisors) {
        this.supervisors = supervisors;
    }

    @Override
    public void removeSupervisors(CoselmarUser supervisors) {
        if (this.supervisors == null || !this.supervisors.remove(supervisors)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearSupervisors() {
        if (this.supervisors == null) {
            return;
        }
        this.supervisors.clear();
    }

    @Override
    public Set<CoselmarUser> getSupervisors() {
        return supervisors;
    }

    @Override
    public CoselmarUser getSupervisorsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(supervisors, topiaId);
    }

    @Override
    public Set<String> getSupervisorsTopiaIds() {
        Set<String> topiaIds = new HashSet<String>();
        Set<fr.ifremer.coselmar.persistence.entity.CoselmarUser> tmp = getSupervisors();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeSupervisors() {
        if (supervisors == null) {
            return 0;
        }
        return supervisors.size();
    }

    @Override
    public boolean isSupervisorsEmpty() {
        int size = sizeSupervisors();
        return size == 0;
    }

    @Override
    public boolean isSupervisorsNotEmpty() {
        boolean empty = isSupervisorsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsSupervisors(CoselmarUser supervisors) {
        boolean contains = this.supervisors !=null && this.supervisors.contains(supervisors);
        return contains;
    }

    @Override
    public void addContributors(CoselmarUser contributors) {
        if (this.contributors == null) {
            this.contributors = new HashSet<CoselmarUser>();
        }
        this.contributors.add(contributors);
    }

    @Override
    public void addAllContributors(Iterable<CoselmarUser> contributors) {
        if (contributors == null) {
            return;
        }
        for (CoselmarUser item : contributors) {
            addContributors(item);
        }
    }

    @Override
    public void setContributors(Set<CoselmarUser> contributors) {
        this.contributors = contributors;
    }

    @Override
    public void removeContributors(CoselmarUser contributors) {
        if (this.contributors == null || !this.contributors.remove(contributors)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearContributors() {
        if (this.contributors == null) {
            return;
        }
        this.contributors.clear();
    }

    @Override
    public Set<CoselmarUser> getContributors() {
        return contributors;
    }

    @Override
    public CoselmarUser getContributorsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(contributors, topiaId);
    }

    @Override
    public Set<String> getContributorsTopiaIds() {
        Set<String> topiaIds = new HashSet<String>();
        Set<fr.ifremer.coselmar.persistence.entity.CoselmarUser> tmp = getContributors();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeContributors() {
        if (contributors == null) {
            return 0;
        }
        return contributors.size();
    }

    @Override
    public boolean isContributorsEmpty() {
        int size = sizeContributors();
        return size == 0;
    }

    @Override
    public boolean isContributorsNotEmpty() {
        boolean empty = isContributorsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsContributors(CoselmarUser contributors) {
        boolean contains = this.contributors !=null && this.contributors.contains(contributors);
        return contains;
    }

    @Override
    public void addParents(Question parents) {
        if (this.parents == null) {
            this.parents = new HashSet<Question>();
        }
        this.parents.add(parents);
    }

    @Override
    public void addAllParents(Iterable<Question> parents) {
        if (parents == null) {
            return;
        }
        for (Question item : parents) {
            addParents(item);
        }
    }

    @Override
    public void setParents(Set<Question> parents) {
        this.parents = parents;
    }

    @Override
    public void removeParents(Question parents) {
        if (this.parents == null || !this.parents.remove(parents)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearParents() {
        if (this.parents == null) {
            return;
        }
        this.parents.clear();
    }

    @Override
    public Set<Question> getParents() {
        return parents;
    }

    @Override
    public Question getParentsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(parents, topiaId);
    }

    @Override
    public Set<String> getParentsTopiaIds() {
        Set<String> topiaIds = new HashSet<String>();
        Set<fr.ifremer.coselmar.persistence.entity.Question> tmp = getParents();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeParents() {
        if (parents == null) {
            return 0;
        }
        return parents.size();
    }

    @Override
    public boolean isParentsEmpty() {
        int size = sizeParents();
        return size == 0;
    }

    @Override
    public boolean isParentsNotEmpty() {
        boolean empty = isParentsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsParents(Question parents) {
        boolean contains = this.parents !=null && this.parents.contains(parents);
        return contains;
    }

    @Override
    public void addClients(CoselmarUser clients) {
        if (this.clients == null) {
            this.clients = new HashSet<CoselmarUser>();
        }
        this.clients.add(clients);
    }

    @Override
    public void addAllClients(Iterable<CoselmarUser> clients) {
        if (clients == null) {
            return;
        }
        for (CoselmarUser item : clients) {
            addClients(item);
        }
    }

    @Override
    public void setClients(Set<CoselmarUser> clients) {
        this.clients = clients;
    }

    @Override
    public void removeClients(CoselmarUser clients) {
        if (this.clients == null || !this.clients.remove(clients)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearClients() {
        if (this.clients == null) {
            return;
        }
        this.clients.clear();
    }

    @Override
    public Set<CoselmarUser> getClients() {
        return clients;
    }

    @Override
    public CoselmarUser getClientsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(clients, topiaId);
    }

    @Override
    public Set<String> getClientsTopiaIds() {
        Set<String> topiaIds = new HashSet<String>();
        Set<fr.ifremer.coselmar.persistence.entity.CoselmarUser> tmp = getClients();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeClients() {
        if (clients == null) {
            return 0;
        }
        return clients.size();
    }

    @Override
    public boolean isClientsEmpty() {
        int size = sizeClients();
        return size == 0;
    }

    @Override
    public boolean isClientsNotEmpty() {
        boolean empty = isClientsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsClients(CoselmarUser clients) {
        boolean contains = this.clients !=null && this.clients.contains(clients);
        return contains;
    }

    @Override
    public void setPrivacy(Privacy privacy) {
        this.privacy = privacy;
    }

    @Override
    public Privacy getPrivacy() {
        Privacy result = this.privacy;
        return result;
    }

    @Override
    public void addRelatedDocuments(Document relatedDocuments) {
        if (this.relatedDocuments == null) {
            this.relatedDocuments = new HashSet<Document>();
        }
        this.relatedDocuments.add(relatedDocuments);
    }

    @Override
    public void addAllRelatedDocuments(Iterable<Document> relatedDocuments) {
        if (relatedDocuments == null) {
            return;
        }
        for (Document item : relatedDocuments) {
            addRelatedDocuments(item);
        }
    }

    @Override
    public void setRelatedDocuments(Set<Document> relatedDocuments) {
        this.relatedDocuments = relatedDocuments;
    }

    @Override
    public void removeRelatedDocuments(Document relatedDocuments) {
        if (this.relatedDocuments == null || !this.relatedDocuments.remove(relatedDocuments)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearRelatedDocuments() {
        if (this.relatedDocuments == null) {
            return;
        }
        this.relatedDocuments.clear();
    }

    @Override
    public Set<Document> getRelatedDocuments() {
        return relatedDocuments;
    }

    @Override
    public Document getRelatedDocumentsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(relatedDocuments, topiaId);
    }

    @Override
    public Set<String> getRelatedDocumentsTopiaIds() {
        Set<String> topiaIds = new HashSet<String>();
        Set<fr.ifremer.coselmar.persistence.entity.Document> tmp = getRelatedDocuments();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeRelatedDocuments() {
        if (relatedDocuments == null) {
            return 0;
        }
        return relatedDocuments.size();
    }

    @Override
    public boolean isRelatedDocumentsEmpty() {
        int size = sizeRelatedDocuments();
        return size == 0;
    }

    @Override
    public boolean isRelatedDocumentsNotEmpty() {
        boolean empty = isRelatedDocumentsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsRelatedDocuments(Document relatedDocuments) {
        boolean contains = this.relatedDocuments !=null && this.relatedDocuments.contains(relatedDocuments);
        return contains;
    }

    @Override
    public void setStatus(Status status) {
        this.status = status;
    }

    @Override
    public Status getStatus() {
        Status result = this.status;
        return result;
    }

} //QuestionAbstract
