package fr.ifremer.coselmar.persistence.entity;

import fr.ifremer.coselmar.persistence.AbstractCoselmarTopiaDao;
import fr.ifremer.coselmar.persistence.CoselmarEntityEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Tue Nov 18 08:37:42 UTC 2014")
public abstract class GeneratedDocumentTopiaDao<E extends Document> extends AbstractCoselmarTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) Document.class;
    }

    @Override
    public CoselmarEntityEnum getTopiaEntityEnum() {
        return CoselmarEntityEnum.Document;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        super.delete(entity);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Document.PROPERTY_NAME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Document.PROPERTY_NAME, v);
        return result;
    }

    @Deprecated
    public E findByName(String v) {
        return forNameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByName(String v) {
        return forNameEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDepositDateIn(Collection<Date> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Document.PROPERTY_DEPOSIT_DATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDepositDateEquals(Date v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Document.PROPERTY_DEPOSIT_DATE, v);
        return result;
    }

    @Deprecated
    public E findByDepositDate(Date v) {
        return forDepositDateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByDepositDate(Date v) {
        return forDepositDateEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forKeywordsContains(String v) {
        return forContains(Document.PROPERTY_KEYWORDS, v);
    }

    @Deprecated
    public E findContainsKeywords(String v) {
        return forKeywordsContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsKeywords(String v) {
        return forKeywordsContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMimeTypeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Document.PROPERTY_MIME_TYPE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMimeTypeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Document.PROPERTY_MIME_TYPE, v);
        return result;
    }

    @Deprecated
    public E findByMimeType(String v) {
        return forMimeTypeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByMimeType(String v) {
        return forMimeTypeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPrivacyIn(Collection<DocumentPrivacy> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Document.PROPERTY_PRIVACY, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPrivacyEquals(DocumentPrivacy v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Document.PROPERTY_PRIVACY, v);
        return result;
    }

    @Deprecated
    public E findByPrivacy(DocumentPrivacy v) {
        return forPrivacyEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPrivacy(DocumentPrivacy v) {
        return forPrivacyEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOwnerIn(Collection<User> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Document.PROPERTY_OWNER, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOwnerEquals(User v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Document.PROPERTY_OWNER, v);
        return result;
    }

    @Deprecated
    public E findByOwner(User v) {
        return forOwnerEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByOwner(User v) {
        return forOwnerEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        return new LinkedList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedDocumentTopiaDao<E extends Document>
