package fr.ifremer.coselmar.persistence.entity;

import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Tue Nov 18 08:37:42 UTC 2014")
public abstract class DocumentAbstract extends AbstractTopiaEntity implements Document {

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : depositDate
     */
    protected Date depositDate;

    /**
     * Nom de l'attribut en BD : keywords
     */
    protected Collection<String> keywords;

    /**
     * Nom de l'attribut en BD : mimeType
     */
    protected String mimeType;

    /**
     * Nom de l'attribut en BD : privacy
     */
    protected DocumentPrivacy privacy;

    /**
     * Nom de l'attribut en BD : owner
     */
    protected User owner;

    private static final long serialVersionUID = 3691042058337018675L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_DEPOSIT_DATE, Date.class, depositDate);
        visitor.visit(this, PROPERTY_KEYWORDS, Collection.class, String.class, keywords);
        visitor.visit(this, PROPERTY_MIME_TYPE, String.class, mimeType);
        visitor.visit(this, PROPERTY_PRIVACY, DocumentPrivacy.class, privacy);
        visitor.visit(this, PROPERTY_OWNER, User.class, owner);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        String result = this.name;
        return result;
    }

    @Override
    public void setDepositDate(Date depositDate) {
        this.depositDate = depositDate;
    }

    @Override
    public Date getDepositDate() {
        Date result = this.depositDate;
        return result;
    }

    @Override
    public void addKeywords(String keywords) {
        if (this.keywords == null) {
            this.keywords = new LinkedList<String>();
        }
        this.keywords.add(keywords);
    }

    @Override
    public void addAllKeywords(Collection<String> keywords) {
        if (keywords == null) {
            return;
        }
        for (String item : keywords) {
            addKeywords(item);
        }
    }

    @Override
    public void setKeywords(Collection<String> keywords) {
        this.keywords = keywords;
    }

    @Override
    public void removeKeywords(String keywords) {
        if (this.keywords == null || !this.keywords.remove(keywords)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearKeywords() {
        if (this.keywords == null) {
            return;
        }
        this.keywords.clear();
    }

    @Override
    public Collection<String> getKeywords() {
        return keywords;
    }

    @Override
    public int sizeKeywords() {
        if (keywords == null) {
            return 0;
        }
        return keywords.size();
    }

    @Override
    public boolean isKeywordsEmpty() {
        int size = sizeKeywords();
        return size == 0;
    }

    @Override
    public boolean isKeywordsNotEmpty() {
        boolean empty = isKeywordsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsKeywords(String keywords) {
        boolean contains = this.keywords !=null && this.keywords.contains(keywords);
        return contains;
    }

    @Override
    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    @Override
    public String getMimeType() {
        String result = this.mimeType;
        return result;
    }

    @Override
    public void setPrivacy(DocumentPrivacy privacy) {
        this.privacy = privacy;
    }

    @Override
    public DocumentPrivacy getPrivacy() {
        DocumentPrivacy result = this.privacy;
        return result;
    }

    @Override
    public void setOwner(User owner) {
        this.owner = owner;
    }

    @Override
    public User getOwner() {
        User result = this.owner;
        return result;
    }

} //DocumentAbstract
