/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coselmar.services.indexation;

import fr.ifremer.coselmar.config.CloudWordUtils;
import fr.ifremer.coselmar.services.CoselmarSimpleServiceSupport;
import fr.ifremer.coselmar.services.StringLongMapValueComparator;
import java.io.IOException;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.misc.HighFreqTerms;
import org.apache.lucene.misc.HighFreqTermsMultiFields;
import org.apache.lucene.misc.TermStats;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class TransverseIndexationService
extends CoselmarSimpleServiceSupport {
    protected void cleanAllIndex() throws IOException {
        BooleanQuery query = new BooleanQuery.Builder().add((Query)new TermQuery(new Term("type", "questionindextype")), BooleanClause.Occur.SHOULD).add((Query)new TermQuery(new Term("type", "documentindextype")), BooleanClause.Occur.SHOULD).add((Query)new TermQuery(new Term("type", "question")), BooleanClause.Occur.SHOULD).add((Query)new TermQuery(new Term("type", "document")), BooleanClause.Occur.SHOULD).build();
        this.getLuceneUtils().getIndexWriter().deleteDocuments(new Query[]{query});
        this.getLuceneUtils().getIndexWriter().commit();
    }

    public Map<String, Long> getTopTerms() throws IOException, ParseException {
        DirectoryReader indexReader = DirectoryReader.open((IndexWriter)this.getLuceneUtils().getIndexWriter());
        LinkedHashMap<String, Long> topWords = new LinkedHashMap<String, Long>();
        try {
            TermStats[] highFreqTerms;
            String[] searchedFields = new String[]{"questionCloudTagTitle", "questionCloudTagTheme", "documentCloudTagName", "documentCloudTagKeyword", "documentFileContent"};
            for (TermStats termStats : highFreqTerms = HighFreqTermsMultiFields.getHighFreqTermsMultiFields((IndexReader)indexReader, (int)60, (String[])searchedFields, (Comparator)new HighFreqTerms.TotalTermFreqComparator())) {
                long totalTermFreq = termStats.totalTermFreq;
                String value = termStats.termtext.utf8ToString();
                if (!CloudWordUtils.isCloudableTerm((String)value)) continue;
                if (topWords.containsKey(value)) {
                    topWords.put(value, (Long)topWords.get(value) + totalTermFreq);
                    continue;
                }
                topWords.put(value, totalTermFreq);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        indexReader.close();
        StringLongMapValueComparator valueComparator = new StringLongMapValueComparator(topWords);
        TreeMap<String, Long> sortedResult = new TreeMap<String, Long>((Comparator<String>)valueComparator);
        sortedResult.putAll(topWords);
        TreeMap<String, Long> result = new TreeMap<String, Long>();
        int count = 20;
        for (Map.Entry key : sortedResult.entrySet()) {
            result.put((String)key.getKey(), (Long)key.getValue());
            if (--count != 0) continue;
            break;
        }
        return result;
    }
}

