/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coselmar.services.v1;

import com.auth0.jwt.Algorithm;
import com.auth0.jwt.JWTSigner;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import com.google.common.base.Preconditions;
import fr.ifremer.coselmar.beans.UserAccountCreatedMail;
import fr.ifremer.coselmar.beans.UserBean;
import fr.ifremer.coselmar.beans.UserSearchBean;
import fr.ifremer.coselmar.beans.UserWebToken;
import fr.ifremer.coselmar.converter.BeanEntityConverter;
import fr.ifremer.coselmar.persistence.SearchRequestBean;
import fr.ifremer.coselmar.persistence.entity.CoselmarUser;
import fr.ifremer.coselmar.persistence.entity.CoselmarUserRole;
import fr.ifremer.coselmar.services.CoselmarTechnicalException;
import fr.ifremer.coselmar.services.CoselmarWebServiceSupport;
import fr.ifremer.coselmar.services.config.CoselmarServicesConfig;
import fr.ifremer.coselmar.services.errors.InvalidCredentialException;
import fr.ifremer.coselmar.services.errors.UnauthorizedException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.Charsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.SimpleEmail;
import org.debux.webmotion.server.render.Render;
import org.nuiton.topia.persistence.TopiaNoResultException;

public class UsersWebService
extends CoselmarWebServiceSupport {
    private static final Log log = LogFactory.getLog(UsersWebService.class);

    public UserBean getUser(String userId) throws InvalidCredentialException, UnauthorizedException, TopiaNoResultException {
        String authorization = this.getContext().getHeader("Authorization");
        UserWebToken userWebToken = this.checkAuthentication(authorization);
        if (!StringUtils.equals((CharSequence)userWebToken.getRole(), (CharSequence)CoselmarUserRole.ADMIN.name()) && !StringUtils.equals((CharSequence)userWebToken.getUserId(), (CharSequence)userId)) {
            if (log.isDebugEnabled()) {
                String message = String.format("A non admin user try to see account details with shortId '%s'", userId);
                log.debug((Object)message);
            }
            throw new UnauthorizedException("Not allowed to see user details");
        }
        String fullId = CoselmarUser.class.getCanonicalName() + this.getPersistenceContext().getTopiaIdFactory().getSeparator() + userId;
        CoselmarUser user = (CoselmarUser)this.getCoselmarUserDao().forTopiaIdEquals(fullId).findUnique();
        UserBean userBean = BeanEntityConverter.toBean((String)userId, (CoselmarUser)user);
        return userBean;
    }

    public List<UserBean> getUsers(String searchKeyword, UserSearchBean search, boolean onlyActive) {
        List userList;
        if (StringUtils.isNotBlank((CharSequence)searchKeyword)) {
            userList = this.getCoselmarUserDao().findAllLikeKeywords(Arrays.asList(searchKeyword), onlyActive);
        } else if (search != null) {
            SearchRequestBean requestBean = new SearchRequestBean();
            requestBean.setLimit(search.getLimit());
            requestBean.setPage(search.getPage());
            requestBean.setFullTextSearch(search.getFullTextSearch());
            CoselmarUser example = BeanEntityConverter.fromBean((UserBean)search);
            userList = this.getCoselmarUserDao().findAllByExample(example, search.isOnlyActive(), requestBean);
        } else {
            userList = onlyActive ? this.getCoselmarUserDao().forActiveEquals(true).findAll() : this.getCoselmarUserDao().findAll();
        }
        ArrayList<UserBean> result = new ArrayList<UserBean>(userList.size());
        for (CoselmarUser user : userList) {
            String userLightId = this.getPersistenceContext().getTopiaIdFactory().getRandomPart(user.getTopiaId());
            UserBean userBean = BeanEntityConverter.toBean((String)userLightId, (CoselmarUser)user);
            result.add(userBean);
        }
        return result;
    }

    public void addUser(UserBean user) throws InvalidParameterException {
        Preconditions.checkNotNull((Object)user);
        CoselmarUser userEntity = (CoselmarUser)this.getCoselmarUserDao().create();
        userEntity.setFirstname(user.getFirstName());
        userEntity.setName(user.getName());
        String mail = this.getCleanMail(user.getMail());
        this.checkMailUnicity(mail, null);
        userEntity.setMail(mail);
        userEntity.setRole(CoselmarUserRole.valueOf((String)user.getRole().toUpperCase()));
        userEntity.setQualification(user.getQualification());
        userEntity.setOrganization(user.getOrganization());
        userEntity.setActive(true);
        String password = user.getPassword();
        if (StringUtils.isBlank((CharSequence)password)) {
            password = this.getServicesContext().generatePassword();
        }
        String salt = this.getServicesContext().generateSalt();
        String encodedPassword = this.getServicesContext().encodePassword(salt, password);
        userEntity.setPassword(encodedPassword);
        userEntity.setSalt(salt);
        this.commit();
        UserAccountCreatedMail userAccountCreatedMail = new UserAccountCreatedMail(this.getServicesContext().getLocale());
        userAccountCreatedMail.setUser(user);
        userAccountCreatedMail.setPassword(password);
        userAccountCreatedMail.setTo(user.getMail());
        this.sendMail(userAccountCreatedMail);
    }

    public void modifyUser(UserBean user) throws InvalidCredentialException, UnauthorizedException, InvalidParameterException, TopiaNoResultException {
        String newPassword;
        String qualification;
        String organization;
        String firstName;
        String mail;
        String authorization = this.getContext().getHeader("Authorization");
        UserWebToken userWebToken = this.checkAuthentication(authorization);
        boolean isAdmin = StringUtils.equals((CharSequence)userWebToken.getRole(), (CharSequence)CoselmarUserRole.ADMIN.name());
        String userId = user.getId();
        if (StringUtils.isBlank((CharSequence)userId)) {
            throw new InvalidParameterException("User.id is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)user.getPassword()) && !isAdmin) {
            throw new InvalidParameterException("User.password is mandatory");
        }
        if (!isAdmin && !StringUtils.equals((CharSequence)userWebToken.getUserId(), (CharSequence)userId)) {
            if (log.isDebugEnabled()) {
                String message = String.format("A non admin user try to modify account details with shortId '%s'", userId);
                log.debug((Object)message);
            }
            throw new UnauthorizedException("Not allowed to modify user details");
        }
        String fullId = CoselmarUser.class.getCanonicalName() + this.getPersistenceContext().getTopiaIdFactory().getSeparator() + userId;
        CoselmarUser coselmarUser = (CoselmarUser)this.getCoselmarUserDao().forTopiaIdEquals(fullId).findAny();
        if (!isAdmin) {
            this.checkPassword(coselmarUser.getPassword(), coselmarUser.getSalt(), user.getPassword());
        }
        if (StringUtils.isNotBlank((CharSequence)(mail = user.getMail()))) {
            this.checkMailUnicity(mail, fullId);
            coselmarUser.setMail(mail);
        }
        if (StringUtils.isNotBlank((CharSequence)(firstName = user.getFirstName()))) {
            coselmarUser.setFirstname(firstName);
        } else {
            user.setFirstName(coselmarUser.getFirstname());
        }
        String userName = user.getName();
        if (StringUtils.isNotBlank((CharSequence)userName)) {
            coselmarUser.setName(userName);
        } else {
            user.setName(coselmarUser.getName());
        }
        String userRole = user.getRole();
        if (StringUtils.isNotBlank((CharSequence)userRole) && isAdmin) {
            coselmarUser.setRole(CoselmarUserRole.valueOf((String)userRole.toUpperCase()));
        }
        if (StringUtils.isNotBlank((CharSequence)(organization = user.getOrganization()))) {
            coselmarUser.setOrganization(organization);
        }
        if (StringUtils.isNotBlank((CharSequence)(qualification = user.getQualification()))) {
            coselmarUser.setQualification(qualification);
        }
        if (StringUtils.isNotBlank((CharSequence)(newPassword = user.getNewPassword()))) {
            String salt = this.getServicesContext().generateSalt();
            String encodedPassword = this.getServicesContext().encodePassword(salt, newPassword);
            coselmarUser.setSalt(salt);
            coselmarUser.setPassword(encodedPassword);
            if (isAdmin) {
                UserAccountCreatedMail userAccountCreatedMail = new UserAccountCreatedMail(this.getServicesContext().getLocale());
                userAccountCreatedMail.setUser(user);
                userAccountCreatedMail.setPassword(newPassword);
                userAccountCreatedMail.setTo(coselmarUser.getMail());
                this.sendMail(userAccountCreatedMail);
            }
        }
        this.commit();
    }

    public Render login(String mail, String password) throws InvalidCredentialException {
        Preconditions.checkNotNull((Object)mail);
        Preconditions.checkNotNull((Object)password);
        CoselmarUser user = (CoselmarUser)this.getCoselmarUserDao().forMailEquals(this.getCleanMail(mail)).addEquals("active", (Object)true).findAny();
        String salt = user.getSalt();
        this.checkPassword(user.getPassword(), salt, password);
        JWTSigner jwtSigner = new JWTSigner(this.getCoselmarServicesConfig().getWebSecurityKey());
        JWTSigner.Options signerOption = new JWTSigner.Options();
        signerOption.setAlgorithm(Algorithm.HS512);
        String userTopiaId = user.getTopiaId();
        String shortId = this.getPersistenceContext().getTopiaIdFactory().getRandomPart(userTopiaId);
        Map claims = UserWebToken.toJwtClaims((String)shortId, (String)user.getFirstname(), (String)user.getName(), (String)user.getRole().name());
        String webToken = jwtSigner.sign(claims, signerOption);
        return this.renderJSON(new Object[]{"jwt", webToken});
    }

    public void deleteUser(String userId) throws InvalidCredentialException, UnauthorizedException {
        String authorization = this.getContext().getHeader("Authorization");
        UserWebToken userWebToken = this.checkAuthentication(authorization);
        boolean isAdmin = StringUtils.equals((CharSequence)userWebToken.getRole(), (CharSequence)CoselmarUserRole.ADMIN.name());
        if (!isAdmin) {
            if (log.isDebugEnabled()) {
                String message = String.format("A non admin user try to delete account with shortId '%s'", userId);
                log.debug((Object)message);
            }
            throw new UnauthorizedException("Not allowed to delete user");
        }
        String fullId = CoselmarUser.class.getCanonicalName() + "_" + userId;
        CoselmarUser user = (CoselmarUser)this.getCoselmarUserDao().forTopiaIdEquals(fullId).findUnique();
        user.setActive(false);
        this.commit();
    }

    protected void checkMailUnicity(String mail, String userId) throws InvalidParameterException {
        boolean mailAlreadyUsed = StringUtils.isNotBlank((CharSequence)userId) ? this.getCoselmarUserDao().forMailEquals(mail).addNotEquals("topiaId", (Object)userId).exists() : this.getCoselmarUserDao().forMailEquals(mail).exists();
        if (mailAlreadyUsed) {
            String msg = String.format("mail '%s' is already used", mail);
            throw new InvalidParameterException(msg);
        }
    }

    protected void checkPassword(String currentPassword, String salt, String password) throws InvalidCredentialException {
        String encodedPassword = this.getServicesContext().encodePassword(salt, password);
        if (!encodedPassword.equals(currentPassword)) {
            throw new InvalidCredentialException("Invalid password given");
        }
    }

    protected void sendMail(UserAccountCreatedMail mail) {
        if (this.getCoselmarServicesConfig().isDevMode()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("an email should have been sent if not in devMode: to = " + mail.getTo() + ". subject = '" + mail.getSubject() + "'. body = \n" + this.getBody(mail)));
            }
            if (!mail.isRecipientProvided() && log.isWarnEnabled()) {
                log.warn((Object)("email has no recipient, would not have been sent " + mail));
            }
        } else {
            CoselmarServicesConfig applicationConfig = this.getCoselmarServicesConfig();
            String body = this.getBody(mail);
            if (mail.isRecipientProvided()) {
                SimpleEmail newEmail = new SimpleEmail();
                newEmail.setHostName(applicationConfig.getSmtpHost());
                newEmail.setSmtpPort(applicationConfig.getSmtpPort());
                newEmail.setCharset(Charsets.UTF_8.name());
                newEmail.setSubject(mail.getSubject());
                try {
                    newEmail.setFrom(applicationConfig.getSmtpFrom());
                    String to = mail.getTo();
                    newEmail.addTo(to);
                    newEmail.setMsg(body);
                    newEmail.send();
                }
                catch (EmailException e) {
                    throw new CoselmarTechnicalException((Throwable)e);
                }
            } else if (log.isErrorEnabled()) {
                log.error((Object)("email has no recipient, won't be sent " + mail));
            }
        }
    }

    protected String getBody(UserAccountCreatedMail mail) {
        Mustache mustache = this.getMustache(mail);
        StringWriter stringWriter = new StringWriter();
        mustache.execute((Writer)stringWriter, (Object)mail);
        return stringWriter.toString();
    }

    protected Mustache getMustache(UserAccountCreatedMail mail) {
        Mustache mustache;
        DefaultMustacheFactory mustacheFactory = new DefaultMustacheFactory("mail/");
        Locale locale = mail.getLocale();
        String templateName = mail.getClass().getSimpleName() + "_" + locale.getLanguage() + ".mustache";
        try {
            mustache = mustacheFactory.compile(templateName);
        }
        catch (MustacheException e) {
            templateName = mail.getClass().getSimpleName() + ".mustache";
            mustache = mustacheFactory.compile(templateName);
        }
        return mustache;
    }
}

