/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coselmar.services.v1;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import fr.ifremer.coselmar.beans.DocumentBean;
import fr.ifremer.coselmar.beans.QuestionBean;
import fr.ifremer.coselmar.beans.UserBean;
import fr.ifremer.coselmar.beans.UserWebToken;
import fr.ifremer.coselmar.converter.BeanEntityConverter;
import fr.ifremer.coselmar.persistence.entity.CoselmarUser;
import fr.ifremer.coselmar.persistence.entity.CoselmarUserGroup;
import fr.ifremer.coselmar.persistence.entity.CoselmarUserRole;
import fr.ifremer.coselmar.persistence.entity.Document;
import fr.ifremer.coselmar.persistence.entity.Privacy;
import fr.ifremer.coselmar.persistence.entity.Question;
import fr.ifremer.coselmar.persistence.entity.Status;
import fr.ifremer.coselmar.services.CoselmarWebServiceSupport;
import fr.ifremer.coselmar.services.errors.InvalidCredentialException;
import fr.ifremer.coselmar.services.errors.UnauthorizedException;
import fr.ifremer.coselmar.services.v1.QuestionsWebService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaIdFactory;
import org.nuiton.topia.persistence.TopiaNoResultException;

public class QuestionsWebService
extends CoselmarWebServiceSupport {
    private static final Log log = LogFactory.getLog(QuestionsWebService.class);
    protected static final List<String> RESTRICTED_ACCESS_USERS = Lists.newArrayList((Object[])new String[]{CoselmarUserRole.CLIENT.name(), CoselmarUserRole.MEMBER.name()});

    public void addQuestion(QuestionBean question) throws InvalidCredentialException, UnauthorizedException {
        Set relatedDocuments;
        Set parents;
        String privacy;
        CoselmarUser supervisor;
        String authorization = this.getContext().getHeader("Authorization");
        UserWebToken userWebToken = this.checkAuthentication(authorization);
        String userRole = userWebToken.getRole();
        if (!StringUtils.equalsIgnoreCase((CharSequence)CoselmarUserRole.SUPERVISOR.name(), (CharSequence)userRole)) {
            String message = String.format("User %s %s ('%s') is not allowed to add question", userWebToken.getFirstName(), userWebToken.getLastName(), userWebToken.getUserId());
            if (log.isWarnEnabled()) {
                log.warn((Object)message);
            }
            throw new UnauthorizedException(message);
        }
        String fullId = this.getFullUserIdFromShort(userWebToken.getUserId());
        try {
            supervisor = (CoselmarUser)this.getCoselmarUserDao().forTopiaIdEquals(fullId).findUnique();
        }
        catch (TopiaNoResultException tnre) {
            String message = String.format("Logged user ('%s') does not exist.", fullId);
            if (log.isErrorEnabled()) {
                log.error((Object)message);
            }
            throw new InvalidCredentialException(message);
        }
        Question questionEntity = (Question)this.getQuestionDao().create();
        questionEntity.setUnavailable(false);
        questionEntity.setTitle(question.getTitle());
        questionEntity.setSummary(question.getSummary());
        questionEntity.setType(question.getType());
        Set themes = question.getThemes();
        if (themes != null) {
            questionEntity.setTheme(new HashSet(themes));
        }
        Privacy realPrivacy = (privacy = question.getPrivacy()) != null ? Privacy.valueOf((String)privacy.toUpperCase()) : Privacy.PRIVATE;
        questionEntity.setPrivacy(realPrivacy);
        questionEntity.setStatus(Status.OPEN);
        Date submissionDate = question.getSubmissionDate();
        if (submissionDate != null) {
            questionEntity.setSubmissionDate(new Date(submissionDate.getTime()));
        } else {
            questionEntity.setSubmissionDate(new Date());
        }
        Date deadline = question.getDeadline();
        if (deadline != null) {
            questionEntity.setDeadline(new Date(deadline.getTime()));
        }
        questionEntity.addSupervisors(supervisor);
        questionEntity.addAllExternalExperts((Collection)question.getExternalExperts());
        Set clients = question.getClients();
        if (clients != null && !clients.isEmpty()) {
            Set clientEntities = this.retrieveUsers((Collection)clients);
            questionEntity.addAllClients(clientEntities);
        }
        Set participants = question.getParticipants();
        CoselmarUserGroup participantGroup = (CoselmarUserGroup)this.getCoselmarUserGroupDao().create();
        if (participants != null && !participants.isEmpty()) {
            participantGroup.setName(question.getTitle());
            Set expertEntities = this.retrieveUsers((Collection)participants);
            participantGroup.addAllMembers(expertEntities);
        }
        questionEntity.setParticipants(participantGroup);
        Set supervisors = question.getSupervisors();
        if (supervisors != null && !supervisors.isEmpty()) {
            Set supervisorEntities = this.retrieveUsers((Collection)supervisors);
            questionEntity.addAllSupervisors(supervisorEntities);
        }
        if ((parents = question.getParents()) != null && !parents.isEmpty()) {
            Set questions = this.retrieveQuestions((Collection)parents);
            questionEntity.addAllParents(questions);
        }
        if ((relatedDocuments = question.getRelatedDocuments()) != null && !relatedDocuments.isEmpty()) {
            Set documents = this.retrieveDocuments((Collection)relatedDocuments);
            for (Document document : documents) {
                if (document.getPrivacy() != Privacy.RESTRICTED) continue;
                document.addRestrictedList(participantGroup);
            }
            questionEntity.addAllRelatedDocuments(documents);
        }
        this.commit();
    }

    public List<QuestionBean> getQuestions() throws InvalidCredentialException, UnauthorizedException {
        List questionList;
        String authorization = this.getContext().getHeader("Authorization");
        UserWebToken userWebToken = this.checkAuthentication(authorization);
        String fullCurrentUserId = this.getFullUserIdFromShort(userWebToken.getUserId());
        CoselmarUser currentUser = (CoselmarUser)this.getCoselmarUserDao().forTopiaIdEquals(fullCurrentUserId).findAnyOrNull();
        String currentUserRole = userWebToken.getRole().toUpperCase();
        if (StringUtils.equalsIgnoreCase((CharSequence)CoselmarUserRole.ADMIN.name(), (CharSequence)currentUserRole) || StringUtils.equalsIgnoreCase((CharSequence)CoselmarUserRole.SUPERVISOR.name(), (CharSequence)currentUserRole)) {
            questionList = this.getQuestionDao().findAll();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)CoselmarUserRole.MEMBER.name(), (CharSequence)currentUserRole)) {
            questionList = this.getQuestionDao().forPrivacyEquals(Privacy.PUBLIC).findAll();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)CoselmarUserRole.EXPERT.name(), (CharSequence)currentUserRole)) {
            questionList = this.getQuestionDao().findForExpert(currentUser);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)CoselmarUserRole.CLIENT.name(), (CharSequence)currentUserRole)) {
            questionList = this.getQuestionDao().forClientsContains(currentUser).findAll();
        } else {
            String message = "Not allowed to access this page";
            if (log.isWarnEnabled()) {
                log.warn((Object)"Unknown user type try to access questions list.");
            }
            throw new UnauthorizedException(message);
        }
        ArrayList<QuestionBean> result = new ArrayList<QuestionBean>(questionList.size());
        for (Question question : questionList) {
            TopiaIdFactory topiaIdFactory = this.getPersistenceContext().getTopiaIdFactory();
            QuestionBean questionBean = RESTRICTED_ACCESS_USERS.contains(currentUserRole) ? BeanEntityConverter.toLightBean((TopiaIdFactory)topiaIdFactory, (Question)question) : BeanEntityConverter.toBean((TopiaIdFactory)topiaIdFactory, (Question)question);
            result.add(questionBean);
        }
        return result;
    }

    public void deleteQuestion(String questionId) throws InvalidCredentialException, UnauthorizedException {
        String authorization = this.getContext().getHeader("Authorization");
        UserWebToken userWebToken = this.checkAuthentication(authorization);
        String userRole = userWebToken.getRole();
        if (!StringUtils.equalsIgnoreCase((CharSequence)CoselmarUserRole.SUPERVISOR.name(), (CharSequence)userRole) && StringUtils.equalsIgnoreCase((CharSequence)CoselmarUserRole.ADMIN.name(), (CharSequence)userRole)) {
            String message = String.format("User %s %s ('%s') is not allowed to delete question", userWebToken.getFirstName(), userWebToken.getLastName(), userWebToken.getUserId());
            if (log.isWarnEnabled()) {
                log.warn((Object)message);
            }
            throw new UnauthorizedException(message);
        }
        String fullUserId = this.getFullIdFromShort(CoselmarUser.class, userWebToken.getUserId());
        try {
            this.getCoselmarUserDao().forTopiaIdEquals(fullUserId).findUnique();
        }
        catch (TopiaNoResultException tnre) {
            String message = String.format("Logged user ('%s') does not exist.", fullUserId);
            if (log.isErrorEnabled()) {
                log.error((Object)message);
            }
            throw new InvalidCredentialException(message);
        }
        String fullQuestionId = this.getFullIdFromShort(Question.class, questionId);
        Question question = (Question)this.getQuestionDao().forTopiaIdEquals(fullQuestionId).findUnique();
        CoselmarUserGroup participantGroup = question.getParticipants();
        List documents = this.getDocumentDao().forRestrictedListContains(participantGroup).findAll();
        for (Document document : documents) {
            document.removeRestrictedList(participantGroup);
        }
        question.addAllContributors(participantGroup.getMembers());
        question.setUnavailable(true);
        this.getPersistenceContext().getCoselmarUserGroupDao().delete(participantGroup);
        this.commit();
    }

    public QuestionBean getQuestion(String questionId) throws InvalidCredentialException, UnauthorizedException {
        CoselmarUserGroup participants;
        CoselmarUser currentUser;
        String authorization = this.getContext().getHeader("Authorization");
        UserWebToken userWebToken = this.checkAuthentication(authorization);
        String userRole = userWebToken.getRole();
        if (!StringUtils.equalsIgnoreCase((CharSequence)CoselmarUserRole.SUPERVISOR.name(), (CharSequence)userRole) && StringUtils.equalsIgnoreCase((CharSequence)CoselmarUserRole.ADMIN.name(), (CharSequence)userRole)) {
            String message = String.format("User %s %s ('%s') is not allowed to view question", userWebToken.getFirstName(), userWebToken.getLastName(), userWebToken.getUserId());
            if (log.isWarnEnabled()) {
                log.warn((Object)message);
            }
            throw new UnauthorizedException(message);
        }
        String fullUserId = this.getFullIdFromShort(CoselmarUser.class, userWebToken.getUserId());
        try {
            currentUser = (CoselmarUser)this.getCoselmarUserDao().forTopiaIdEquals(fullUserId).findUnique();
        }
        catch (TopiaNoResultException tnre) {
            String message = String.format("Logged user ('%s') does not exist.", fullUserId);
            if (log.isErrorEnabled()) {
                log.error((Object)message);
            }
            throw new InvalidCredentialException(message);
        }
        String fullQuestionId = this.getFullIdFromShort(Question.class, questionId);
        Question question = (Question)this.getQuestionDao().forTopiaIdEquals(fullQuestionId).findUnique();
        this.checkIsClient(question, currentUser);
        QuestionBean result = BeanEntityConverter.toBean((TopiaIdFactory)this.getPersistenceContext().getTopiaIdFactory(), (Question)question);
        if (CoselmarUserRole.CLIENT == currentUser.getRole()) {
            result.setRelatedDocuments(null);
        } else if (!(CoselmarUserRole.EXPERT != currentUser.getRole() || question.getPrivacy() != Privacy.PRIVATE || (participants = question.getParticipants()) != null && participants.getMembers().contains(currentUser))) {
            result = new QuestionBean();
            result.setTitle(question.getTitle());
            result.setPrivacy(question.getPrivacy().name());
            result.setRestricted(true);
            for (Question parent : question.getParents()) {
                result.addParent(BeanEntityConverter.toLightBean((TopiaIdFactory)this.getPersistenceContext().getTopiaIdFactory(), (Question)parent));
            }
        }
        return result;
    }

    public void addDocuments(String questionId, DocumentBean[] documents) throws InvalidCredentialException, UnauthorizedException {
        CoselmarUser currentUser;
        String authorization = this.getContext().getHeader("Authorization");
        UserWebToken userWebToken = this.checkAuthentication(authorization);
        String userRole = userWebToken.getRole();
        if (!(StringUtils.equalsIgnoreCase((CharSequence)CoselmarUserRole.SUPERVISOR.name(), (CharSequence)userRole) || StringUtils.equalsIgnoreCase((CharSequence)CoselmarUserRole.ADMIN.name(), (CharSequence)userRole) || StringUtils.equalsIgnoreCase((CharSequence)CoselmarUserRole.EXPERT.name(), (CharSequence)userRole))) {
            String message = String.format("User %s %s ('%s') is not allowed to add document", userWebToken.getFirstName(), userWebToken.getLastName(), userWebToken.getUserId());
            if (log.isWarnEnabled()) {
                log.warn((Object)message);
            }
            throw new UnauthorizedException(message);
        }
        String fullUserId = this.getFullIdFromShort(CoselmarUser.class, userWebToken.getUserId());
        try {
            currentUser = (CoselmarUser)this.getCoselmarUserDao().forTopiaIdEquals(fullUserId).findUnique();
        }
        catch (TopiaNoResultException tnre) {
            String message = String.format("Logged user ('%s') does not exist.", fullUserId);
            if (log.isErrorEnabled()) {
                log.error((Object)message);
            }
            throw new InvalidCredentialException(message);
        }
        String fullQuestionId = this.getFullIdFromShort(Question.class, questionId);
        Question question = (Question)this.getQuestionDao().forTopiaIdEquals(fullQuestionId).findUnique();
        this.checkIsParticipant(question, currentUser);
        Set questionDocuments = question.getRelatedDocuments();
        if (documents != null && documents.length > 0) {
            if (question.getStatus() == Status.OPEN) {
                question.setStatus(Status.IN_PROGRESS);
            }
            Set documentEntities = this.retrieveDocuments((Collection)Lists.newArrayList((Object[])documents));
            for (Document document : documentEntities) {
                if (document.getPrivacy() == Privacy.RESTRICTED) {
                    document.addRestrictedList(question.getParticipants());
                }
                if (questionDocuments.contains(document)) continue;
                question.addRelatedDocuments(document);
            }
        }
        this.commit();
    }

    public void saveQuestion(QuestionBean question) throws InvalidCredentialException, UnauthorizedException {
        Set parents;
        Set expertEntities;
        CoselmarUserGroup participantGroup;
        String privacy;
        Question questionEntity;
        CoselmarUser supervisor;
        String authorization = this.getContext().getHeader("Authorization");
        UserWebToken userWebToken = this.checkAuthentication(authorization);
        String userRole = userWebToken.getRole();
        if (!StringUtils.equalsIgnoreCase((CharSequence)CoselmarUserRole.SUPERVISOR.name(), (CharSequence)userRole)) {
            String message = String.format("User %s %s ('%s') is not allowed to save question", userWebToken.getFirstName(), userWebToken.getLastName(), userWebToken.getUserId());
            if (log.isWarnEnabled()) {
                log.warn((Object)message);
            }
            throw new UnauthorizedException(message);
        }
        String fullUserId = this.getFullUserIdFromShort(userWebToken.getUserId());
        try {
            supervisor = (CoselmarUser)this.getCoselmarUserDao().forTopiaIdEquals(fullUserId).findUnique();
        }
        catch (TopiaNoResultException tnre) {
            String message = String.format("Logged user ('%s') does not exist.", fullUserId);
            if (log.isErrorEnabled()) {
                log.error((Object)message);
            }
            throw new InvalidCredentialException(message);
        }
        String questionId = question.getId();
        boolean inEdition = StringUtils.isNotBlank((CharSequence)questionId);
        if (inEdition) {
            String fullQuestionId = this.getFullIdFromShort(Question.class, questionId);
            questionEntity = (Question)this.getQuestionDao().forTopiaIdEquals(fullQuestionId).findUnique();
        } else {
            questionEntity = (Question)this.getQuestionDao().create();
        }
        questionEntity.setTitle(question.getTitle());
        questionEntity.setSummary(question.getSummary());
        questionEntity.setType(question.getType());
        Set themes = question.getThemes();
        if (themes != null) {
            questionEntity.setTheme(new HashSet(themes));
        }
        Privacy realPrivacy = (privacy = question.getPrivacy()) != null ? Privacy.valueOf((String)privacy.toUpperCase()) : Privacy.PRIVATE;
        questionEntity.setPrivacy(realPrivacy);
        if (inEdition) {
            String status = question.getStatus();
            questionEntity.setStatus(status != null ? Status.valueOf((String)status.toUpperCase()) : Status.OPEN);
            if (Lists.newArrayList((Object[])new String[]{Status.CLOSED.name(), Status.ADJOURNED.name()}).contains(status) && questionEntity.getClosingDate() == null) {
                questionEntity.setClosingDate(new Date());
            } else if (questionEntity.getClosingDate() != null && !Lists.newArrayList((Object[])new String[]{Status.CLOSED.name(), Status.ADJOURNED.name()}).contains(status)) {
                questionEntity.setClosingDate(null);
            }
        } else {
            questionEntity.setStatus(Status.OPEN);
        }
        Date submissionDate = question.getSubmissionDate();
        if (submissionDate != null) {
            questionEntity.setSubmissionDate(new Date(submissionDate.getTime()));
        } else {
            questionEntity.setSubmissionDate(new Date());
        }
        Date deadline = question.getDeadline();
        if (deadline != null) {
            questionEntity.setDeadline(new Date(deadline.getTime()));
        }
        questionEntity.addSupervisors(supervisor);
        questionEntity.addAllExternalExperts((Collection)question.getExternalExperts());
        Set clients = question.getClients();
        questionEntity.clearClients();
        if (clients != null && !clients.isEmpty()) {
            Set clientEntities = this.retrieveUsers((Collection)clients);
            questionEntity.addAllClients(clientEntities);
        }
        Set participants = question.getParticipants();
        if (inEdition) {
            participantGroup = questionEntity.getParticipants();
            if (participants != null && !participants.isEmpty()) {
                expertEntities = this.retrieveUsers((Collection)participants);
                for (CoselmarUser participantBefore : participantGroup.getMembers()) {
                    if (expertEntities.contains(participantBefore)) continue;
                    questionEntity.addContributors(participantBefore);
                }
                participantGroup.clearMembers();
                participantGroup.addAllMembers(expertEntities);
            } else {
                participantGroup.clearMembers();
            }
        } else {
            participantGroup = (CoselmarUserGroup)this.getCoselmarUserGroupDao().create();
            participantGroup.setName(question.getTitle());
            if (participants != null && !participants.isEmpty()) {
                expertEntities = this.retrieveUsers((Collection)participants);
                participantGroup.addAllMembers(expertEntities);
            }
        }
        questionEntity.setParticipants(participantGroup);
        Set supervisors = question.getSupervisors();
        questionEntity.clearSupervisors();
        if (supervisors != null && !supervisors.isEmpty()) {
            Set supervisorEntities = this.retrieveUsers((Collection)supervisors);
            questionEntity.addAllSupervisors(supervisorEntities);
        }
        if ((parents = question.getParents()) != null && !parents.isEmpty()) {
            Set questions = this.retrieveQuestions((Collection)parents);
            questionEntity.addAllParents(questions);
        } else if (inEdition) {
            questionEntity.clearParents();
        }
        Set relatedDocuments = question.getRelatedDocuments();
        if (relatedDocuments != null && !relatedDocuments.isEmpty()) {
            Set documents = this.retrieveDocuments((Collection)relatedDocuments);
            for (Document document : documents) {
                if (document.getPrivacy() != Privacy.RESTRICTED) continue;
                document.addRestrictedList(participantGroup);
            }
            questionEntity.clearRelatedDocuments();
            questionEntity.addAllRelatedDocuments(documents);
        } else if (inEdition) {
            questionEntity.clearRelatedDocuments();
        }
        questionEntity.setConclusion(question.getConclusion());
        Set closingDocuments = question.getClosingDocuments();
        if (closingDocuments != null && !closingDocuments.isEmpty()) {
            Set documents = this.retrieveDocuments((Collection)closingDocuments);
            for (Document document : documents) {
                if (document.getPrivacy() != Privacy.RESTRICTED) continue;
                document.addRestrictedList(participantGroup);
            }
            questionEntity.clearClosingDocuments();
            questionEntity.addAllClosingDocuments(documents);
        } else if (inEdition) {
            questionEntity.clearClosingDocuments();
        }
        this.commit();
    }

    public List<String> getThemes() throws InvalidCredentialException, UnauthorizedException {
        List themes = this.getQuestionDao().findAllThemes();
        return themes;
    }

    public List<String> getTypes() throws InvalidCredentialException, UnauthorizedException {
        List types = this.getQuestionDao().findAllTypes();
        return types;
    }

    protected void checkIsParticipant(Question question, CoselmarUser currentUser) throws UnauthorizedException {
        String userRole = currentUser.getRole().name();
        Set questionsParticipants = question.getParticipants().getMembers();
        if (StringUtils.equalsIgnoreCase((CharSequence)CoselmarUserRole.EXPERT.name(), (CharSequence)userRole) && !questionsParticipants.contains(currentUser)) {
            String message = String.format("Expert %s %s ('%s') is not allowed to add document", currentUser.getFirstname(), currentUser.getName(), currentUser.getTopiaId());
            if (log.isWarnEnabled()) {
                log.warn((Object)message);
            }
            throw new UnauthorizedException(message);
        }
    }

    protected void checkIsClient(Question question, CoselmarUser currentUser) throws UnauthorizedException {
        String userRole = currentUser.getRole().name();
        Set questionsClients = question.getClients();
        if (StringUtils.equalsIgnoreCase((CharSequence)CoselmarUserRole.CLIENT.name(), (CharSequence)userRole) && !questionsClients.contains(currentUser)) {
            String message = String.format("Client %s %s ('%s') is not allowed to access question %s", currentUser.getFirstname(), currentUser.getName(), currentUser.getTopiaId(), question.getTopiaId());
            if (log.isWarnEnabled()) {
                log.warn((Object)message);
            }
            throw new UnauthorizedException(message);
        }
    }

    protected Set<CoselmarUser> retrieveUsers(Collection<UserBean> userBeans) {
        1 getIds = new /* Unavailable Anonymous Inner Class!! */;
        Collection userIds = Collections2.transform(userBeans, (Function)getIds);
        List coselmarUsers = this.getCoselmarUserDao().forTopiaIdIn(userIds).findAll();
        return new HashSet<CoselmarUser>(coselmarUsers);
    }

    protected Set<Question> retrieveQuestions(Collection<QuestionBean> questionBeans) {
        2 getIds = new /* Unavailable Anonymous Inner Class!! */;
        Collection questionIds = Collections2.transform(questionBeans, (Function)getIds);
        List questions = this.getQuestionDao().forTopiaIdIn(questionIds).findAll();
        return new HashSet<Question>(questions);
    }

    protected Set<Document> retrieveDocuments(Collection<DocumentBean> documentBeans) {
        3 getIds = new /* Unavailable Anonymous Inner Class!! */;
        Collection documentIds = Collections2.transform(documentBeans, (Function)getIds);
        List documents = this.getDocumentDao().forTopiaIdIn(documentIds).findAll();
        return new HashSet<Document>(documents);
    }

    static /* synthetic */ String access$000(QuestionsWebService x0, Class x1, String x2) {
        return x0.getFullIdFromShort(x1, x2);
    }

    static /* synthetic */ String access$100(QuestionsWebService x0, Class x1, String x2) {
        return x0.getFullIdFromShort(x1, x2);
    }

    static /* synthetic */ String access$200(QuestionsWebService x0, Class x1, String x2) {
        return x0.getFullIdFromShort(x1, x2);
    }
}

