/*
 * #%L
 * Coselmar :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Ifremer, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
var coselmarControllers = angular.module('coselmarControllers', []);

// Controller when the main page/view loads
coselmarControllers.controller("HomeCtrl", ['$scope', function($scope){ }]);

// Controller for All Documents View
coselmarControllers.controller("DocumentsCtrl", ['$scope', '$route', '$routeParams', '$location', 'documentService', function($scope, $route, $routeParams, $location, documentService){

	//manage keywords if given
	$scope.searchKeywords = [];
	var keywords = $routeParams.keywords;
	if (Array.isArray(keywords)) {
		$scope.searchKeywords = keywords;
	} else if (keywords) {
		$scope.searchKeywords.push(keywords);
	}

	documentService.getDocuments($scope);

	$scope.deleteDocument = function(documentId){

		// Call service to create a new document
		documentService.deleteDocument(documentId, $scope, function() {
			// Go back to documents list
			$route.reload();
		});
	};

	$scope.searchDocuments = function(){
//		$route.current.params.keywords = $scope.searchKeywords;
//		$route.reload();
		$location.search('keywords', $scope.searchKeywords);
	}
}]);


// Controller for new document View
coselmarControllers.controller("NewDocumentCtrl", ['$scope', '$route', 'documentService', function($scope, $route, documentService){

	$scope.createNewDocument = function(){
		var documentMetadata = {'privacy':$scope.privacy, 'keywords':$scope.keywords};

		// Call service to create a new document
		documentService.createDocument(documentMetadata, $scope.documentFile, $scope);

		// Reload the page
		$route.reload();
	};
}]);

// Controller for single document View
coselmarControllers.controller("DocumentViewCtrl",
 	['$scope', '$route', '$location', 'documentService', '$routeParams', function($scope, $route, $location, documentService, $routeParams) {

	documentService.getDocument($routeParams.documentId, $scope);

	$scope.deleteDocument = function(documentId){

		// Call service to create a new document
		var toto = documentService.deleteDocument(documentId, $scope, function() {
				// Go back to documents list
				$location.path("/documents");
			});

	};
} ]);

// Controller for document file download
coselmarControllers.controller("DocumentFileDlCtrl", [ '$scope','documentService', '$routeParams', function($scope, documentService, $routeParams) {
	documentService.getDocumentFile($routeParams.documentId, $scope);
} ]);

coselmarControllers.directive('ngFileModel', ['$parse', function ($parse) {
    return {
        restrict: 'A',
        link: function(scope, element, attrs) {
            var model = $parse(attrs.ngFileModel);
            var modelSetter = model.assign;

            element.bind('change', function(){
                scope.$apply(function(){
                    modelSetter(scope, element[0].files[0]);
                });
            });
        }
    };
}]);