/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.search;

import com.jurismarches.vradi.services.search.CompareFilter;
import com.jurismarches.vradi.services.search.Filter;
import com.jurismarches.vradi.services.search.FilterList;
import com.jurismarches.vradi.services.search.QueryHandler;
import java.util.List;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.RangeQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;

public class FilterListQueryHandler
implements QueryHandler {
    private static final Log log = LogFactory.getLog(FilterListQueryHandler.class);
    private final Stack<FilterList> filterListStack = new Stack();

    public FilterListQueryHandler() {
        FilterList filterList = new FilterList();
        this.filterListStack.push(filterList);
    }

    @Override
    public void prefixQuery(PrefixQuery query, BooleanClause booleanClause) {
        Term term = query.getPrefix();
        this.filter(term.field(), term.text() + "*", booleanClause);
    }

    @Override
    public void termQuery(TermQuery query, BooleanClause booleanClause) {
        Term term = query.getTerm();
        this.filter(term.field(), term.text(), booleanClause);
    }

    @Override
    public void rangeQuery(RangeQuery query, BooleanClause booleanClause) {
        String field = query.getField();
        Term lowerTerm = query.getLowerTerm();
        Term upperTerm = query.getUpperTerm();
    }

    @Override
    public void wildcardQuery(WildcardQuery query, BooleanClause booleanClause) {
        Term term = query.getTerm();
        this.filter(term.field(), term.text(), booleanClause);
    }

    @Override
    public void group(BooleanClause booleanClause) {
        if (booleanClause == null) {
            return;
        }
        FilterList.Operator operator = FilterList.Operator.getOperator(booleanClause);
        FilterList filterList = new FilterList(operator);
        if (log.isTraceEnabled()) {
            log.trace((Object)("group: " + operator.toString()));
        }
        FilterList peek = this.filterListStack.peek();
        peek.addFilter(filterList);
        this.filterListStack.push(filterList);
    }

    @Override
    public void ungroup() {
        if (this.filterListStack.size() > 1) {
            this.filterListStack.pop();
        }
    }

    private void filter(String term, String text, BooleanClause booleanClause) {
        CompareFilter filter = new CompareFilter(term, text);
        FilterList peek = this.filterListStack.peek();
        FilterList.Operator operator = FilterList.Operator.getOperator(booleanClause);
        if (operator == FilterList.Operator.MUST_NOT_PASS && peek.getOperator() != operator) {
            this.group(booleanClause);
            peek = this.filterListStack.peek();
            peek.addFilter(filter);
            this.ungroup();
        } else {
            peek.addFilter(filter);
        }
    }

    public FilterList getFilterList() {
        FilterList list = (FilterList)this.filterListStack.get(0);
        if (log.isDebugEnabled()) {
            FilterListQueryHandler.traceFilterList(list, "");
        }
        return list;
    }

    static void traceFilterList(FilterList list, String spaces) {
        if (log.isDebugEnabled()) {
            FilterList.Operator operator = list.getOperator();
            log.debug((Object)String.format("%s%s [", spaces, operator.toString()));
            spaces = spaces + "  ";
            List<Filter> filters = list.getFilters();
            for (Filter filter : filters) {
                if (filter instanceof FilterList) {
                    FilterListQueryHandler.traceFilterList((FilterList)filter, spaces);
                    continue;
                }
                log.debug((Object)String.format("%s%s", spaces, filter.toString()));
            }
            spaces = spaces.substring(0, spaces.length() - 2);
            log.debug((Object)(spaces + "]"));
        }
    }
}

