/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.managers;

import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.managers.BindingManager;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.Criteria;
import org.sharengo.wikitty.PagedResult;
import org.sharengo.wikitty.WikittyProxy;
import org.sharengo.wikitty.search.Element;
import org.sharengo.wikitty.search.Search;

public class ClientManager {
    private static final Log log = LogFactory.getLog(BindingManager.class);
    private final WikittyProxy proxy;

    public ClientManager(WikittyProxy proxy) {
        this.proxy = proxy;
    }

    public ClientManager() {
        this.proxy = ServiceHelper.getWikittyProxy();
    }

    public User getUser(String userId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getUser(" + userId + ")"));
        }
        User user = (User)this.proxy.restore(User.class, userId);
        return user;
    }

    public Client getClient(String clientId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getClient(" + clientId + ")"));
        }
        Client client = (Client)this.proxy.restore(Client.class, clientId);
        return client;
    }

    public Group getGroup(String groupId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getGroup(" + groupId + ")"));
        }
        Group group = (Group)this.proxy.restore(Group.class, groupId);
        return group;
    }

    public List<User> getGroupUsers(String groupId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getGroupUsers(" + groupId + ")"));
        }
        ArrayList<User> users = new ArrayList<User>();
        Group group = this.getGroup(groupId);
        if (group != null && group.getUser() != null) {
            ArrayList userIds = new ArrayList(group.getUser());
            List restore = this.proxy.restore(User.class, userIds);
            users.addAll(restore);
        }
        return users;
    }

    public List<User> getClientUsers(String clientId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getClientUsers(" + clientId + ")"));
        }
        ArrayList<User> users = new ArrayList<User>();
        Client client = this.getClient(clientId);
        if (client != null && client.getUser() != null) {
            ArrayList userIds = new ArrayList(client.getUser());
            List restore = this.proxy.restore(User.class, userIds);
            users.addAll(restore);
        }
        return users;
    }

    public List<Client> getGroupClients(String groupId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getGroupClients(" + groupId + ")"));
        }
        ArrayList<Client> clients = new ArrayList<Client>();
        Group group = this.getGroup(groupId);
        if (group != null && group.getClient() != null) {
            ArrayList clientIds = new ArrayList(group.getClient());
            List restore = this.proxy.restore(Client.class, clientIds);
            clients.addAll(restore);
        }
        return clients;
    }

    public Client getClientByUserId(String userId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getClientByUserId(" + userId + ")"));
        }
        User user = this.getUser(userId);
        String clientId = user.getClient();
        return this.getClient(clientId);
    }

    public List<Group> getGroupsByUserId(String userId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getGroupsByUserId(" + userId + ")"));
        }
        ArrayList<Group> groups = new ArrayList<Group>();
        User user = this.getUser(userId);
        if (user != null && user.getGroup() != null) {
            ArrayList groupIds = new ArrayList(user.getGroup());
            List restore = this.proxy.restore(Group.class, groupIds);
            groups.addAll(restore);
        }
        return groups;
    }

    public List<Group> getGroupsByClientId(String clientId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getGroupsByClientId(" + clientId + ")"));
        }
        ArrayList<Group> groups = new ArrayList<Group>();
        Client client = this.getClient(clientId);
        if (client != null && client.getGroup() != null) {
            ArrayList groupIds = new ArrayList(client.getGroup());
            List restore = this.proxy.restore(Group.class, groupIds);
            groups.addAll(restore);
        }
        return groups;
    }

    public List<Client> getAllClients() throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllClients()");
        }
        Search search = Search.query().eq(Element.ELT_EXTENSION, "Client");
        Criteria criteria = search.criteria();
        PagedResult clients = this.proxy.findAllByCriteria(Client.class, criteria);
        List all = clients.getAll();
        return new ArrayList<Client>(all);
    }

    public List<User> getAllUsers() throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllUsers()");
        }
        Search search = Search.query().eq(Element.ELT_EXTENSION, "User");
        Criteria criteria = search.criteria();
        PagedResult users = this.proxy.findAllByCriteria(User.class, criteria);
        List all = users.getAll();
        return new ArrayList<User>(all);
    }

    public List<Group> getAllGroups() throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllGroups()");
        }
        Search search = Search.query().eq(Element.ELT_EXTENSION, "Group");
        Criteria criteria = search.criteria();
        PagedResult groups = this.proxy.findAllByCriteria(Group.class, criteria);
        List all = groups.getAll();
        return new ArrayList<Group>(all);
    }
}

