/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.managers;

import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.FormImpl;
import com.jurismarches.vradi.entities.InfogeneImpl;
import com.jurismarches.vradi.entities.VradiUser;
import com.jurismarches.vradi.entities.XmlFieldBinding;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.managers.FormManager;
import com.jurismarches.vradi.services.managers.FormTypeManager;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.nuiton.util.MD5;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.Criteria;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.PagedResult;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyProxy;
import org.sharengo.wikitty.WikittyUtil;
import org.sharengo.wikitty.search.Search;

public class BindingManager {
    private static final Log log = LogFactory.getLog(BindingManager.class);
    private final WikittyProxy proxy;
    private final FormTypeManager formTypeManager;
    private final FormManager formManager;
    public static final String CHANNEL = "channel";
    public static final String ENTRY = "entry";
    public static final String FEED = "feed";
    public static final String ITEM = "item";
    public static final String RDF = "rdf";
    public static final SimpleDateFormat RSS_DATE_FORMAT = new SimpleDateFormat("E, d MMM yyyy HH:mm:ss Z", Locale.US);

    public BindingManager(WikittyProxy proxy, FormTypeManager formTypeManager, FormManager formManager) {
        this.proxy = proxy;
        this.formTypeManager = formTypeManager;
        this.formManager = formManager;
    }

    public BindingManager(FormTypeManager formTypeManager, FormManager formManager) {
        this.proxy = ServiceHelper.getWikittyProxy();
        this.formTypeManager = formTypeManager;
        this.formManager = formManager;
    }

    public List<XmlFieldBinding> getXmlFieldBindings(XmlStream xmlStream) {
        ArrayList<XmlFieldBinding> list = new ArrayList<XmlFieldBinding>();
        if (xmlStream != null && xmlStream.getXmlFieldBinding() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getXmlFieldBindings(" + xmlStream.getName() + ")"));
                log.debug((Object)xmlStream.getXmlFieldBinding());
            }
            ArrayList bindings = new ArrayList();
            bindings.addAll(xmlStream.getXmlFieldBinding());
            List restore = this.proxy.restore(XmlFieldBinding.class, bindings);
            list.addAll(restore);
        }
        return list;
    }

    public XmlFieldBinding getXmlFieldBinding(String xmlFieldBindingId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getXmlFieldBinding(" + xmlFieldBindingId + ")"));
        }
        XmlFieldBinding xmlFieldBinding = (XmlFieldBinding)this.proxy.restore(XmlFieldBinding.class, xmlFieldBindingId);
        return xmlFieldBinding;
    }

    public List<XmlFieldBinding> updateXmlFieldBindings(List<XmlFieldBinding> bindings) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateXmlFieldBindings(bindings)");
        }
        ArrayList<XmlFieldBinding> list = new ArrayList<XmlFieldBinding>();
        if (bindings != null) {
            bindings = this.proxy.store(bindings);
            list.addAll(bindings);
        }
        return list;
    }

    public List<XmlStream> getAllXmlStreams() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllXmlStreams()");
        }
        Criteria criteria = Search.query().eq(org.sharengo.wikitty.search.Element.ELT_EXTENSION, "XmlStream").criteria();
        PagedResult xmlStreams = this.proxy.findAllByCriteria(XmlStream.class, criteria);
        List all = xmlStreams.getAll();
        ArrayList<XmlStream> list = new ArrayList<XmlStream>();
        list.addAll(all);
        return list;
    }

    public XmlStream getXmlStream(String xmlStreamId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getXmlStream(" + xmlStreamId + ")"));
        }
        XmlStream xmlStream = (XmlStream)this.proxy.restore(XmlStream.class, xmlStreamId);
        return xmlStream;
    }

    public Object[] getFormsFromXmlStream(XmlStream xmlStream, String lastItemRecorded, VradiUser vradiUser) throws TechnicalException {
        Object[] results = new Object[4];
        if (log.isDebugEnabled()) {
            log.debug((Object)("getFormsFromXmlStream(" + xmlStream.getName() + ", " + lastItemRecorded + ", " + vradiUser + ")"));
        }
        HashMap<String, Set> streamBinding = new HashMap<String, Set>();
        ArrayList<Form> forms = new ArrayList<Form>();
        WikittyExtension formType = this.formTypeManager.getFormType(xmlStream.getFormTypeName());
        List bindings = this.proxy.restore(XmlFieldBinding.class, new ArrayList(xmlStream.getXmlFieldBinding()));
        for (XmlFieldBinding binding : bindings) {
            String formTypeName;
            String formField = binding.getFormField();
            Set xmlField = binding.getXmlField();
            streamBinding.put(formField, xmlField);
            if (formType != null || "Form".equals(formTypeName = formField.substring(0, formField.indexOf(46))) || "Infogene".equals(formTypeName)) continue;
            formType = this.formTypeManager.getFormType(formTypeName);
        }
        if (formType == null) {
            return null;
        }
        String result = null;
        Document document = null;
        try {
            SAXBuilder sxb = new SAXBuilder();
            URL rssUrl = new URL(xmlStream.getUrl());
            document = sxb.build(rssUrl);
        }
        catch (Exception e) {
            throw new TechnicalException((Throwable)e);
        }
        Element racine = document.getRootElement();
        List itemElt = null;
        if (racine.getChild(CHANNEL) != null) {
            itemElt = racine.getChild(CHANNEL).getChildren(ITEM);
        } else if (racine.getChild(ITEM) != null) {
            itemElt = racine.getChildren(ITEM);
        } else if (racine.getChild(ENTRY) != null) {
            itemElt = racine.getChildren(ENTRY);
        }
        if (itemElt == null) {
            return null;
        }
        int nbCreated = 0;
        int dateParsingError = 0;
        int numberParsingError = 0;
        for (Element element : itemElt) {
            StringBuffer sb = new StringBuffer();
            List fields = element.getChildren();
            for (Element field : fields) {
                sb.append(field.getText());
            }
            MD5 lastItem = new MD5((Object)sb.toString());
            if (result == null) {
                result = MD5.asHex((byte[])lastItem.Final());
            }
            if (lastItemRecorded != null && lastItemRecorded.equals(MD5.asHex((byte[])lastItem.Final()))) break;
            FormImpl form = new FormImpl();
            form.addExtension(formType);
            block13: for (String field : streamBinding.keySet()) {
                int dot = field.indexOf(46);
                String extName = field.substring(0, dot);
                String fieldName = field.substring(dot + 1);
                FieldType fieldType = null;
                if (extName.equals("Form")) {
                    fieldType = FormImpl.extensionForm.getFieldType(fieldName);
                } else if (extName.equals("Infogene")) {
                    fieldType = InfogeneImpl.extensionInfogene.getFieldType(fieldName);
                } else if (formType != null) {
                    fieldType = formType.getFieldType(fieldName);
                }
                if (fieldType == null || streamBinding.get(field) == null) continue;
                switch (fieldType.getType()) {
                    case DATE: {
                        Object value;
                        Element child;
                        for (String xmlField : (Set)streamBinding.get(field)) {
                            child = element.getChild(xmlField);
                            if (child == null) continue;
                            try {
                                value = RSS_DATE_FORMAT.parse(child.getText());
                                form.setField(extName, fieldName, (Object)WikittyUtil.solrDateFormat.format((Date)value));
                            }
                            catch (ParseException eee) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Date parsing error : " + child.getText()));
                                }
                                ++dateParsingError;
                            }
                        }
                        continue block13;
                    }
                    case NUMERIC: {
                        Object value;
                        Element child;
                        for (String xmlField : (Set)streamBinding.get(field)) {
                            if (element.getChild(xmlField) == null || (child = element.getChild(xmlField)) == null) continue;
                            try {
                                value = Double.valueOf(child.getText());
                                form.setField(extName, fieldName, value);
                            }
                            catch (NumberFormatException eee) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Number parsing error : " + child.getText()));
                                }
                                ++numberParsingError;
                            }
                        }
                        continue block13;
                    }
                    default: {
                        Object value;
                        Element child;
                        for (String xmlField : (Set)streamBinding.get(field)) {
                            if (element.getChild(xmlField) == null || (child = element.getChild(xmlField)) == null) continue;
                            value = child.getText();
                            Object fieldValue = form.getField(extName, fieldName);
                            Object newValue = null;
                            newValue = fieldValue != null ? fieldValue + "\n" + (String)value : value;
                            form.setField(extName, fieldName, newValue);
                        }
                        continue block13;
                    }
                }
            }
            form.setId(FormManager.FORM_ID_DATE_FORMAT.format(new Date()) + form.getWikittyId());
            form.setStatus(this.formManager.getToTreatStatus().getWikittyId());
            forms.add((Form)form);
            ++nbCreated;
        }
        this.formManager.updateForms(forms);
        results[0] = result;
        results[1] = nbCreated;
        results[2] = dateParsingError;
        results[3] = numberParsingError;
        return results;
    }
}

