/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.migration;

import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.managers.FormTypeManager;
import com.jurismarches.vradi.services.search.VradiQueryParser;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.Resource;
import org.sharengo.wikitty.AbstractWikittyService;
import org.sharengo.wikitty.Criteria;
import org.sharengo.wikitty.PagedResult;
import org.sharengo.wikitty.TreeNode;
import org.sharengo.wikitty.WikittyException;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyExtensionStorage;
import org.sharengo.wikitty.WikittyProxy;
import org.sharengo.wikitty.WikittySearchEngine;
import org.sharengo.wikitty.WikittyService;
import org.sharengo.wikitty.WikittyStorage;
import org.sharengo.wikitty.jdbc.WikittyExtensionStorageJDBC;
import org.sharengo.wikitty.jdbc.WikittyStorageJDBC;
import org.sharengo.wikitty.search.Element;
import org.sharengo.wikitty.search.Search;
import org.sharengo.wikitty.solr.WikittySearchEngineSolr;

public class Migration004 {
    private static final Log log = LogFactory.getLog(Migration004.class);
    static final String vradi003 = System.getProperty("user.home") + File.separator + ".vradi/vradi-0.0.3";
    static final String vradi004 = System.getProperty("user.home") + File.separator + ".vradi/vradi-0.0.4";

    public static void performMigration() {
        Search search;
        Criteria criteria;
        File dataDir = new File(vradi003);
        if (!dataDir.exists()) {
            return;
        }
        String[] list = dataDir.list();
        if (list.length == 0) {
            return;
        }
        WikittyProxy proxy = ServiceHelper.getWikittyProxy();
        TreeNode rootThesaurus = (TreeNode)proxy.findByCriteria(TreeNode.class, criteria = (search = Search.query().eq(Element.ELT_EXTENSION, "TreeNode").eq("TreeNode.name", "Thesaurus")).criteria());
        if (rootThesaurus != null) {
            return;
        }
        try {
            log.info((Object)"begin of datas migration from 0.0.3 to 0.0.4");
            WikittyServiceJDBC_003 service = new WikittyServiceJDBC_003(vradi003);
            File exportFile = Migration004.exportObjects_003(service);
            List<WikittyExtension> formTypes = Migration004.exportFormTypes_003(service);
            service = null;
            Migration004.importObjects_004(exportFile, proxy);
            Migration004.importFormTypes_004(formTypes, proxy);
            log.info((Object)"end of datas migration !");
        }
        catch (Exception e) {
            try {
                FileUtils.deleteDirectory((File)new File(vradi004));
            }
            catch (IOException e1) {
                // empty catch block
            }
            throw new UnhandledException("datas migration failed: ", (Throwable)e);
        }
    }

    static List<WikittyExtension> exportFormTypes_003(WikittyServiceJDBC_003 service) {
        log.info((Object)"export FormType from 0.0.3");
        WikittyProxy proxy = new WikittyProxy();
        proxy.setWikittyService((WikittyService)service);
        FormTypeManager formTypeManager = new FormTypeManager(proxy);
        List<WikittyExtension> allFormTypes = formTypeManager.getAllFormTypes();
        return allFormTypes;
    }

    static void importFormTypes_004(List<WikittyExtension> formTypes, WikittyProxy proxy) {
        log.info((Object)"import FormType to 0.0.4");
        proxy.getWikittyService().storeExtension(formTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File exportObjects_003(WikittyServiceJDBC_003 service) {
        File file;
        log.info((Object)"export objects from 0.0.3");
        Search search = VradiQueryParser.search("extensions:(* -Form -Sending)");
        Criteria criteria = search.criteria();
        ArrayList<String> deleteList = new ArrayList<String>();
        PagedResult wikittyIds = service.getSearchEngine().findAllByCriteria(criteria);
        for (String wikittyId : wikittyIds.getAll()) {
            boolean exists = service.getWikittyStorage().exists(wikittyId);
            if (exists) continue;
            deleteList.add(wikittyId);
        }
        log.info((Object)("deleting: " + deleteList));
        service.getSearchEngine().delete(deleteList);
        String exportString = service.syncExportAllByCriteria(criteria);
        exportString = StringUtils.replace((String)exportString, (String)"<XmlFieldBinding.formField>Form.name</XmlFieldBinding.formField>", (String)"<XmlFieldBinding.formField>Infogene.objet</XmlFieldBinding.formField>");
        exportString = StringUtils.replace((String)exportString, (String)"<XmlFieldBinding.formField>Form.source</XmlFieldBinding.formField>", (String)"<XmlFieldBinding.formField>Infogene.sourceText</XmlFieldBinding.formField>");
        exportString = StringUtils.replace((String)exportString, (String)"<XmlFieldBinding.formField>Form.description</XmlFieldBinding.formField>", (String)"<XmlFieldBinding.formField>Infogene.description</XmlFieldBinding.formField>");
        exportString = StringUtils.replace((String)exportString, (String)"<XmlFieldBinding.formField>Form.initiateur</XmlFieldBinding.formField>", (String)"<XmlFieldBinding.formField>Infogene.entity</XmlFieldBinding.formField>");
        exportString = StringUtils.replace((String)exportString, (String)"<field>WIKITTY xmlFieldBinding[0-*] unique</field>", (String)"<field>STRING formTypeName unique</field>\n<field>WIKITTY xmlFieldBinding[0-*] unique</field>");
        BufferedWriter output = null;
        try {
            File exportFile = File.createTempFile("vradi_export_from_003_", null);
            output = new BufferedWriter(new FileWriter(exportFile));
            IOUtils.write((String)exportString, (Writer)output);
            log.info((Object)("export objects from 0.0.3 to file: " + exportFile.getAbsolutePath()));
            file = exportFile;
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly(output);
                throw throwable;
            }
            catch (Exception e1) {
                throw new UnhandledException((Throwable)e1);
            }
        }
        IOUtils.closeQuietly((Writer)output);
        return file;
    }

    static void importObjects_004(File file, WikittyProxy proxy) {
        log.info((Object)"import objects to 0.0.4");
        String toURI = file.toURI().toString();
        proxy.syncImportFromUri(toURI);
    }

    private static class WikittyServiceJDBC_003
    extends AbstractWikittyService {
        protected WikittySearchEngine searchEngine;
        protected WikittyExtensionStorage extensionStorage;
        protected WikittyStorage wikittyStorage;

        public WikittyServiceJDBC_003(String solrDataDir) {
            Properties properties = this.loadProperties();
            this.extensionStorage = new WikittyExtensionStorageJDBC(properties);
            this.wikittyStorage = new WikittyStorageJDBC(this.extensionStorage, properties);
            this.searchEngine = new WikittySearchEngineSolr(this.extensionStorage, solrDataDir);
        }

        Properties loadProperties() {
            try {
                Properties properties = new Properties();
                URL url = Resource.getURL((String)"com/jurismarches/vradi/migration/jdbc003.properties");
                properties.load(url.openStream());
                return properties;
            }
            catch (Exception e) {
                throw new WikittyException(e);
            }
        }

        protected WikittySearchEngine getSearchEngine() {
            return this.searchEngine;
        }

        protected WikittyExtensionStorage getExtensionStorage() {
            return this.extensionStorage;
        }

        protected WikittyStorage getWikittyStorage() {
            return this.wikittyStorage;
        }
    }
}

