/*
 * *##%
 * Vradi :: Services
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.services.search;


/**
 * <code>CompareFilter</code> is the association of a term and a value.
 * 
 * @author $Author: schorlet $
 * @version $Revision: 439 $ $Date: 2010-01-24 15:27:45 +0100 (dim., 24 janv. 2010) $
 * @since 0.0.4
 */
public class CompareFilter implements Filter {
    private static final long serialVersionUID = 1L;

    private String term = null;
    private String value = null;

    public CompareFilter() {
    }

    public CompareFilter(String term, String value) {
        this.term = term;
        this.value = value;
    }

    public String getName() {
        return term;
    }

    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return String.format("%s = %s", term, value);
    }
}
