/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.dto;

import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.GroupBean;
import com.jurismarches.vradi.entities.ModificationTag;
import com.jurismarches.vradi.services.dto.VradiDTO;
import java.util.Date;
import java.util.HashSet;

public class VradiGroupDTO
extends GroupBean
implements VradiDTO<Group> {
    private static final long serialVersionUID = 1L;

    public VradiGroupDTO() {
        this.Group$client = new HashSet();
        this.Group$user = new HashSet();
        this.QueryMaker$queries = new HashSet();
    }

    @Override
    public void fromWikitty(Group wikitty) {
        if (wikitty == null) {
            this.reset();
        } else {
            this.setWikittyId(wikitty.getWikittyId());
            this.setName(wikitty.getName());
            if (wikitty.getExtensions().contains(ModificationTag.MODIFICATION_TAG)) {
                Object lastModified = wikitty.getField("ModificationTag", "lastModified");
                this.setLastModified(lastModified != null ? (Date)lastModified : null);
                Object lastModifier = wikitty.getField("ModificationTag", "lastModifier");
                this.setLastModifier(lastModifier != null ? (String)lastModifier : null);
            } else {
                this.setLastModified(null);
                this.setLastModifier(null);
            }
            this.Group$client.clear();
            this.addAllClients(wikitty.getClient());
            this.Group$user.clear();
            this.addAllUsers(wikitty.getUser());
            this.QueryMaker$queries.clear();
            this.addAllQueries(wikitty.getQueries());
        }
    }

    @Override
    public void reset() {
        this.setWikittyId(null);
        this.setName(null);
        this.setLastModified(null);
        this.setLastModifier(null);
        this.clearClient();
        this.clearQueries();
        this.clearUser();
    }

    @Override
    public void toWikitty(Group wikitty) {
        wikitty.setName(this.getName());
        wikitty.setField("ModificationTag", "lastModified", (Object)this.getLastModified());
        wikitty.setField("ModificationTag", "lastModifier", (Object)this.getLastModifier());
        wikitty.clearClient();
        for (String id : this.getClient()) {
            wikitty.addClient(id);
        }
        wikitty.clearUser();
        for (String id : this.getUser()) {
            wikitty.addUser(id);
        }
        wikitty.clearQueries();
        for (String id : this.getQueries()) {
            wikitty.addQueries(id);
        }
    }

    public void setWikittyId(String id) {
        String old = this.id;
        this.id = id;
        this.propertyChange.firePropertyChange("wikittyId", old, id);
    }

    public Date getLastModified() {
        return (Date)this.getField("ModificationTag", "lastModified");
    }

    public void setLastModified(Date lastModified) {
        Date oldValue = this.getLastModified();
        this.setField("ModificationTag", "lastModified", lastModified);
        this.propertyChange.firePropertyChange("lastModified", oldValue, lastModified);
    }

    public String getLastModifier() {
        return (String)this.getField("ModificationTag", "lastModifier");
    }

    public void setLastModifier(String lastModifier) {
        String oldValue = this.getLastModifier();
        this.setField("ModificationTag", "lastModifier", lastModifier);
        this.propertyChange.firePropertyChange("lastModifier", oldValue, lastModifier);
    }

    public void addAllUsers(Iterable<String> element) {
        if (element != null) {
            for (String s : element) {
                this.Group$user.add(s);
            }
        }
        this.propertyChange.firePropertyChange("user", null, this.Group$user);
    }

    public void addAllClients(Iterable<String> element) {
        if (element != null) {
            for (String s : element) {
                this.Group$client.add(s);
            }
        }
        this.propertyChange.firePropertyChange("client", null, this.Group$client);
    }

    public void addAllQueries(Iterable<String> element) {
        if (element != null) {
            for (String s : element) {
                this.QueryMaker$queries.add(s);
            }
        }
        this.propertyChange.firePropertyChange("queries", null, this.QueryMaker$queries);
    }
}

