/*
 * #%L
 * Vradi :: Entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  abstract class XmlFieldBindingAbstract extends BusinessEntityImpl implements XmlFieldBinding {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionXmlFieldBinding;
    /**
     * getXmlField :
     * @return Set<String> 
     */

    @Override
    public Set<String> getXmlField() {
        Set<String> result = XmlFieldBindingHelper.getXmlField(getWikitty());
        return result;
}

    /**
     * setXmlField :
     * @param xmlField 
     */

    @Override
    public void setXmlField(Set<String> xmlField) {
        Set<String> oldValue = getXmlField();
        XmlFieldBindingHelper.setXmlField(getWikitty(), xmlField);
        getPropertyChangeSupport().firePropertyChange(XmlFieldBinding.FIELD_XMLFIELDBINDING_XMLFIELD, oldValue, getXmlField());
}

    /**
     * addAllXmlField :
     * @param xmlField 
     */

    @Override
    public void addAllXmlField(Set<String> xmlField) {
        Set<String> oldValue = getXmlField();
        XmlFieldBindingHelper.addAllXmlField(getWikitty(), xmlField);
        getPropertyChangeSupport().firePropertyChange(XmlFieldBinding.FIELD_XMLFIELDBINDING_XMLFIELD, oldValue, getXmlField());
}

    /**
     * addXmlField :
     * @param element 
     */

    @Override
    public void addXmlField(String element) {
        XmlFieldBindingHelper.addXmlField(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(XmlFieldBinding.FIELD_XMLFIELDBINDING_XMLFIELD, null, getXmlField());
}

    /**
     * removeXmlField :
     * @param element 
     */

    @Override
    public void removeXmlField(String element) {
        XmlFieldBindingHelper.removeXmlField(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(XmlFieldBinding.FIELD_XMLFIELDBINDING_XMLFIELD, null, getXmlField());
}

    /**
     * clearXmlField :
     */

    @Override
    public void clearXmlField() {
        XmlFieldBindingHelper.clearXmlField(getWikitty());
        getPropertyChangeSupport().firePropertyChange(XmlFieldBinding.FIELD_XMLFIELDBINDING_XMLFIELD, null, getXmlField());
}

    /**
     * getFormField :
     * @return String 
     */

    @Override
    public String getFormField() {
        String value = XmlFieldBindingHelper.getFormField(getWikitty());
        return value;
}

    /**
     * setFormField :
     * @param formField 
     */

    @Override
    public void setFormField(String formField) {
        String oldValue = getFormField();
        XmlFieldBindingHelper.setFormField(getWikitty(), formField);
        getPropertyChangeSupport().firePropertyChange(XmlFieldBinding.FIELD_XMLFIELDBINDING_FORMFIELD, oldValue, getFormField());
}

    /**
     * getDefaultValue :
     * @return String 
     */

    @Override
    public String getDefaultValue() {
        String value = XmlFieldBindingHelper.getDefaultValue(getWikitty());
        return value;
}

    /**
     * setDefaultValue :
     * @param defaultValue 
     */

    @Override
    public void setDefaultValue(String defaultValue) {
        String oldValue = getDefaultValue();
        XmlFieldBindingHelper.setDefaultValue(getWikitty(), defaultValue);
        getPropertyChangeSupport().firePropertyChange(XmlFieldBinding.FIELD_XMLFIELDBINDING_DEFAULTVALUE, oldValue, getDefaultValue());
}

    /**
     * XmlFieldBindingAbstract :
     */

    public XmlFieldBindingAbstract() {
        super();
}

    /**
     * XmlFieldBindingAbstract :
     * @param wikitty 
     */

    public XmlFieldBindingAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * XmlFieldBindingAbstract :
     * @param businessEntityImpl 
     */

    public XmlFieldBindingAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionXmlFieldBinding =
                new WikittyExtension(EXT_XMLFIELDBINDING,
                                     "2.0", // version
                                     null,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "String xmlField[0-*] unique=\"true\"", 
                                             "String formField unique=\"true\"", 
                                             "String defaultValue unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionXmlFieldBinding);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //XmlFieldBindingAbstract
