/*
 * #%L
 * Vradi :: Entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  abstract class FormAbstract extends BusinessEntityImpl implements Form {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionForm;
    /**
     * getDatePub :
     * @return Date 
     */

    @Override
    public Date getDatePub() {
        Date value = FormHelper.getDatePub(getWikitty());
        return value;
}

    /**
     * setDatePub :
     * @param datePub 
     */

    @Override
    public void setDatePub(Date datePub) {
        Date oldValue = getDatePub();
        FormHelper.setDatePub(getWikitty(), datePub);
        getPropertyChangeSupport().firePropertyChange(Form.FIELD_FORM_DATEPUB, oldValue, getDatePub());
}

    /**
     * getDatePeremption :
     * @return Date 
     */

    @Override
    public Date getDatePeremption() {
        Date value = FormHelper.getDatePeremption(getWikitty());
        return value;
}

    /**
     * setDatePeremption :
     * @param datePeremption 
     */

    @Override
    public void setDatePeremption(Date datePeremption) {
        Date oldValue = getDatePeremption();
        FormHelper.setDatePeremption(getWikitty(), datePeremption);
        getPropertyChangeSupport().firePropertyChange(Form.FIELD_FORM_DATEPEREMPTION, oldValue, getDatePeremption());
}

    /**
     * getFiles :
     * @return Set<String> 
     */

    @Override
    public Set<String> getFiles() {
        Set<String> result = FormHelper.getFiles(getWikitty());
        return result;
}

    /**
     * setFiles :
     * @param files 
     */

    @Override
    public void setFiles(Set<String> files) {
        Set<String> oldValue = getFiles();
        FormHelper.setFiles(getWikitty(), files);
        getPropertyChangeSupport().firePropertyChange(Form.FIELD_FORM_FILES, oldValue, getFiles());
}

    /**
     * addAllFiles :
     * @param files 
     */

    @Override
    public void addAllFiles(Set<String> files) {
        Set<String> oldValue = getFiles();
        FormHelper.addAllFiles(getWikitty(), files);
        getPropertyChangeSupport().firePropertyChange(Form.FIELD_FORM_FILES, oldValue, getFiles());
}

    /**
     * addFiles :
     * @param element 
     */

    @Override
    public void addFiles(String element) {
        FormHelper.addFiles(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(Form.FIELD_FORM_FILES, null, getFiles());
}

    /**
     * removeFiles :
     * @param element 
     */

    @Override
    public void removeFiles(String element) {
        FormHelper.removeFiles(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(Form.FIELD_FORM_FILES, null, getFiles());
}

    /**
     * clearFiles :
     */

    @Override
    public void clearFiles() {
        FormHelper.clearFiles(getWikitty());
        getPropertyChangeSupport().firePropertyChange(Form.FIELD_FORM_FILES, null, getFiles());
}

    /**
     * getAttachments :
     * @return Set<String> 
     */

    @Override
    public Set<String> getAttachments() {
        Set<String> result = FormHelper.getAttachments(getWikitty());
        return result;
}

    /**
     * setAttachments :
     * @param attachments 
     */

    @Override
    public void setAttachments(Set<String> attachments) {
        Set<String> oldValue = getAttachments();
        FormHelper.setAttachments(getWikitty(), attachments);
        getPropertyChangeSupport().firePropertyChange(Form.FIELD_FORM_ATTACHMENTS, oldValue, getAttachments());
}

    /**
     * addAllAttachments :
     * @param attachments 
     */

    @Override
    public void addAllAttachments(Set<String> attachments) {
        Set<String> oldValue = getAttachments();
        FormHelper.addAllAttachments(getWikitty(), attachments);
        getPropertyChangeSupport().firePropertyChange(Form.FIELD_FORM_ATTACHMENTS, oldValue, getAttachments());
}

    /**
     * addAttachments :
     * @param element 
     */

    @Override
    public void addAttachments(String element) {
        FormHelper.addAttachments(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(Form.FIELD_FORM_ATTACHMENTS, null, getAttachments());
}

    /**
     * removeAttachments :
     * @param element 
     */

    @Override
    public void removeAttachments(String element) {
        FormHelper.removeAttachments(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(Form.FIELD_FORM_ATTACHMENTS, null, getAttachments());
}

    /**
     * clearAttachments :
     */

    @Override
    public void clearAttachments() {
        FormHelper.clearAttachments(getWikitty());
        getPropertyChangeSupport().firePropertyChange(Form.FIELD_FORM_ATTACHMENTS, null, getAttachments());
}

    /**
     * getImportContentHash :
     * @return String 
     */

    @Override
    public String getImportContentHash() {
        String value = FormHelper.getImportContentHash(getWikitty());
        return value;
}

    /**
     * setImportContentHash :
     * @param importContentHash 
     */

    @Override
    public void setImportContentHash(String importContentHash) {
        String oldValue = getImportContentHash();
        FormHelper.setImportContentHash(getWikitty(), importContentHash);
        getPropertyChangeSupport().firePropertyChange(Form.FIELD_FORM_IMPORTCONTENTHASH, oldValue, getImportContentHash());
}

    /**
     * getXmlStream :
     * @return String 
     */

    @Override
    public String getXmlStream() {
        String value = FormHelper.getXmlStream(getWikitty());
        return value;
}

    /**
     * setXmlStream :
     * @param xmlStream 
     */

    @Override
    public void setXmlStream(String xmlStream) {
        String oldValue = getXmlStream();
        FormHelper.setXmlStream(getWikitty(), xmlStream);
        getPropertyChangeSupport().firePropertyChange(Form.FIELD_FORM_XMLSTREAM, oldValue, getXmlStream());
}

    /**
     * getId :
     * @return String 
     */

    public String getId() {
        String value = InfogeneHelper.getId(getWikitty());
        return value;
}

    /**
     * setId :
     * @param id 
     */

    public void setId(String id) {
        String oldValue = getId();
        InfogeneHelper.setId(getWikitty(), id);
        getPropertyChangeSupport().firePropertyChange(Infogene.FIELD_INFOGENE_ID, oldValue, getId());
}

    /**
     * getObjet :
     * @return String 
     */

    public String getObjet() {
        String value = InfogeneHelper.getObjet(getWikitty());
        return value;
}

    /**
     * setObjet :
     * @param objet 
     */

    public void setObjet(String objet) {
        String oldValue = getObjet();
        InfogeneHelper.setObjet(getWikitty(), objet);
        getPropertyChangeSupport().firePropertyChange(Infogene.FIELD_INFOGENE_OBJET, oldValue, getObjet());
}

    /**
     * getCreationDate :
     * @return Date 
     */

    public Date getCreationDate() {
        Date value = InfogeneHelper.getCreationDate(getWikitty());
        return value;
}

    /**
     * setCreationDate :
     * @param creationDate 
     */

    public void setCreationDate(Date creationDate) {
        Date oldValue = getCreationDate();
        InfogeneHelper.setCreationDate(getWikitty(), creationDate);
        getPropertyChangeSupport().firePropertyChange(Infogene.FIELD_INFOGENE_CREATIONDATE, oldValue, getCreationDate());
}

    /**
     * getSourceURL :
     * @return String 
     */

    public String getSourceURL() {
        String value = InfogeneHelper.getSourceURL(getWikitty());
        return value;
}

    /**
     * setSourceURL :
     * @param sourceURL 
     */

    public void setSourceURL(String sourceURL) {
        String oldValue = getSourceURL();
        InfogeneHelper.setSourceURL(getWikitty(), sourceURL);
        getPropertyChangeSupport().firePropertyChange(Infogene.FIELD_INFOGENE_SOURCEURL, oldValue, getSourceURL());
}

    /**
     * getSourceText :
     * @return String 
     */

    public String getSourceText() {
        String value = InfogeneHelper.getSourceText(getWikitty());
        return value;
}

    /**
     * setSourceText :
     * @param sourceText 
     */

    public void setSourceText(String sourceText) {
        String oldValue = getSourceText();
        InfogeneHelper.setSourceText(getWikitty(), sourceText);
        getPropertyChangeSupport().firePropertyChange(Infogene.FIELD_INFOGENE_SOURCETEXT, oldValue, getSourceText());
}

    /**
     * getEntity :
     * @return String 
     */

    public String getEntity() {
        String value = InfogeneHelper.getEntity(getWikitty());
        return value;
}

    /**
     * setEntity :
     * @param entity 
     */

    public void setEntity(String entity) {
        String oldValue = getEntity();
        InfogeneHelper.setEntity(getWikitty(), entity);
        getPropertyChangeSupport().firePropertyChange(Infogene.FIELD_INFOGENE_ENTITY, oldValue, getEntity());
}

    /**
     * getCountry :
     * @return String 
     */

    public String getCountry() {
        String value = InfogeneHelper.getCountry(getWikitty());
        return value;
}

    /**
     * setCountry :
     * @param country 
     */

    public void setCountry(String country) {
        String oldValue = getCountry();
        InfogeneHelper.setCountry(getWikitty(), country);
        getPropertyChangeSupport().firePropertyChange(Infogene.FIELD_INFOGENE_COUNTRY, oldValue, getCountry());
}

    /**
     * getDepartment :
     * @return String 
     */

    public String getDepartment() {
        String value = InfogeneHelper.getDepartment(getWikitty());
        return value;
}

    /**
     * setDepartment :
     * @param department 
     */

    public void setDepartment(String department) {
        String oldValue = getDepartment();
        InfogeneHelper.setDepartment(getWikitty(), department);
        getPropertyChangeSupport().firePropertyChange(Infogene.FIELD_INFOGENE_DEPARTMENT, oldValue, getDepartment());
}

    /**
     * getDescription :
     * @return String 
     */

    public String getDescription() {
        String value = InfogeneHelper.getDescription(getWikitty());
        return value;
}

    /**
     * setDescription :
     * @param description 
     */

    public void setDescription(String description) {
        String oldValue = getDescription();
        InfogeneHelper.setDescription(getWikitty(), description);
        getPropertyChangeSupport().firePropertyChange(Infogene.FIELD_INFOGENE_DESCRIPTION, oldValue, getDescription());
}

    /**
     * getTag :
     * @return Set<String> 
     */

    public Set<String> getTag() {
        Set<String> result = InfogeneHelper.getTag(getWikitty());
        return result;
}

    /**
     * setTag :
     * @param tag 
     */

    public void setTag(Set<String> tag) {
        Set<String> oldValue = getTag();
        InfogeneHelper.setTag(getWikitty(), tag);
        getPropertyChangeSupport().firePropertyChange(Infogene.FIELD_INFOGENE_TAG, oldValue, getTag());
}

    /**
     * addAllTag :
     * @param tag 
     */

    public void addAllTag(Set<String> tag) {
        Set<String> oldValue = getTag();
        InfogeneHelper.addAllTag(getWikitty(), tag);
        getPropertyChangeSupport().firePropertyChange(Infogene.FIELD_INFOGENE_TAG, oldValue, getTag());
}

    /**
     * addTag :
     * @param element 
     */

    public void addTag(String element) {
        InfogeneHelper.addTag(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(Infogene.FIELD_INFOGENE_TAG, null, getTag());
}

    /**
     * removeTag :
     * @param element 
     */

    public void removeTag(String element) {
        InfogeneHelper.removeTag(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(Infogene.FIELD_INFOGENE_TAG, null, getTag());
}

    /**
     * clearTag :
     */

    public void clearTag() {
        InfogeneHelper.clearTag(getWikitty());
        getPropertyChangeSupport().firePropertyChange(Infogene.FIELD_INFOGENE_TAG, null, getTag());
}

    /**
     * getStatus :
     * @return String 
     */

    public String getStatus() {
        String value = InfogeneHelper.getStatus(getWikitty());
        return value;
}

    /**
     * setStatus :
     * @param status 
     */

    public void setStatus(String status) {
        String oldValue = getStatus();
        InfogeneHelper.setStatus(getWikitty(), status);
        getPropertyChangeSupport().firePropertyChange(Infogene.FIELD_INFOGENE_STATUS, oldValue, getStatus());
}

    /**
     * FormAbstract :
     */

    public FormAbstract() {
        super();
}

    /**
     * FormAbstract :
     * @param wikitty 
     */

    public FormAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * FormAbstract :
     * @param businessEntityImpl 
     */

    public FormAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionForm =
                new WikittyExtension(EXT_FORM,
                                     "7.0", // version
                                     Infogene.EXT_INFOGENE,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "Date datePub unique=\"true\"", 
                                             "Date datePeremption unique=\"true\"", 
                                             "String files[0-*] unique=\"true\"", 
                                             "String attachments[0-*] unique=\"true\"", 
                                             "String importContentHash unique=\"true\" documentation=\"Hash SHA1 du contenu xml du flux lors de son import.\"", 
                                             "Wikitty xmlStream unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.addAll(InfogeneAbstract.extensions); 
        // current after requires ones

        exts.add(extensionForm);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //FormAbstract
