/*
 * #%L
 * Vradi :: Entities
 * 
 * $Id: FieldTypeEnum.java 1807 2010-11-24 15:11:33Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.5.1/vradi-entities/src/main/java/com/jurismarches/vradi/entities/FieldTypeEnum.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.entities;

import static org.nuiton.i18n.I18n.n_;
import org.nuiton.wikitty.entities.FieldType;

/**
 * @author letellier
 */
public enum FieldTypeEnum {
    STRING(FieldType.TYPE.STRING, n_("vradi.fieldTypeEnum.string"), 0, 1),
    TEXT(FieldType.TYPE.STRING, n_("vradi.fieldTypeEnum.text"), 0, 1),
    DATE(FieldType.TYPE.DATE, n_("vradi.fieldTypeEnum.date"), 1, 1),
    DATE_TIME(FieldType.TYPE.DATE, n_("vradi.fieldTypeEnum.dateTime"), 1, 1),
    EMAIL(FieldType.TYPE.STRING, n_("vradi.fieldTypeEnum.email"), 0, 1),
    URL(FieldType.TYPE.STRING, n_("vradi.fieldTypeEnum.url"), 0, 1),
    NUMERIC(FieldType.TYPE.NUMERIC, n_("vradi.fieldTypeEnum.numeric"), 1, 1),
    CURRENCY(FieldType.TYPE.STRING, n_("vradi.fieldTypeEnum.currency"), 0, 1);

    public static final String CURRENCY_TAG_VALUE = "currency";

    protected String TAG_VALUE = "use";
    protected String tagValue;
    protected FieldType type;

    FieldTypeEnum(FieldType.TYPE type, String tagValue, int min, int max) {
        this.tagValue = tagValue;
        this.type = new FieldType(type, min, max);
        this.type.addTagValue(TAG_VALUE, tagValue);
    }

    public String getTagValue() {
        return tagValue;
    }

    public FieldType getFieldType() {
        FieldType result = new FieldType(type.getType(), type.getLowerBound(), type.getUpperBound());
        result.addTagValue(TAG_VALUE, tagValue);

        return result;
    }

    public boolean isType(FieldType type) {
        return tagValue.equals(type.getTagValue(TAG_VALUE));
    }

    @Override
    public String toString() {
        return getTagValue();
    }

    public static FieldTypeEnum valueOf(FieldType type) {
        FieldTypeEnum e;
        if (FieldTypeEnum.DATE_TIME.isType(type)) {
            e = FieldTypeEnum.DATE_TIME;
        } else if (FieldTypeEnum.DATE.isType(type) || FieldType.TYPE.DATE.equals(type.getType())) {
            e = FieldTypeEnum.DATE;
        } else if (FieldTypeEnum.EMAIL.isType(type)) {
            e = FieldTypeEnum.EMAIL;
        } else if (FieldTypeEnum.CURRENCY.isType(type)) {
            e = FieldTypeEnum.CURRENCY;
        } else if (FieldTypeEnum.NUMERIC.isType(type) || FieldType.TYPE.NUMERIC.equals(type.getType())) {
            e = FieldTypeEnum.NUMERIC;
        } else if (FieldTypeEnum.TEXT.isType(type)) {
            e = FieldTypeEnum.TEXT;
        } else if (FieldTypeEnum.URL.isType(type)) {
            e = FieldTypeEnum.URL;
        } else {
            e = FieldTypeEnum.STRING;
        }
        return e;
    }

    static public Currency getCurrency(String value) {
        if ("vradi.currency.euro".equals(value)) {
            return Currency.EUR;
        } else if ("vradi.currency.usd".equals(value)) {
            return Currency.USD;
        } else if ("vradi.currency.gbp".equals(value)) {
            return Currency.GBP;
        }
        return null;
    }

    public enum Currency {
        EUR("vradi.currency.euro"),
        USD("vradi.currency.usd"),
        GBP("vradi.currency.gbp");

        private String name;

        Currency(String name) {
            this.name = name;
        }

        @Override
        public String toString() {
            return name;
        }
    }

}
