package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUtil;

public abstract class WebHarvestStreamAbstract extends XmlStreamImpl implements WebHarvestStream, XmlStream {

    private static final long serialVersionUID = 780944920L;

    static final public List<WikittyExtension> extensions;
    static final public WikittyExtension extensionWebHarvestStream =
        new WikittyExtension(EXT_WEBHARVESTSTREAM, "1.0", XmlStream.EXT_XMLSTREAM,
		    WikittyUtil.buildFieldMapExtension(
				"String scriptUrl"));
    static {
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.addAll(XmlStreamAbstract.extensions);
        // current after requires ones
        exts.add(extensionWebHarvestStream);

        extensions = Collections.unmodifiableList(exts);
    }

	public WebHarvestStreamAbstract() {
		super();
	}

    public WebHarvestStreamAbstract(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public WebHarvestStreamAbstract(Wikitty wi) {
		super(wi);
	}


    public void setScriptUrl(String scriptUrl) {
        Object oldValue = getField(EXT_WEBHARVESTSTREAM, FIELD_WEBHARVESTSTREAM_SCRIPTURL);
        getWikitty().setField(EXT_WEBHARVESTSTREAM, FIELD_WEBHARVESTSTREAM_SCRIPTURL, scriptUrl);
        getPropertyChangeSupport().firePropertyChange(FIELD_WEBHARVESTSTREAM_SCRIPTURL, oldValue, scriptUrl);
    }

    public String getScriptUrl() {
        String result = getWikitty().getFieldAsString(EXT_WEBHARVESTSTREAM, FIELD_WEBHARVESTSTREAM_SCRIPTURL);
        return result;
    }


    public void setUrl(String url) {
        Object oldValue = getField(EXT_XMLSTREAM, FIELD_XMLSTREAM_URL);
        getWikitty().setField(EXT_XMLSTREAM, FIELD_XMLSTREAM_URL, url);
        getPropertyChangeSupport().firePropertyChange(FIELD_XMLSTREAM_URL, oldValue, url);
    }

    public String getUrl() {
        String result = getWikitty().getFieldAsString(EXT_XMLSTREAM, FIELD_XMLSTREAM_URL);
        return result;
    }


    public void setName(String name) {
        Object oldValue = getField(EXT_XMLSTREAM, FIELD_XMLSTREAM_NAME);
        getWikitty().setField(EXT_XMLSTREAM, FIELD_XMLSTREAM_NAME, name);
        getPropertyChangeSupport().firePropertyChange(FIELD_XMLSTREAM_NAME, oldValue, name);
    }

    public String getName() {
        String result = getWikitty().getFieldAsString(EXT_XMLSTREAM, FIELD_XMLSTREAM_NAME);
        return result;
    }


    public void setFormTypeName(String formTypeName) {
        Object oldValue = getField(EXT_XMLSTREAM, FIELD_XMLSTREAM_FORMTYPENAME);
        getWikitty().setField(EXT_XMLSTREAM, FIELD_XMLSTREAM_FORMTYPENAME, formTypeName);
        getPropertyChangeSupport().firePropertyChange(FIELD_XMLSTREAM_FORMTYPENAME, oldValue, formTypeName);
    }

    public String getFormTypeName() {
        String result = getWikitty().getFieldAsString(EXT_XMLSTREAM, FIELD_XMLSTREAM_FORMTYPENAME);
        return result;
    }

    public java.util.Set<String> getXmlFieldBinding() {
        java.util.Set<String> result = getWikitty().getFieldAsSet(EXT_XMLSTREAM, FIELD_XMLSTREAM_XMLFIELDBINDING, String.class);
        return result;
    }

    public void addXmlFieldBinding(String element) {
        getWikitty().addToField(EXT_XMLSTREAM, FIELD_XMLSTREAM_XMLFIELDBINDING, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_XMLSTREAM_XMLFIELDBINDING, null, getXmlFieldBinding());
    }
    
    public void removeXmlFieldBinding(String element) {
        getWikitty().removeFromField(EXT_XMLSTREAM, FIELD_XMLSTREAM_XMLFIELDBINDING, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_XMLSTREAM_XMLFIELDBINDING, null, getXmlFieldBinding());
    }
    
    public void clearXmlFieldBinding() {
        getWikitty().clearField(EXT_XMLSTREAM, FIELD_XMLSTREAM_XMLFIELDBINDING);
        getPropertyChangeSupport().firePropertyChange(FIELD_XMLSTREAM_XMLFIELDBINDING, null, getXmlFieldBinding());
    }


    public void setForm(String form) {
        Object oldValue = getField(EXT_XMLSTREAM, FIELD_XMLSTREAM_FORM);
        getWikitty().setField(EXT_XMLSTREAM, FIELD_XMLSTREAM_FORM, form);
        getPropertyChangeSupport().firePropertyChange(FIELD_XMLSTREAM_FORM, oldValue, form);
    }

    public String getForm() {
        String result = getWikitty().getFieldAsString(EXT_XMLSTREAM, FIELD_XMLSTREAM_FORM);
        return result;
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_XMLSTREAM, FIELD_WEBHARVESTSTREAM_SCRIPTURL);
            Object f2 = w2.getFieldAsObject(EXT_XMLSTREAM, FIELD_WEBHARVESTSTREAM_SCRIPTURL);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //WebHarvestStreamAbstract
