package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUtil;

public class StatusHelper extends StatusImpl {

    private static final long serialVersionUID = -1476771946L;


    /**
     * This class is not instanciable, it's just helper
     */
    private StatusHelper() {
    }


    static public void setName(Wikitty w, String name) {
        w.setField(EXT_STATUS, Status.FIELD_STATUS_NAME, name);
    }

    static public String getName(Wikitty w) {
        String result = w.getFieldAsString(EXT_STATUS, Status.FIELD_STATUS_NAME);
        return result;
    }


    static public void setValue(Wikitty w, int value) {
        w.setField(EXT_STATUS, Status.FIELD_STATUS_VALUE, value);
    }

    static public int getValue(Wikitty w) {
        int result = w.getFieldAsInt(EXT_STATUS, Status.FIELD_STATUS_VALUE);
        return result;
    }


    static public void setDescription(Wikitty w, String description) {
        w.setField(EXT_STATUS, Status.FIELD_STATUS_DESCRIPTION, description);
    }

    static public String getDescription(Wikitty w) {
        String result = w.getFieldAsString(EXT_STATUS, Status.FIELD_STATUS_DESCRIPTION);
        return result;
    }


    static public void setModifiable(Wikitty w, boolean modifiable) {
        w.setField(EXT_STATUS, Status.FIELD_STATUS_MODIFIABLE, modifiable);
    }

    static public boolean getModifiable(Wikitty w) {
        boolean result = w.getFieldAsBoolean(EXT_STATUS, Status.FIELD_STATUS_MODIFIABLE);
        return result;
    }


    /**
     * Check if wikitty has current extension
     */
    static public boolean isExtension(Wikitty w) {
        boolean result = w.hasExtension(EXT_STATUS);
        return result;
    }

    /**
     * ajout les extensions static de cette classe au wikitty en argument
     */
    static public void addExtension(Wikitty w) {
        for (WikittyExtension ext : extensions) {
            w.addExtension(ext);
        }
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_STATUS, Status.FIELD_STATUS_NAME);
            Object f2 = w2.getFieldAsObject(EXT_STATUS, Status.FIELD_STATUS_NAME);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_STATUS, Status.FIELD_STATUS_VALUE);
            Object f2 = w2.getFieldAsObject(EXT_STATUS, Status.FIELD_STATUS_VALUE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_STATUS, Status.FIELD_STATUS_DESCRIPTION);
            Object f2 = w2.getFieldAsObject(EXT_STATUS, Status.FIELD_STATUS_DESCRIPTION);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_STATUS, Status.FIELD_STATUS_MODIFIABLE);
            Object f2 = w2.getFieldAsObject(EXT_STATUS, Status.FIELD_STATUS_MODIFIABLE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //StatusHelper
