package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUtil;

public class SendingHelper extends SendingImpl {

    private static final long serialVersionUID = 471432792L;


    /**
     * This class is not instanciable, it's just helper
     */
    private SendingHelper() {
    }


    static public void setSentDate(Wikitty w, Date sentDate) {
        w.setField(EXT_SENDING, Sending.FIELD_SENDING_SENTDATE, sentDate);
    }

    static public Date getSentDate(Wikitty w) {
        Date result = w.getFieldAsDate(EXT_SENDING, Sending.FIELD_SENDING_SENTDATE);
        return result;
    }


    static public void setReceptionDate(Wikitty w, Date receptionDate) {
        w.setField(EXT_SENDING, Sending.FIELD_SENDING_RECEPTIONDATE, receptionDate);
    }

    static public Date getReceptionDate(Wikitty w) {
        Date result = w.getFieldAsDate(EXT_SENDING, Sending.FIELD_SENDING_RECEPTIONDATE);
        return result;
    }


    static public void setParagraph(Wikitty w, String paragraph) {
        w.setField(EXT_SENDING, Sending.FIELD_SENDING_PARAGRAPH, paragraph);
    }

    static public String getParagraph(Wikitty w) {
        String result = w.getFieldAsString(EXT_SENDING, Sending.FIELD_SENDING_PARAGRAPH);
        return result;
    }


    static public void setReceptionProof(Wikitty w, boolean receptionProof) {
        w.setField(EXT_SENDING, Sending.FIELD_SENDING_RECEPTIONPROOF, receptionProof);
    }

    static public boolean getReceptionProof(Wikitty w) {
        boolean result = w.getFieldAsBoolean(EXT_SENDING, Sending.FIELD_SENDING_RECEPTIONPROOF);
        return result;
    }


    static public void setStatus(Wikitty w, int status) {
        w.setField(EXT_SENDING, Sending.FIELD_SENDING_STATUS, status);
    }

    static public int getStatus(Wikitty w) {
        int result = w.getFieldAsInt(EXT_SENDING, Sending.FIELD_SENDING_STATUS);
        return result;
    }


    static public void setMessageId(Wikitty w, String messageId) {
        w.setField(EXT_SENDING, Sending.FIELD_SENDING_MESSAGEID, messageId);
    }

    static public String getMessageId(Wikitty w) {
        String result = w.getFieldAsString(EXT_SENDING, Sending.FIELD_SENDING_MESSAGEID);
        return result;
    }

    static public Set<String> getForm(Wikitty w) {
        Set<String> result = w.getFieldAsSet(EXT_SENDING, Sending.FIELD_SENDING_FORM, String.class);
        return result;
    }

    static public void addForm(Wikitty w, String element) {
        w.addToField(EXT_SENDING, Sending.FIELD_SENDING_FORM, element);
    }
    
    static public void removeForm(Wikitty w, String element) {
        w.removeFromField(EXT_SENDING, Sending.FIELD_SENDING_FORM, element);
    }
    
    static public void clearForm(Wikitty w) {
        w.clearField(EXT_SENDING, Sending.FIELD_SENDING_FORM);
    }


    static public void setGroup(Wikitty w, String group) {
        w.setField(EXT_SENDING, Sending.FIELD_SENDING_GROUP, group);
    }

    static public String getGroup(Wikitty w) {
        String result = w.getFieldAsString(EXT_SENDING, Sending.FIELD_SENDING_GROUP);
        return result;
    }


    static public void setUser(Wikitty w, String user) {
        w.setField(EXT_SENDING, Sending.FIELD_SENDING_USER, user);
    }

    static public String getUser(Wikitty w) {
        String result = w.getFieldAsString(EXT_SENDING, Sending.FIELD_SENDING_USER);
        return result;
    }


    static public void setClient(Wikitty w, String client) {
        w.setField(EXT_SENDING, Sending.FIELD_SENDING_CLIENT, client);
    }

    static public String getClient(Wikitty w) {
        String result = w.getFieldAsString(EXT_SENDING, Sending.FIELD_SENDING_CLIENT);
        return result;
    }


    static public void setQueryMaker(Wikitty w, String queryMaker) {
        w.setField(EXT_SENDING, Sending.FIELD_SENDING_QUERYMAKER, queryMaker);
    }

    static public String getQueryMaker(Wikitty w) {
        String result = w.getFieldAsString(EXT_SENDING, Sending.FIELD_SENDING_QUERYMAKER);
        return result;
    }

    static public Set<String> getDeletedForms(Wikitty w) {
        Set<String> result = w.getFieldAsSet(EXT_SENDING, Sending.FIELD_SENDING_DELETEDFORMS, String.class);
        return result;
    }

    static public void addDeletedForms(Wikitty w, String element) {
        w.addToField(EXT_SENDING, Sending.FIELD_SENDING_DELETEDFORMS, element);
    }
    
    static public void removeDeletedForms(Wikitty w, String element) {
        w.removeFromField(EXT_SENDING, Sending.FIELD_SENDING_DELETEDFORMS, element);
    }
    
    static public void clearDeletedForms(Wikitty w) {
        w.clearField(EXT_SENDING, Sending.FIELD_SENDING_DELETEDFORMS);
    }


    /**
     * Check if wikitty has current extension
     */
    static public boolean isExtension(Wikitty w) {
        boolean result = w.hasExtension(EXT_SENDING);
        return result;
    }

    /**
     * ajout les extensions static de cette classe au wikitty en argument
     */
    static public void addExtension(Wikitty w) {
        for (WikittyExtension ext : extensions) {
            w.addExtension(ext);
        }
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_SENDING, Sending.FIELD_SENDING_SENTDATE);
            Object f2 = w2.getFieldAsObject(EXT_SENDING, Sending.FIELD_SENDING_SENTDATE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_SENDING, Sending.FIELD_SENDING_RECEPTIONDATE);
            Object f2 = w2.getFieldAsObject(EXT_SENDING, Sending.FIELD_SENDING_RECEPTIONDATE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_SENDING, Sending.FIELD_SENDING_PARAGRAPH);
            Object f2 = w2.getFieldAsObject(EXT_SENDING, Sending.FIELD_SENDING_PARAGRAPH);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_SENDING, Sending.FIELD_SENDING_RECEPTIONPROOF);
            Object f2 = w2.getFieldAsObject(EXT_SENDING, Sending.FIELD_SENDING_RECEPTIONPROOF);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_SENDING, Sending.FIELD_SENDING_STATUS);
            Object f2 = w2.getFieldAsObject(EXT_SENDING, Sending.FIELD_SENDING_STATUS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_SENDING, Sending.FIELD_SENDING_MESSAGEID);
            Object f2 = w2.getFieldAsObject(EXT_SENDING, Sending.FIELD_SENDING_MESSAGEID);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_SENDING, Sending.FIELD_SENDING_FORM);
            Object f2 = w2.getFieldAsObject(EXT_SENDING, Sending.FIELD_SENDING_FORM);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_SENDING, Sending.FIELD_SENDING_GROUP);
            Object f2 = w2.getFieldAsObject(EXT_SENDING, Sending.FIELD_SENDING_GROUP);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_SENDING, Sending.FIELD_SENDING_USER);
            Object f2 = w2.getFieldAsObject(EXT_SENDING, Sending.FIELD_SENDING_USER);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_SENDING, Sending.FIELD_SENDING_CLIENT);
            Object f2 = w2.getFieldAsObject(EXT_SENDING, Sending.FIELD_SENDING_CLIENT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_SENDING, Sending.FIELD_SENDING_QUERYMAKER);
            Object f2 = w2.getFieldAsObject(EXT_SENDING, Sending.FIELD_SENDING_QUERYMAKER);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_SENDING, Sending.FIELD_SENDING_DELETEDFORMS);
            Object f2 = w2.getFieldAsObject(EXT_SENDING, Sending.FIELD_SENDING_DELETEDFORMS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //SendingHelper
