package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUtil;

/**
 * Modification tag extension.
 * 
 * Changes in this extension:
 * <ul>
 *  <li>2.0 : no change but use major version
 *  <li>1.2 : add "lastStatusModifier" field
 *  <li>1.1 : lastModifier field change type to String
 *  <li>1.0 : initial version
 * </ul>
 */
public class ModificationTagHelper extends ModificationTagImpl {

    private static final long serialVersionUID = -2066496306L;


    /**
     * This class is not instanciable, it's just helper
     */
    private ModificationTagHelper() {
    }


    static public void setLastModified(Wikitty w, Date lastModified) {
        w.setField(EXT_MODIFICATIONTAG, ModificationTag.FIELD_MODIFICATIONTAG_LASTMODIFIED, lastModified);
    }

    static public Date getLastModified(Wikitty w) {
        Date result = w.getFieldAsDate(EXT_MODIFICATIONTAG, ModificationTag.FIELD_MODIFICATIONTAG_LASTMODIFIED);
        return result;
    }


    static public void setLastModifier(Wikitty w, String lastModifier) {
        w.setField(EXT_MODIFICATIONTAG, ModificationTag.FIELD_MODIFICATIONTAG_LASTMODIFIER, lastModifier);
    }

    static public String getLastModifier(Wikitty w) {
        String result = w.getFieldAsString(EXT_MODIFICATIONTAG, ModificationTag.FIELD_MODIFICATIONTAG_LASTMODIFIER);
        return result;
    }


    static public void setLastStatusModifier(Wikitty w, String lastStatusModifier) {
        w.setField(EXT_MODIFICATIONTAG, ModificationTag.FIELD_MODIFICATIONTAG_LASTSTATUSMODIFIER, lastStatusModifier);
    }

    static public String getLastStatusModifier(Wikitty w) {
        String result = w.getFieldAsString(EXT_MODIFICATIONTAG, ModificationTag.FIELD_MODIFICATIONTAG_LASTSTATUSMODIFIER);
        return result;
    }


    /**
     * Check if wikitty has current extension
     */
    static public boolean isExtension(Wikitty w) {
        boolean result = w.hasExtension(EXT_MODIFICATIONTAG);
        return result;
    }

    /**
     * ajout les extensions static de cette classe au wikitty en argument
     */
    static public void addExtension(Wikitty w) {
        for (WikittyExtension ext : extensions) {
            w.addExtension(ext);
        }
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_MODIFICATIONTAG, ModificationTag.FIELD_MODIFICATIONTAG_LASTMODIFIED);
            Object f2 = w2.getFieldAsObject(EXT_MODIFICATIONTAG, ModificationTag.FIELD_MODIFICATIONTAG_LASTMODIFIED);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_MODIFICATIONTAG, ModificationTag.FIELD_MODIFICATIONTAG_LASTMODIFIER);
            Object f2 = w2.getFieldAsObject(EXT_MODIFICATIONTAG, ModificationTag.FIELD_MODIFICATIONTAG_LASTMODIFIER);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_MODIFICATIONTAG, ModificationTag.FIELD_MODIFICATIONTAG_LASTSTATUSMODIFIER);
            Object f2 = w2.getFieldAsObject(EXT_MODIFICATIONTAG, ModificationTag.FIELD_MODIFICATIONTAG_LASTSTATUSMODIFIER);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //ModificationTagHelper
