package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUtil;

/**
 * Modification tag extension.
 * 
 * Changes in this extension:
 * <ul>
 *  <li>2.0 : no change but use major version
 *  <li>1.2 : add "lastStatusModifier" field
 *  <li>1.1 : lastModifier field change type to String
 *  <li>1.0 : initial version
 * </ul>
 */
public abstract class ModificationTagAbstract extends BusinessEntityWikitty implements ModificationTag {

    private static final long serialVersionUID = -2066496306L;

    static final public List<WikittyExtension> extensions;
    static final public WikittyExtension extensionModificationTag =
        new WikittyExtension(EXT_MODIFICATIONTAG, "2.0", null,
		    WikittyUtil.buildFieldMapExtension(
				"Date lastModified documentation=\"Last modification date.\"",
				"String lastModifier documentation=\"Last modification user name.\"",
				"String lastStatusModifier documentation=\"TODO document me !\""));
    static {
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();
        // current after requires ones
        exts.add(extensionModificationTag);

        extensions = Collections.unmodifiableList(exts);
    }

	public ModificationTagAbstract() {
		super();
	}

    public ModificationTagAbstract(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public ModificationTagAbstract(Wikitty wi) {
		super(wi);
	}


    public void setLastModified(Date lastModified) {
        Object oldValue = getField(EXT_MODIFICATIONTAG, FIELD_MODIFICATIONTAG_LASTMODIFIED);
        getWikitty().setField(EXT_MODIFICATIONTAG, FIELD_MODIFICATIONTAG_LASTMODIFIED, lastModified);
        getPropertyChangeSupport().firePropertyChange(FIELD_MODIFICATIONTAG_LASTMODIFIED, oldValue, lastModified);
    }

    public Date getLastModified() {
        Date result = getWikitty().getFieldAsDate(EXT_MODIFICATIONTAG, FIELD_MODIFICATIONTAG_LASTMODIFIED);
        return result;
    }


    public void setLastModifier(String lastModifier) {
        Object oldValue = getField(EXT_MODIFICATIONTAG, FIELD_MODIFICATIONTAG_LASTMODIFIER);
        getWikitty().setField(EXT_MODIFICATIONTAG, FIELD_MODIFICATIONTAG_LASTMODIFIER, lastModifier);
        getPropertyChangeSupport().firePropertyChange(FIELD_MODIFICATIONTAG_LASTMODIFIER, oldValue, lastModifier);
    }

    public String getLastModifier() {
        String result = getWikitty().getFieldAsString(EXT_MODIFICATIONTAG, FIELD_MODIFICATIONTAG_LASTMODIFIER);
        return result;
    }


    public void setLastStatusModifier(String lastStatusModifier) {
        Object oldValue = getField(EXT_MODIFICATIONTAG, FIELD_MODIFICATIONTAG_LASTSTATUSMODIFIER);
        getWikitty().setField(EXT_MODIFICATIONTAG, FIELD_MODIFICATIONTAG_LASTSTATUSMODIFIER, lastStatusModifier);
        getPropertyChangeSupport().firePropertyChange(FIELD_MODIFICATIONTAG_LASTSTATUSMODIFIER, oldValue, lastStatusModifier);
    }

    public String getLastStatusModifier() {
        String result = getWikitty().getFieldAsString(EXT_MODIFICATIONTAG, FIELD_MODIFICATIONTAG_LASTSTATUSMODIFIER);
        return result;
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_MODIFICATIONTAG, FIELD_MODIFICATIONTAG_LASTMODIFIED);
            Object f2 = w2.getFieldAsObject(EXT_MODIFICATIONTAG, FIELD_MODIFICATIONTAG_LASTMODIFIED);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_MODIFICATIONTAG, FIELD_MODIFICATIONTAG_LASTMODIFIER);
            Object f2 = w2.getFieldAsObject(EXT_MODIFICATIONTAG, FIELD_MODIFICATIONTAG_LASTMODIFIER);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_MODIFICATIONTAG, FIELD_MODIFICATIONTAG_LASTSTATUSMODIFIER);
            Object f2 = w2.getFieldAsObject(EXT_MODIFICATIONTAG, FIELD_MODIFICATIONTAG_LASTSTATUSMODIFIER);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //ModificationTagAbstract
