package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUtil;

public class InfogeneHelper extends InfogeneImpl {

    private static final long serialVersionUID = 45742572L;


    /**
     * This class is not instanciable, it's just helper
     */
    private InfogeneHelper() {
    }


    static public void setId(Wikitty w, String id) {
        w.setField(EXT_INFOGENE, Infogene.FIELD_INFOGENE_ID, id);
    }

    static public String getId(Wikitty w) {
        String result = w.getFieldAsString(EXT_INFOGENE, Infogene.FIELD_INFOGENE_ID);
        return result;
    }


    static public void setObjet(Wikitty w, String objet) {
        w.setField(EXT_INFOGENE, Infogene.FIELD_INFOGENE_OBJET, objet);
    }

    static public String getObjet(Wikitty w) {
        String result = w.getFieldAsString(EXT_INFOGENE, Infogene.FIELD_INFOGENE_OBJET);
        return result;
    }


    static public void setCreationDate(Wikitty w, Date creationDate) {
        w.setField(EXT_INFOGENE, Infogene.FIELD_INFOGENE_CREATIONDATE, creationDate);
    }

    static public Date getCreationDate(Wikitty w) {
        Date result = w.getFieldAsDate(EXT_INFOGENE, Infogene.FIELD_INFOGENE_CREATIONDATE);
        return result;
    }


    static public void setSourceURL(Wikitty w, String sourceURL) {
        w.setField(EXT_INFOGENE, Infogene.FIELD_INFOGENE_SOURCEURL, sourceURL);
    }

    static public String getSourceURL(Wikitty w) {
        String result = w.getFieldAsString(EXT_INFOGENE, Infogene.FIELD_INFOGENE_SOURCEURL);
        return result;
    }


    static public void setSourceText(Wikitty w, String sourceText) {
        w.setField(EXT_INFOGENE, Infogene.FIELD_INFOGENE_SOURCETEXT, sourceText);
    }

    static public String getSourceText(Wikitty w) {
        String result = w.getFieldAsString(EXT_INFOGENE, Infogene.FIELD_INFOGENE_SOURCETEXT);
        return result;
    }


    static public void setEntity(Wikitty w, String entity) {
        w.setField(EXT_INFOGENE, Infogene.FIELD_INFOGENE_ENTITY, entity);
    }

    static public String getEntity(Wikitty w) {
        String result = w.getFieldAsString(EXT_INFOGENE, Infogene.FIELD_INFOGENE_ENTITY);
        return result;
    }


    static public void setCountry(Wikitty w, String country) {
        w.setField(EXT_INFOGENE, Infogene.FIELD_INFOGENE_COUNTRY, country);
    }

    static public String getCountry(Wikitty w) {
        String result = w.getFieldAsString(EXT_INFOGENE, Infogene.FIELD_INFOGENE_COUNTRY);
        return result;
    }


    static public void setDepartment(Wikitty w, String department) {
        w.setField(EXT_INFOGENE, Infogene.FIELD_INFOGENE_DEPARTMENT, department);
    }

    static public String getDepartment(Wikitty w) {
        String result = w.getFieldAsString(EXT_INFOGENE, Infogene.FIELD_INFOGENE_DEPARTMENT);
        return result;
    }


    static public void setDescription(Wikitty w, String description) {
        w.setField(EXT_INFOGENE, Infogene.FIELD_INFOGENE_DESCRIPTION, description);
    }

    static public String getDescription(Wikitty w) {
        String result = w.getFieldAsString(EXT_INFOGENE, Infogene.FIELD_INFOGENE_DESCRIPTION);
        return result;
    }

    static public Set<String> getTag(Wikitty w) {
        Set<String> result = w.getFieldAsSet(EXT_INFOGENE, Infogene.FIELD_INFOGENE_TAG, String.class);
        return result;
    }

    static public void addTag(Wikitty w, String element) {
        w.addToField(EXT_INFOGENE, Infogene.FIELD_INFOGENE_TAG, element);
    }
    
    static public void removeTag(Wikitty w, String element) {
        w.removeFromField(EXT_INFOGENE, Infogene.FIELD_INFOGENE_TAG, element);
    }
    
    static public void clearTag(Wikitty w) {
        w.clearField(EXT_INFOGENE, Infogene.FIELD_INFOGENE_TAG);
    }


    static public void setStatus(Wikitty w, String status) {
        w.setField(EXT_INFOGENE, Infogene.FIELD_INFOGENE_STATUS, status);
    }

    static public String getStatus(Wikitty w) {
        String result = w.getFieldAsString(EXT_INFOGENE, Infogene.FIELD_INFOGENE_STATUS);
        return result;
    }


    /**
     * Check if wikitty has current extension
     */
    static public boolean isExtension(Wikitty w) {
        boolean result = w.hasExtension(EXT_INFOGENE);
        return result;
    }

    /**
     * ajout les extensions static de cette classe au wikitty en argument
     */
    static public void addExtension(Wikitty w) {
        for (WikittyExtension ext : extensions) {
            w.addExtension(ext);
        }
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_INFOGENE, Infogene.FIELD_INFOGENE_ID);
            Object f2 = w2.getFieldAsObject(EXT_INFOGENE, Infogene.FIELD_INFOGENE_ID);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_INFOGENE, Infogene.FIELD_INFOGENE_OBJET);
            Object f2 = w2.getFieldAsObject(EXT_INFOGENE, Infogene.FIELD_INFOGENE_OBJET);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_INFOGENE, Infogene.FIELD_INFOGENE_CREATIONDATE);
            Object f2 = w2.getFieldAsObject(EXT_INFOGENE, Infogene.FIELD_INFOGENE_CREATIONDATE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_INFOGENE, Infogene.FIELD_INFOGENE_SOURCEURL);
            Object f2 = w2.getFieldAsObject(EXT_INFOGENE, Infogene.FIELD_INFOGENE_SOURCEURL);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_INFOGENE, Infogene.FIELD_INFOGENE_SOURCETEXT);
            Object f2 = w2.getFieldAsObject(EXT_INFOGENE, Infogene.FIELD_INFOGENE_SOURCETEXT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_INFOGENE, Infogene.FIELD_INFOGENE_ENTITY);
            Object f2 = w2.getFieldAsObject(EXT_INFOGENE, Infogene.FIELD_INFOGENE_ENTITY);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_INFOGENE, Infogene.FIELD_INFOGENE_COUNTRY);
            Object f2 = w2.getFieldAsObject(EXT_INFOGENE, Infogene.FIELD_INFOGENE_COUNTRY);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_INFOGENE, Infogene.FIELD_INFOGENE_DEPARTMENT);
            Object f2 = w2.getFieldAsObject(EXT_INFOGENE, Infogene.FIELD_INFOGENE_DEPARTMENT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_INFOGENE, Infogene.FIELD_INFOGENE_DESCRIPTION);
            Object f2 = w2.getFieldAsObject(EXT_INFOGENE, Infogene.FIELD_INFOGENE_DESCRIPTION);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_INFOGENE, Infogene.FIELD_INFOGENE_TAG);
            Object f2 = w2.getFieldAsObject(EXT_INFOGENE, Infogene.FIELD_INFOGENE_TAG);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_INFOGENE, Infogene.FIELD_INFOGENE_STATUS);
            Object f2 = w2.getFieldAsObject(EXT_INFOGENE, Infogene.FIELD_INFOGENE_STATUS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //InfogeneHelper
