package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUtil;

public abstract class GroupAbstract extends QueryMakerImpl implements Group, QueryMaker {

    private static final long serialVersionUID = 696224139L;

    static final public List<WikittyExtension> extensions;
    static final public WikittyExtension extensionGroup =
        new WikittyExtension(EXT_GROUP, "2.0", QueryMaker.EXT_QUERYMAKER,
		    WikittyUtil.buildFieldMapExtension(
				"String name",
				"Wikitty client[0-*] unique=true deprecated=\"true\"",
				"Wikitty user[0-*] unique=true"));
    static {
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.addAll(QueryMakerAbstract.extensions);
        // current after requires ones
        exts.add(extensionGroup);

        extensions = Collections.unmodifiableList(exts);
    }

	public GroupAbstract() {
		super();
	}

    public GroupAbstract(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public GroupAbstract(Wikitty wi) {
		super(wi);
	}


    public void setName(String name) {
        Object oldValue = getField(EXT_GROUP, FIELD_GROUP_NAME);
        getWikitty().setField(EXT_GROUP, FIELD_GROUP_NAME, name);
        getPropertyChangeSupport().firePropertyChange(FIELD_GROUP_NAME, oldValue, name);
    }

    public String getName() {
        String result = getWikitty().getFieldAsString(EXT_GROUP, FIELD_GROUP_NAME);
        return result;
    }

    public Set<String> getClient() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_GROUP, FIELD_GROUP_CLIENT, String.class);
        return result;
    }

    public void addClient(String element) {
        getWikitty().addToField(EXT_GROUP, FIELD_GROUP_CLIENT, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_GROUP_CLIENT, null, getClient());
    }
    
    public void removeClient(String element) {
        getWikitty().removeFromField(EXT_GROUP, FIELD_GROUP_CLIENT, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_GROUP_CLIENT, null, getClient());
    }
    
    public void clearClient() {
        getWikitty().clearField(EXT_GROUP, FIELD_GROUP_CLIENT);
        getPropertyChangeSupport().firePropertyChange(FIELD_GROUP_CLIENT, null, getClient());
    }

    public Set<String> getUser() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_GROUP, FIELD_GROUP_USER, String.class);
        return result;
    }

    public void addUser(String element) {
        getWikitty().addToField(EXT_GROUP, FIELD_GROUP_USER, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_GROUP_USER, null, getUser());
    }
    
    public void removeUser(String element) {
        getWikitty().removeFromField(EXT_GROUP, FIELD_GROUP_USER, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_GROUP_USER, null, getUser());
    }
    
    public void clearUser() {
        getWikitty().clearField(EXT_GROUP, FIELD_GROUP_USER);
        getPropertyChangeSupport().firePropertyChange(FIELD_GROUP_USER, null, getUser());
    }

    public Set<String> getQueries() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_QUERYMAKER, FIELD_QUERYMAKER_QUERIES, String.class);
        return result;
    }

    public void addQueries(String element) {
        getWikitty().addToField(EXT_QUERYMAKER, FIELD_QUERYMAKER_QUERIES, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_QUERYMAKER_QUERIES, null, getQueries());
    }
    
    public void removeQueries(String element) {
        getWikitty().removeFromField(EXT_QUERYMAKER, FIELD_QUERYMAKER_QUERIES, element);
        getPropertyChangeSupport().firePropertyChange(FIELD_QUERYMAKER_QUERIES, null, getQueries());
    }
    
    public void clearQueries() {
        getWikitty().clearField(EXT_QUERYMAKER, FIELD_QUERYMAKER_QUERIES);
        getPropertyChangeSupport().firePropertyChange(FIELD_QUERYMAKER_QUERIES, null, getQueries());
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_QUERYMAKER, FIELD_GROUP_NAME);
            Object f2 = w2.getFieldAsObject(EXT_QUERYMAKER, FIELD_GROUP_NAME);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_QUERYMAKER, FIELD_GROUP_CLIENT);
            Object f2 = w2.getFieldAsObject(EXT_QUERYMAKER, FIELD_GROUP_CLIENT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_QUERYMAKER, FIELD_GROUP_USER);
            Object f2 = w2.getFieldAsObject(EXT_QUERYMAKER, FIELD_GROUP_USER);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //GroupAbstract
