package com.jurismarches.vradi.entities;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Date;
import java.util.Set;
import org.sharengo.wikitty.BusinessEntityBean;

public class SessionBean extends BusinessEntityBean implements Session {

    private static final long serialVersionUID = 1999397049L;

    public SessionBean() {
        super();
    }

    protected transient PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener listener) {
		propertyChange.addPropertyChangeListener(listener);
	}

	public void removePropertyChangeListener(PropertyChangeListener listener) {
		propertyChange.removePropertyChangeListener(listener);
	}

	public void addPropertyChangeListener(String propertyName,PropertyChangeListener listener) {
		propertyChange.addPropertyChangeListener(propertyName, listener);
	}

	public void removePropertyChangeListener(String propertyName,PropertyChangeListener listener) {
		propertyChange.removePropertyChangeListener(propertyName, listener);
	}

    public Date Session$sessionDate;

    public int Session$num;

    public int Session$status;

    public String Session$paragraph;

    public Set<String> Session$sending;


    public void setSessionDate(Date value) {
        Object oldValue = Session$sessionDate; 
        this.Session$sessionDate = value;
        propertyChange.firePropertyChange("sessionDate", oldValue, value);
    }

    public Date getSessionDate() {
        return Session$sessionDate;
    }


    public void setNum(int value) {
        Object oldValue = Session$num; 
        this.Session$num = value;
        propertyChange.firePropertyChange("num", oldValue, value);
    }

    public int getNum() {
        return Session$num;
    }


    public void setStatus(int value) {
        Object oldValue = Session$status; 
        this.Session$status = value;
        propertyChange.firePropertyChange("status", oldValue, value);
    }

    public int getStatus() {
        return Session$status;
    }


    public void setParagraph(String value) {
        Object oldValue = Session$paragraph; 
        this.Session$paragraph = value;
        propertyChange.firePropertyChange("paragraph", oldValue, value);
    }

    public String getParagraph() {
        return Session$paragraph;
    }

    public Set<String> getSending() {
        return Session$sending;
    }

    public void addSending(String element) {
        Session$sending.add(element);
        propertyChange.firePropertyChange("sending", null, Session$sending);
    }
    
    public void removeSending(String element) {
        Session$sending.remove(element);
        propertyChange.firePropertyChange("sending", null, Session$sending);
    }
    
    public void clearSending() {
        Session$sending.clear();
        propertyChange.firePropertyChange("sending", null, Session$sending);
    }


} //SessionBean
