/*
 * *##%
 * Vradi :: Entities
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.entities;

import java.util.LinkedHashMap;

import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.WikittyExtension;

/**
 * Modification tag extension.
 * 
 * Changes in this extension:
 * <ul>
 *  <li>1.2 : add "lastStatusModifier" field
 *  <li>1.1 : lastModifier field change type to String
 *  <li>1.0 : initial version
 * </ul>
 *
 * @author morin
 *         Date: 4 déc. 2009
 *         Time: 15:16:12
 */
public final class ModificationTag {

    static final public String EXT_MODIFICATION_TAG = "ModificationTag";
    static final public String EXT_VERSION = "1.2";
    
    static final public String FIELD_LAST_MODIFIED = "lastModified";
    static final public String FQ_FIELD_LAST_MODIFIED = EXT_MODIFICATION_TAG + ".lastModified";
    
    static final public String FIELD_LAST_MODIFIER = "lastModifier";
    static final public String FQ_FIELD_LAST_MODIFIER = EXT_MODIFICATION_TAG + ".lastModifier";
    
    static final public String FIELD_LAST_STATUS_MODIFIER = "lastStatusModifier";
    static final public String FQ_FIELD_LAST_STATUS_MODIFIER = EXT_MODIFICATION_TAG + ".lastStatusModifier";
    
    static final public WikittyExtension EXTENSION_MODIFICATION_TAG = getExtension();

    public static final WikittyExtension getExtension() {
        LinkedHashMap<String, FieldType> fieldMap = new LinkedHashMap<String, FieldType>();
        fieldMap.put(FIELD_LAST_MODIFIED, FieldTypeEnum.DATE_TIME.getFieldType());
        fieldMap.put(FIELD_LAST_MODIFIER, FieldTypeEnum.STRING.getFieldType());
        fieldMap.put(FIELD_LAST_STATUS_MODIFIER, FieldTypeEnum.STRING.getFieldType());
        WikittyExtension ext = new WikittyExtension(EXT_MODIFICATION_TAG, EXT_VERSION, null, fieldMap);
        return ext;
    }
}
