package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.sharengo.wikitty.BusinessEntityWikitty;
import org.sharengo.wikitty.Wikitty;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyUtil;

public class SendingImpl extends BusinessEntityWikitty implements Sending {

    private static final long serialVersionUID = -1805520861L;


    static final public List<WikittyExtension> extensions;
    static final public WikittyExtension extensionSending =
        new WikittyExtension(EXT_SENDING, "1", null,
		    WikittyUtil.buildFieldMapExtension(
				"Date sentDate unique",
				"Date receptionDate unique",
				"String paragraph unique",
				"boolean receptionProof unique",
				"Numeric status unique",
				"Wikitty client unique",
				"Wikitty form[0-*] unique"));
    static {
        ArrayList<WikittyExtension> exts = new ArrayList<WikittyExtension>();
        exts.add(extensionSending);

        extensions = Collections.unmodifiableList(exts);
    }
 
	public SendingImpl() {
		super();
	}

    public SendingImpl(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public SendingImpl(Wikitty wi) {
		super(wi);
	}


    public void setSentDate(Date sentDate) {
        getWikitty().setField(EXT_SENDING, "sentDate", sentDate);
    }

    public Date getSentDate() {
        Date result = getWikitty().getFieldAsDate(EXT_SENDING, "sentDate");
        return result;
    }


    public void setReceptionDate(Date receptionDate) {
        getWikitty().setField(EXT_SENDING, "receptionDate", receptionDate);
    }

    public Date getReceptionDate() {
        Date result = getWikitty().getFieldAsDate(EXT_SENDING, "receptionDate");
        return result;
    }


    public void setParagraph(String paragraph) {
        getWikitty().setField(EXT_SENDING, "paragraph", paragraph);
    }

    public String getParagraph() {
        String result = getWikitty().getFieldAsString(EXT_SENDING, "paragraph");
        return result;
    }


    public void setReceptionProof(boolean receptionProof) {
        getWikitty().setField(EXT_SENDING, "receptionProof", receptionProof);
    }

    public boolean getReceptionProof() {
        boolean result = getWikitty().getFieldAsBoolean(EXT_SENDING, "receptionProof");
        return result;
    }


    public void setStatus(int status) {
        getWikitty().setField(EXT_SENDING, "status", status);
    }

    public int getStatus() {
        int result = getWikitty().getFieldAsInt(EXT_SENDING, "status");
        return result;
    }


    public void setClient(String client) {
        getWikitty().setField(EXT_SENDING, "client", client);
    }

    public String getClient() {
        String result = getWikitty().getFieldAsString(EXT_SENDING, "client");
        return result;
    }

    public Set<String> getForm() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_SENDING, "form", String.class);
        return result;
    }

    public void addForm(String element) {
        getWikitty().addToField(EXT_SENDING, "form", element);
    }
    
    public void removeForm(String element) {
        getWikitty().removeFromField(EXT_SENDING, "form", element);
    }
    
    public void clearForm() {
        getWikitty().clearField(EXT_SENDING, "form");
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }


} //SendingImpl
