package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.sharengo.wikitty.BusinessEntityWikitty;
import org.sharengo.wikitty.Wikitty;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyUtil;

public class GroupImpl extends com.jurismarches.vradi.entities.QueryMakerImpl implements Group, QueryMaker {

    private static final long serialVersionUID = 618480166L;


    static final public List<WikittyExtension> extensions;
    static final public WikittyExtension extensionGroup =
        new WikittyExtension(EXT_GROUP, "1", null,
		    WikittyUtil.buildFieldMapExtension(
				"String name unique",
				"Wikitty client[0-*] unique",
				"Wikitty user[0-*] unique"));
    static {
        ArrayList<WikittyExtension> exts = new ArrayList<WikittyExtension>();
        exts.add(extensionGroup);

        exts.addAll(QueryMakerImpl.extensions);
        extensions = Collections.unmodifiableList(exts);
    }
 
	public GroupImpl() {
		super();
	}

    public GroupImpl(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public GroupImpl(Wikitty wi) {
		super(wi);
	}


    public void setName(String name) {
        getWikitty().setField(EXT_GROUP, "name", name);
    }

    public String getName() {
        String result = getWikitty().getFieldAsString(EXT_GROUP, "name");
        return result;
    }

    public Set<String> getClient() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_GROUP, "client", String.class);
        return result;
    }

    public void addClient(String element) {
        getWikitty().addToField(EXT_GROUP, "client", element);
    }
    
    public void removeClient(String element) {
        getWikitty().removeFromField(EXT_GROUP, "client", element);
    }
    
    public void clearClient() {
        getWikitty().clearField(EXT_GROUP, "client");
    }

    public Set<String> getUser() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_GROUP, "user", String.class);
        return result;
    }

    public void addUser(String element) {
        getWikitty().addToField(EXT_GROUP, "user", element);
    }
    
    public void removeUser(String element) {
        getWikitty().removeFromField(EXT_GROUP, "user", element);
    }
    
    public void clearUser() {
        getWikitty().clearField(EXT_GROUP, "user");
    }

    public Set<String> getQueries() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_QUERYMAKER, "queries", String.class);
        return result;
    }

    public void addQueries(String element) {
        getWikitty().addToField(EXT_QUERYMAKER, "queries", element);
    }
    
    public void removeQueries(String element) {
        getWikitty().removeFromField(EXT_QUERYMAKER, "queries", element);
    }
    
    public void clearQueries() {
        getWikitty().clearField(EXT_QUERYMAKER, "queries");
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }


} //GroupImpl
