/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.jx;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.e;
import com.google.android.gms.wearable.internal.DataItemAssetParcelable;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class PutDataRequest
implements SafeParcelable {
    public static final String WEAR_URI_SCHEME = "wear";
    public static final Parcelable.Creator<PutDataRequest> CREATOR = new e();
    private static final Random axj = new SecureRandom();
    final int CK;
    private final Uri mUri;
    private final Bundle axk;
    private byte[] aeA;

    PutDataRequest(int versionCode, Uri uri, Bundle assets, byte[] data) {
        this.CK = versionCode;
        this.mUri = uri;
        this.axk = assets;
        this.axk.setClassLoader(DataItemAssetParcelable.class.getClassLoader());
        this.aeA = data;
    }

    private PutDataRequest(int versionCode, Uri uri) {
        this(versionCode, uri, new Bundle(), null);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        e.a(this, dest, flags);
    }

    public static PutDataRequest createFromDataItem(DataItem source) {
        PutDataRequest putDataRequest = PutDataRequest.k(source.getUri());
        for (Map.Entry<String, DataItemAsset> entry : source.getAssets().entrySet()) {
            if (entry.getValue().getId() == null) {
                throw new IllegalStateException("Cannot create an asset for a put request without a digest: " + entry.getKey());
            }
            putDataRequest.putAsset(entry.getKey(), Asset.createFromRef(entry.getValue().getId()));
        }
        putDataRequest.setData(source.getData());
        return putDataRequest;
    }

    public static PutDataRequest k(Uri uri) {
        return new PutDataRequest(1, uri);
    }

    public static PutDataRequest createWithAutoAppendedId(String pathPrefix) {
        StringBuilder stringBuilder = new StringBuilder(pathPrefix);
        if (!pathPrefix.endsWith("/")) {
            stringBuilder.append("/");
        }
        stringBuilder.append("PN").append(axj.nextLong());
        Uri uri = PutDataRequest.di(stringBuilder.toString());
        return new PutDataRequest(1, uri);
    }

    public static PutDataRequest create(String path) {
        Uri uri = PutDataRequest.di(path);
        return PutDataRequest.k(uri);
    }

    private static Uri di(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("An empty path was supplied.");
        }
        if (!string.startsWith("/")) {
            throw new IllegalArgumentException("A path must start with a single / .");
        }
        if (string.startsWith("//")) {
            throw new IllegalArgumentException("A path must start with a single / .");
        }
        return new Uri.Builder().scheme(WEAR_URI_SCHEME).path(string).build();
    }

    public Uri getUri() {
        return this.mUri;
    }

    public byte[] getData() {
        return this.aeA;
    }

    public PutDataRequest setData(byte[] data) {
        this.aeA = data;
        return this;
    }

    public Map<String, Asset> getAssets() {
        HashMap<String, Asset> hashMap = new HashMap<String, Asset>();
        for (String string : this.axk.keySet()) {
            hashMap.put(string, (Asset)this.axk.getParcelable(string));
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public Bundle rk() {
        return this.axk;
    }

    public Asset getAsset(String key) {
        return (Asset)this.axk.getParcelable(key);
    }

    public boolean hasAsset(String key) {
        return this.axk.containsKey(key);
    }

    public PutDataRequest putAsset(String key, Asset value) {
        jx.i((Object)key);
        jx.i((Object)value);
        this.axk.putParcelable(key, (Parcelable)value);
        return this;
    }

    public PutDataRequest removeAsset(String key) {
        this.axk.remove(key);
        return this;
    }

    public String toString() {
        return this.toString(Log.isLoggable((String)"DataMap", (int)3));
    }

    public String toString(boolean verbose) {
        StringBuilder stringBuilder = new StringBuilder("PutDataRequest[");
        stringBuilder.append("dataSz=" + (this.aeA == null ? "null" : Integer.valueOf(this.aeA.length)));
        stringBuilder.append(", numAssets=" + this.axk.size());
        stringBuilder.append(", uri=" + this.mUri);
        if (!verbose) {
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
        stringBuilder.append("]\n  assets: ");
        Set set = this.axk.keySet();
        for (String string : set) {
            stringBuilder.append("\n    " + string + ": " + this.axk.getParcelable(string));
        }
        stringBuilder.append("\n  ]");
        return stringBuilder.toString();
    }
}

