/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.text.TextUtils;
import com.google.android.gms.internal.r;
import com.google.android.gms.internal.s;
import com.google.android.gms.tagmanager.ab;
import com.google.android.gms.tagmanager.ak;
import com.google.android.gms.tagmanager.ap;
import com.google.android.gms.tagmanager.at;
import com.google.android.gms.tagmanager.au;
import com.google.android.gms.tagmanager.bh;
import com.google.android.gms.tagmanager.cy;
import com.google.android.gms.tagmanager.db;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;

class cb
implements at {
    private static final String jR = String.format("CREATE TABLE IF NOT EXISTS %s ( '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, '%s' INTEGER NOT NULL, '%s' TEXT NOT NULL,'%s' INTEGER NOT NULL);", "gtm_hits", "hit_id", "hit_time", "hit_url", "hit_first_send_time");
    private final b CY;
    private volatile ab CZ;
    private final au Da;
    private final Context mContext;
    private final String jU;
    private long jW;
    private r hw;
    private final int jX;

    cb(au au2, Context context) {
        this(au2, context, "gtm_urls.db", 2000);
    }

    cb(au au2, Context context, String string2, int n2) {
        this.mContext = context.getApplicationContext();
        this.jU = string2;
        this.Da = au2;
        this.hw = s.bU();
        this.CY = new b(this.mContext, this.jU);
        this.CZ = new db((HttpClient)new DefaultHttpClient(), this.mContext, new a());
        this.jW = 0L;
        this.jX = n2;
    }

    @Override
    public void b(long l2, String string2) {
        this.aB();
        this.aA();
        this.c(l2, string2);
    }

    private void aA() {
        int n2 = this.aC() - this.jX + 1;
        if (n2 > 0) {
            List<String> list = this.j(n2);
            bh.o("Store full, deleting " + list.size() + " hits to make room.");
            this.a(list.toArray(new String[0]));
        }
    }

    private void c(long l2, String string2) {
        SQLiteDatabase sQLiteDatabase = this.q("Error opening database for putHit");
        if (sQLiteDatabase == null) {
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("hit_time", Long.valueOf(l2));
        contentValues.put("hit_url", string2);
        contentValues.put("hit_first_send_time", Integer.valueOf(0));
        try {
            sQLiteDatabase.insert("gtm_hits", null, contentValues);
            this.Da.b(false);
        }
        catch (SQLiteException sQLiteException) {
            bh.p("Error storing hit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> j(int n2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n2 <= 0) {
            bh.p("Invalid maxHits specified. Skipping");
            return arrayList;
        }
        SQLiteDatabase sQLiteDatabase = this.q("Error opening database for peekHitIds.");
        if (sQLiteDatabase == null) {
            return arrayList;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("gtm_hits", new String[]{"hit_id"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n2));
            if (cursor.moveToFirst()) {
                do {
                    arrayList.add(String.valueOf(cursor.getLong(0)));
                } while (cursor.moveToNext());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ap> k(int n2) {
        ArrayList<ap> arrayList = new ArrayList<ap>();
        SQLiteDatabase sQLiteDatabase = this.q("Error opening database for peekHits");
        if (sQLiteDatabase == null) {
            return arrayList;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("gtm_hits", new String[]{"hit_id", "hit_time", "hit_first_send_time"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n2));
            arrayList = new ArrayList();
            if (cursor.moveToFirst()) {
                do {
                    ap ap2 = new ap(cursor.getLong(0), cursor.getLong(1), cursor.getLong(2));
                    arrayList.add(ap2);
                } while (cursor.moveToNext());
            }
        }
        int n3 = 0;
        try {
            CursorWindow cursorWindow;
            cursor = sQLiteDatabase.query("gtm_hits", new String[]{"hit_id", "hit_url"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n2));
            if (cursor.moveToFirst()) {
                do {
                    if ((cursorWindow = ((SQLiteCursor)cursor).getWindow()).getNumRows() > 0) {
                        ((ap)arrayList.get(n3)).l(cursor.getString(1));
                    } else {
                        bh.p(String.format("HitString for hitId %d too large.  Hit will be deleted.", ((ap)arrayList.get(n3)).au()));
                    }
                    ++n3;
                } while (cursor.moveToNext());
            }
            cursorWindow = arrayList;
            return cursorWindow;
        }
        catch (SQLiteException sQLiteException) {
            bh.p("Error in peekHits fetching hit url: " + sQLiteException.getMessage());
            ArrayList<ap> arrayList2 = new ArrayList<ap>();
            boolean bl2 = false;
            for (ap ap3 : arrayList) {
                if (TextUtils.isEmpty((CharSequence)ap3.fe())) {
                    if (bl2) break;
                    bl2 = true;
                }
                arrayList2.add(ap3);
            }
            ArrayList<ap> arrayList3 = arrayList2;
            return arrayList3;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    int aB() {
        long l2 = this.hw.currentTimeMillis();
        if (l2 <= this.jW + 86400000L) {
            return 0;
        }
        this.jW = l2;
        SQLiteDatabase sQLiteDatabase = this.q("Error opening database for deleteStaleHits.");
        if (sQLiteDatabase == null) {
            return 0;
        }
        long l3 = this.hw.currentTimeMillis() - 2592000000L;
        int n2 = sQLiteDatabase.delete("gtm_hits", "HIT_TIME < ?", new String[]{Long.toString(l3)});
        this.Da.b(this.aC() == 0);
        return n2;
    }

    void a(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        SQLiteDatabase sQLiteDatabase = this.q("Error opening database for deleteHits.");
        if (sQLiteDatabase == null) {
            return;
        }
        String string2 = String.format("HIT_ID in (%s)", TextUtils.join((CharSequence)",", Collections.nCopies(stringArray.length, "?")));
        try {
            sQLiteDatabase.delete("gtm_hits", string2, stringArray);
            this.Da.b(this.aC() == 0);
        }
        catch (SQLiteException sQLiteException) {
            bh.p("Error deleting hits");
        }
    }

    private void e(long l2) {
        this.a(new String[]{String.valueOf(l2)});
    }

    private void a(long l2, long l3) {
        SQLiteDatabase sQLiteDatabase = this.q("Error opening database for getNumStoredHits.");
        if (sQLiteDatabase == null) {
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("hit_first_send_time", Long.valueOf(l3));
        try {
            sQLiteDatabase.update("gtm_hits", contentValues, "hit_id=?", new String[]{String.valueOf(l2)});
        }
        catch (SQLiteException sQLiteException) {
            bh.p("Error setting HIT_FIRST_DISPATCH_TIME for hitId: " + l2);
            this.e(l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int aC() {
        int n2 = 0;
        SQLiteDatabase sQLiteDatabase = this.q("Error opening database for getNumStoredHits.");
        if (sQLiteDatabase == null) {
            return n2;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery("SELECT COUNT(*) from gtm_hits", null);
            if (cursor.moveToFirst()) {
                n2 = (int)cursor.getLong(0);
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int fr() {
        int n2 = 0;
        SQLiteDatabase sQLiteDatabase = this.q("Error opening database for getNumStoredHits.");
        if (sQLiteDatabase == null) {
            return n2;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("gtm_hits", new String[]{"hit_id", "hit_first_send_time"}, "hit_first_send_time=0", null, null, null, null);
            n2 = cursor.getCount();
        }
        return n2;
    }

    @Override
    public void dispatch() {
        bh.o("GTM Dispatch running...");
        if (!this.CZ.K()) {
            return;
        }
        List<ap> list = this.k(40);
        if (list.isEmpty()) {
            bh.o("...nothing to dispatch");
            this.Da.b(true);
            return;
        }
        this.CZ.g(list);
        if (this.fr() > 0) {
            cy.gh().dispatch();
        }
    }

    private SQLiteDatabase q(String string2) {
        SQLiteDatabase sQLiteDatabase = null;
        try {
            sQLiteDatabase = this.CY.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            bh.p(string2);
            return null;
        }
        return sQLiteDatabase;
    }

    class b
    extends SQLiteOpenHelper {
        private boolean jY;
        private long jZ;

        b(Context context, String string2) {
            super(context, string2, null, 1);
            this.jZ = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean a(String string2, SQLiteDatabase sQLiteDatabase) {
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string2}, null, null, null);
                boolean bl2 = cursor.moveToFirst();
                return bl2;
            }
        }

        public SQLiteDatabase getWritableDatabase() {
            if (this.jY && this.jZ + 3600000L > cb.this.hw.currentTimeMillis()) {
                throw new SQLiteException("Database creation failed");
            }
            SQLiteDatabase sQLiteDatabase = null;
            this.jY = true;
            this.jZ = cb.this.hw.currentTimeMillis();
            try {
                sQLiteDatabase = super.getWritableDatabase();
            }
            catch (SQLiteException sQLiteException) {
                cb.this.mContext.getDatabasePath(cb.this.jU).delete();
            }
            if (sQLiteDatabase == null) {
                sQLiteDatabase = super.getWritableDatabase();
            }
            this.jY = false;
            return sQLiteDatabase;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOpen(SQLiteDatabase db2) {
            if (Build.VERSION.SDK_INT < 15) {
                try (Cursor cursor = db2.rawQuery("PRAGMA journal_mode=memory", null);){
                    cursor.moveToFirst();
                }
            }
            if (!this.a("gtm_hits", db2)) {
                db2.execSQL(jR);
            } else {
                this.a(db2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void a(SQLiteDatabase sQLiteDatabase) {
            HashSet<String> hashSet = new HashSet<String>();
            try (Cursor cursor = sQLiteDatabase.rawQuery("SELECT * FROM gtm_hits WHERE 0", null);){
                String[] stringArray = cursor.getColumnNames();
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    hashSet.add(stringArray[i2]);
                }
            }
            if (!(hashSet.remove("hit_id") && hashSet.remove("hit_url") && hashSet.remove("hit_time") && hashSet.remove("hit_first_send_time"))) {
                throw new SQLiteException("Database column missing");
            }
            if (!hashSet.isEmpty()) {
                throw new SQLiteException("Database has extra columns");
            }
        }

        public void onCreate(SQLiteDatabase db2) {
            ak.h(db2.getPath());
        }

        public void onUpgrade(SQLiteDatabase db2, int oldVersion, int newVersion) {
        }
    }

    class a
    implements db.a {
        a() {
        }

        @Override
        public void a(ap ap2) {
            cb.this.e(ap2.au());
        }

        @Override
        public void b(ap ap2) {
            cb.this.e(ap2.au());
            bh.o("Permanent failure dispatching hitId: " + ap2.au());
        }

        @Override
        public void c(ap ap2) {
            long l2 = ap2.fd();
            if (l2 == 0L) {
                cb.this.a(ap2.au(), cb.this.hw.currentTimeMillis());
            } else if (l2 + 14400000L < cb.this.hw.currentTimeMillis()) {
                cb.this.e(ap2.au());
                bh.o("Giving up on failed hitId: " + ap2.au());
            }
        }
    }
}

