/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.dynamic.b;
import com.google.android.gms.maps.internal.v;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.e;
import com.google.android.gms.maps.model.f;

public final class GroundOverlayOptions
implements SafeParcelable {
    public static final e CREATOR = new e();
    public static final float NO_DIMENSION = -1.0f;
    private final int nZ;
    private BitmapDescriptor zW;
    private LatLng zX;
    private float zY;
    private float zZ;
    private LatLngBounds Aa;
    private float zM;
    private float zT;
    private boolean zU = true;
    private float Ab = 0.0f;
    private float Ac = 0.5f;
    private float Ad = 0.5f;

    GroundOverlayOptions(int versionCode, IBinder wrappedImage, LatLng location, float width, float height, LatLngBounds bounds, float bearing, float zIndex, boolean visible, float transparency, float anchorU, float anchorV) {
        this.nZ = versionCode;
        this.zW = new BitmapDescriptor(b.a.k(wrappedImage));
        this.zX = location;
        this.zY = width;
        this.zZ = height;
        this.Aa = bounds;
        this.zM = bearing;
        this.zT = zIndex;
        this.zU = visible;
        this.Ab = transparency;
        this.Ac = anchorU;
        this.Ad = anchorV;
    }

    public GroundOverlayOptions() {
        this.nZ = 1;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (v.em()) {
            f.a(this, out, flags);
        } else {
            e.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    IBinder eo() {
        return this.zW.dO().asBinder();
    }

    public GroundOverlayOptions image(BitmapDescriptor image) {
        this.zW = image;
        return this;
    }

    public GroundOverlayOptions anchor(float u2, float v2) {
        this.Ac = u2;
        this.Ad = v2;
        return this;
    }

    public GroundOverlayOptions position(LatLng location, float width) {
        m.a(this.Aa == null, (Object)"Position has already been set using positionFromBounds");
        m.b(location != null, (Object)"Location must be specified");
        m.b(width >= 0.0f, (Object)"Width must be non-negative");
        return this.a(location, width, -1.0f);
    }

    public GroundOverlayOptions position(LatLng location, float width, float height) {
        m.a(this.Aa == null, (Object)"Position has already been set using positionFromBounds");
        m.b(location != null, (Object)"Location must be specified");
        m.b(width >= 0.0f, (Object)"Width must be non-negative");
        m.b(height >= 0.0f, (Object)"Height must be non-negative");
        return this.a(location, width, height);
    }

    private GroundOverlayOptions a(LatLng latLng, float f2, float f3) {
        this.zX = latLng;
        this.zY = f2;
        this.zZ = f3;
        return this;
    }

    public GroundOverlayOptions positionFromBounds(LatLngBounds bounds) {
        m.a(this.zX == null, (Object)("Position has already been set using position: " + this.zX));
        this.Aa = bounds;
        return this;
    }

    public GroundOverlayOptions bearing(float bearing) {
        this.zM = (bearing % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public GroundOverlayOptions zIndex(float zIndex) {
        this.zT = zIndex;
        return this;
    }

    public GroundOverlayOptions visible(boolean visible) {
        this.zU = visible;
        return this;
    }

    public GroundOverlayOptions transparency(float transparency) {
        m.b(transparency >= 0.0f && transparency <= 1.0f, (Object)"Transparency must be in the range [0..1]");
        this.Ab = transparency;
        return this;
    }

    int getVersionCode() {
        return this.nZ;
    }

    public BitmapDescriptor getImage() {
        return this.zW;
    }

    public LatLng getLocation() {
        return this.zX;
    }

    public float getWidth() {
        return this.zY;
    }

    public float getHeight() {
        return this.zZ;
    }

    public LatLngBounds getBounds() {
        return this.Aa;
    }

    public float getBearing() {
        return this.zM;
    }

    public float getZIndex() {
        return this.zT;
    }

    public float getTransparency() {
        return this.Ab;
    }

    public float getAnchorU() {
        return this.Ac;
    }

    public float getAnchorV() {
        return this.Ad;
    }

    public boolean isVisible() {
        return this.zU;
    }
}

