/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.SystemClock;
import com.google.android.gms.common.internal.l;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.b;

public final class LocationRequest
implements SafeParcelable {
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_LOW_POWER = 104;
    public static final int PRIORITY_NO_POWER = 105;
    private final int nZ;
    int mPriority;
    long uy;
    long uz;
    boolean tz;
    long un;
    int uA;
    float uB;
    long uC;
    public static final b CREATOR = new b();

    public static LocationRequest create() {
        return new LocationRequest();
    }

    public LocationRequest() {
        this.nZ = 1;
        this.mPriority = 102;
        this.uy = 3600000L;
        this.uz = 600000L;
        this.tz = false;
        this.un = Long.MAX_VALUE;
        this.uA = Integer.MAX_VALUE;
        this.uB = 0.0f;
        this.uC = 0L;
    }

    public LocationRequest setPriority(int priority) {
        LocationRequest.aK(priority);
        this.mPriority = priority;
        return this;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public LocationRequest setInterval(long millis) {
        LocationRequest.b(millis);
        this.uy = millis;
        if (!this.tz) {
            this.uz = (long)((double)this.uy / 6.0);
        }
        return this;
    }

    public long getInterval() {
        return this.uy;
    }

    public LocationRequest setFastestInterval(long millis) {
        LocationRequest.b(millis);
        this.tz = true;
        this.uz = millis;
        return this;
    }

    public long getFastestInterval() {
        return this.uz;
    }

    public LocationRequest setExpirationDuration(long millis) {
        long l2 = SystemClock.elapsedRealtime();
        this.un = millis > Long.MAX_VALUE - l2 ? Long.MAX_VALUE : millis + l2;
        if (this.un < 0L) {
            this.un = 0L;
        }
        return this;
    }

    public LocationRequest setExpirationTime(long millis) {
        this.un = millis;
        if (this.un < 0L) {
            this.un = 0L;
        }
        return this;
    }

    public long getExpirationTime() {
        return this.un;
    }

    public LocationRequest setNumUpdates(int numUpdates) {
        if (numUpdates <= 0) {
            throw new IllegalArgumentException("invalid numUpdates: " + numUpdates);
        }
        this.uA = numUpdates;
        return this;
    }

    public int getNumUpdates() {
        return this.uA;
    }

    public LocationRequest setSmallestDisplacement(float smallestDisplacementMeters) {
        LocationRequest.a(smallestDisplacementMeters);
        this.uB = smallestDisplacementMeters;
        return this;
    }

    public float getSmallestDisplacement() {
        return this.uB;
    }

    private static void b(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("invalid interval: " + l2);
        }
    }

    private static void aK(int n2) {
        switch (n2) {
            case 100: 
            case 102: 
            case 104: 
            case 105: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid quality: " + n2);
            }
        }
    }

    private static void a(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("invalid displacement: " + f2);
        }
    }

    LocationRequest(int versionCode, int priority, long interval, long fastestInterval, boolean explicitFastestInterval, long expireAt, int numUpdates, float smallestDisplacement, long maxWaitTime) {
        this.nZ = versionCode;
        this.mPriority = priority;
        this.uy = interval;
        this.uz = fastestInterval;
        this.tz = explicitFastestInterval;
        this.un = expireAt;
        this.uA = numUpdates;
        this.uB = smallestDisplacement;
        this.uC = maxWaitTime;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        b.a(this, parcel, flags);
    }

    public static String aL(int n2) {
        switch (n2) {
            case 100: {
                return "PRIORITY_HIGH_ACCURACY";
            }
            case 102: {
                return "PRIORITY_BALANCED_POWER_ACCURACY";
            }
            case 104: {
                return "PRIORITY_LOW_POWER";
            }
            case 105: {
                return "PRIORITY_NO_POWER";
            }
        }
        return "???";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Request[").append(LocationRequest.aL(this.mPriority));
        if (this.mPriority != 105) {
            stringBuilder.append(" requested=");
            stringBuilder.append(this.uy + "ms");
        }
        stringBuilder.append(" fastest=");
        stringBuilder.append(this.uz + "ms");
        if (this.un != Long.MAX_VALUE) {
            long l2 = this.un - SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            stringBuilder.append(l2 + "ms");
        }
        if (this.uA != Integer.MAX_VALUE) {
            stringBuilder.append(" num=").append(this.uA);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return l.hashCode(this.mPriority, this.uy, this.uz, this.tz, this.un, this.uA, Float.valueOf(this.uB));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationRequest)) {
            return false;
        }
        LocationRequest locationRequest = (LocationRequest)object;
        return this.mPriority == locationRequest.mPriority && this.uy == locationRequest.uy && this.uz == locationRequest.uz && this.tz == locationRequest.tz && this.un == locationRequest.un && this.uA == locationRequest.uA && this.uB == locationRequest.uB;
    }

    int getVersionCode() {
        return this.nZ;
    }
}

