/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.os.Parcel;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.ActivityRecognitionResultCreator;
import com.google.android.gms.location.DetectedActivity;
import java.util.Collections;
import java.util.List;

public class ActivityRecognitionResult
implements SafeParcelable {
    public static final String EXTRA_ACTIVITY_RESULT = "com.google.android.location.internal.EXTRA_ACTIVITY_RESULT";
    public static final ActivityRecognitionResultCreator CREATOR = new ActivityRecognitionResultCreator();
    private final int nZ;
    List<DetectedActivity> uf;
    long ug;
    long uh;

    public ActivityRecognitionResult(List<DetectedActivity> probableActivities, long time, long elapsedRealtimeMillis) {
        m.b(probableActivities != null && probableActivities.size() > 0, (Object)"Must have at least 1 detected activity");
        m.b(time > 0L && elapsedRealtimeMillis > 0L, (Object)"Must set times");
        this.nZ = 1;
        this.uf = probableActivities;
        this.ug = time;
        this.uh = elapsedRealtimeMillis;
    }

    public ActivityRecognitionResult(DetectedActivity mostProbableActivity, long time, long elapsedRealtimeMillis) {
        this(Collections.singletonList(mostProbableActivity), time, elapsedRealtimeMillis);
    }

    public static boolean hasResult(Intent intent) {
        if (intent == null) {
            return false;
        }
        return intent.hasExtra(EXTRA_ACTIVITY_RESULT);
    }

    public static ActivityRecognitionResult extractResult(Intent intent) {
        if (!ActivityRecognitionResult.hasResult(intent)) {
            return null;
        }
        Object object = intent.getExtras().get(EXTRA_ACTIVITY_RESULT);
        if (object instanceof byte[]) {
            Parcel parcel = Parcel.obtain();
            parcel.unmarshall((byte[])object, 0, ((byte[])object).length);
            parcel.setDataPosition(0);
            return CREATOR.createFromParcel(parcel);
        }
        if (object instanceof ActivityRecognitionResult) {
            return (ActivityRecognitionResult)object;
        }
        return null;
    }

    public DetectedActivity getMostProbableActivity() {
        return this.uf.get(0);
    }

    public int getActivityConfidence(int activityType) {
        for (DetectedActivity detectedActivity : this.uf) {
            if (detectedActivity.getType() != activityType) continue;
            return detectedActivity.getConfidence();
        }
        return 0;
    }

    public List<DetectedActivity> getProbableActivities() {
        return this.uf;
    }

    public long getTime() {
        return this.ug;
    }

    public long getElapsedRealtimeMillis() {
        return this.uh;
    }

    public String toString() {
        return "ActivityRecognitionResult [probableActivities=" + this.uf + ", timeMillis=" + this.ug + ", elapsedRealtimeMillis=" + this.uh + "]";
    }

    public ActivityRecognitionResult(int versionCode, List<DetectedActivity> probableActivities, long timeMillis, long elapsedRealtimeMillis) {
        this.nZ = 1;
        this.uf = probableActivities;
        this.ug = timeMillis;
        this.uh = elapsedRealtimeMillis;
    }

    public int getVersionCode() {
        return this.nZ;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        ActivityRecognitionResultCreator.a(this, out, flags);
    }
}

